/*
 * Copyright 1991-1998, Brown University, Providence, RI.
 * 
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose other than its incorporation into a
 * commercial product is hereby granted without fee, provided that the
 * above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Brown University not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * BROWN UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR ANY
 * PARTICULAR PURPOSE.  IN NO EVENT SHALL BROWN UNIVERSITY BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
/************************************************************************
*									*
*  xmcp.h								*
*									*
*	X Multiplexor Control Protocol definitions.			*
*									*
************************************************************************/
#ifndef XMCP_H
#define XMCP_H

#define XMC_MAJOR_VERSION	3
#define XMC_MINOR_VERSION	0

#define XMC_TCP_PORT		5999	/* X_TCP_PORT minus one */
#define XMC_UNIX_DIR		"/tmp/.XMC-unix"
#define XMC_UNIX_PATH		"/tmp/.XMC-unix/M"

#define XMC_Error		0
#define XMC_Reply		1

/*
**	Sizes
*/
#define sz_xmcDepthType			(sizeof(xmcDepthType))
#define sz_xmcClientConn		(sizeof(xmcClientConn))
#define sz_xmcServerConn		(sizeof(xmcServerConn))
#define sz_xmcReq			(sizeof(xmcReq))
#define sz_xmcIdReq			(sizeof(xmcIdReq))
#define sz_xmcRegisterReq		(sizeof(xmcRegisterReq))
#define sz_xmcUnregisterReq		(sizeof(xmcUnregisterReq))
#define sz_xmcSetAuthReq		(sizeof(xmcSetAuthReq))
#define sz_xmcGetAuthReq		(sizeof(xmcGetAuthReq))
#define sz_xmcAddDisplayReq		(sizeof(xmcAddDisplayReq))
#define sz_xmcSetDisplayTagReq		(sizeof(xmcSetDisplayTagReq))
#define sz_xmcQueryDisplayReq		(sizeof(xmcQueryDisplayReq))
#define sz_xmcListDisplaysReq		(sizeof(xmcListDisplaysReq))
#define sz_xmcListDisplaysWithInfoReq	(sizeof(xmcListDisplaysWithInfoReq))
#define sz_xmcDropDisplayReq		(sizeof(xmcDropDisplayReq))
#define sz_xmcSyncReq			(sizeof(xmcSyncReq))
#define sz_xmcSetConfigReq		(sizeof(xmcSetConfigReq))
#define sz_xmcGetConfigReq		(sizeof(xmcGetConfigReq))
#define sz_xmcSetConfigModeReq		(sizeof(xmcSetConfigModeReq))
#define sz_xmcChangeInputModeReq	(sizeof(xmcChangeInputModeReq))
#define sz_xmcSetEventMaskReq		(sizeof(xmcSetEventMaskReq))
#define sz_xmcGetEventMaskReq		(sizeof(xmcGetEventMaskReq))
#define sz_xmcSetXEventMaskReq		(sizeof(xmcSetXEventMaskReq))
#define sz_xmcGetXEventMaskReq		(sizeof(xmcGetXEventMaskReq))
#define sz_xmcGrabPointerReq		(sizeof(xmcGrabPointerReq))
#define sz_xmcUngrabPointerReq		(sizeof(xmcUngrabPointerReq))
#define sz_xmcGrabKeyboardReq		(sizeof(xmcGrabKeyboardReq))
#define sz_xmcUngrabKeyboardReq		(sizeof(xmcUngrabKeyboardReq))
#define sz_xmcShareSelectionsReq	(sizeof(xmcShareSelectionsReq))
#define sz_xmcUnshareSelectionsReq	(sizeof(xmcUnshareSelectionsReq))
#define sz_xmcCreateTptrReq		(sizeof(xmcCreateTptrReq))
#define sz_xmcCreateGlyphTptrReq	(sizeof(xmcCreateGlyphTptrReq))
#define sz_xmcDestroyTptrReq		(sizeof(xmcDestroyTptrReq))
#define sz_xmcAssignTptrReq		(sizeof(xmcAssignTptrReq))
#define sz_xmcHideTptrReq		(sizeof(xmcHideTptrReq))
#define sz_xmcShowTptrReq		(sizeof(xmcShowTptrReq))
#define sz_xmcReply			(sizeof(xmcReply))
#define sz_xmcGetAuthReply		(sizeof(xmcGetAuthReply))
#define sz_xmcQueryDisplayReply		(sizeof(xmcQueryDisplayReply))
#define sz_xmcListDisplaysReply		(sizeof(xmcListDisplaysReply))
#define sz_xmcListDisplaysWithInfoReply	(sizeof(xmcListDisplaysWithInfoReply))
#define sz_xmcSyncReply			(sizeof(xmcSyncReply))
#define sz_xmcGetConfigReply		(sizeof(xmcGetConfigReply))
#define sz_xmcGetEventMaskReply		(sizeof(xmcGetEventMaskReply))
#define sz_xmcGetXEventMaskReply	(sizeof(xmcGetXEventMaskReply))
#define sz_xmcEvent			(sizeof(xmcEvent))
#define sz_xmcError			(sizeof(xmcEvent))

/*
**	Basic Types
**
**	Cleverly chosen to avoid conflicts with X11 header files.
*/
typedef long int		INT_32;
typedef short int		INT_16;
typedef char			INT_8;
typedef unsigned long int	CARD_32;
typedef unsigned short int	CARD_16;
typedef unsigned char		CARD_8;

typedef CARD_32			REGID;
typedef CARD_32			DISPID;
typedef CARD_32			TPTRID;
typedef CARD_32			WINDOW;

/*
**	Macros
*/
#define PAD(A)		((4 - ((A) % (unsigned int)4)) % 4)

/*
**	Requests
*/
#define XMC_Register			2
#define XMC_Unregister			3
#define XMC_SetAuth			4
#define XMC_GetAuth			5
#define XMC_AddDisplay			6
#define XMC_SetDisplayTag		7
#define XMC_QueryDisplay		8
#define XMC_ListDisplays		9
#define XMC_ListDisplaysWithInfo	10
#define XMC_DropDisplay			11
#define XMC_Sync			12
#define XMC_SetConfig			13
#define XMC_GetConfig			14
#define XMC_SetConfigMode		15
#define XMC_ChangeInputMode		16
#define XMC_SetEventMask		17
#define XMC_GetEventMask		18
#define XMC_SetXEventMask		19
#define XMC_GetXEventMask		20
#define XMC_GrabPointer			21
#define XMC_UngrabPointer		22
#define XMC_GrabKeyboard		23
#define XMC_UngrabKeyboard		24
#define XMC_ShareSelections		25
#define XMC_UnshareSelections		26
#define XMC_CreateTptr			27
#define XMC_CreateGlyphTptr		28
#define XMC_DestroyTptr			29
#define XMC_AssignTptr			30
#define XMC_HideTptr			31
#define XMC_ShowTptr			32

typedef struct {
	CARD_8		depth;
	CARD_8		visualClass;
}xmcDepthType;

/************************************************************************
*									*
*  Connection Blocks							*
*									*
************************************************************************/
typedef struct {
	CARD_8		byteOrder;
	CARD_8		pad0;
	CARD_16		majorVersion;
	CARD_16		minorVersion;
	CARD_16		nBytesAuthName;
	CARD_16		nBytesAuthData;
	CARD_16		pad1;
}xmcClientConn;

typedef struct {
	CARD_8		success;
	CARD_8		configMode;
	CARD_16		nBytesReason;
	CARD_32		base;
	CARD_32		mask;
	TPTRID		deftpID;
}xmcServerConn;

/************************************************************************
*									*
*  Requests								*
*									*
************************************************************************/
typedef struct {
	CARD_8		code;
	CARD_8		pad0;
	CARD_16		length;
}xmcReq;

typedef struct {
	CARD_8		code;
	CARD_8		pad0;
	CARD_16		length;
	CARD_32		id;
}xmcIdReq;

typedef struct {
	CARD_8		code;
	CARD_8		family;
	CARD_16		length;
	REGID		regID;
	CARD_16		port;
	CARD_16		nBytesAddress;
	CARD_16		nBytesName;
	CARD_16		nBytesURL;
	CARD_16		nBytesDesc;
	CARD_16		pad;
}xmcRegisterReq;

typedef xmcIdReq xmcUnregisterReq;

typedef struct {
	CARD_8		code;
	CARD_8		pad;
	CARD_16		length;
	CARD_32		pMask;
	CARD_16		nBytesName;
	CARD_16		nBytesData;
}xmcSetAuthReq;

typedef struct {
	CARD_8		code;
	CARD_8		pad;
	CARD_16		length;
	CARD_16		nBytesName;
	CARD_16		nBytesData;
}xmcGetAuthReq;

typedef struct {
	CARD_8		code;
	CARD_8		mode;
	CARD_16		length;
	DISPID		dispID;
	CARD_16		screen;
	CARD_8		family;
	CARD_8		configMode;
	CARD_16		nBytesAddress;
	CARD_16		displayNumber;
	WINDOW		window;
	CARD_16		nBytesGeom;
	CARD_16		nBytesTag;
	CARD_16		nBytesName;
	CARD_16		nBytesData;
	TPTRID		tpID;
}xmcAddDisplayReq;

typedef struct {
	CARD_8		code;
	CARD_8		pad0;
	CARD_16		length;
	DISPID		dispID;
	CARD_16		nBytesTag;
	CARD_16		pad1;
}xmcSetDisplayTagReq;

typedef xmcIdReq xmcQueryDisplayReq;
typedef xmcReq xmcListDisplaysReq;
typedef xmcReq xmcListDisplaysWithInfoReq;
typedef xmcIdReq xmcDropDisplayReq;

typedef xmcReq xmcSyncReq;

typedef struct {
	CARD_8		code;
	CARD_8		pad0;
	CARD_16		length;
	CARD_16		width;
	CARD_16		height;
	CARD_16		nDepthTypes;
	CARD_16		nExtensions;
}xmcSetConfigReq;

typedef xmcReq xmcGetConfigReq;

typedef struct {
	CARD_8		code;
	CARD_8		mode;
	CARD_16		length;
}xmcSetConfigModeReq;

typedef struct {
	CARD_8		code;
	CARD_8		mode;
	CARD_16		length;
	DISPID		dispID;
}xmcChangeInputModeReq;

typedef struct {
	CARD_8		code;
	CARD_8		pad0;
	CARD_16		length;
	CARD_32		mask;
}xmcSetEventMaskReq;

typedef xmcReq xmcGetEventMaskReq;

typedef struct {
	CARD_8		code;
	CARD_8		pad0;
	CARD_16		length;
	WINDOW		window;
	CARD_32		mask;
}xmcSetXEventMaskReq;

typedef xmcIdReq xmcGetXEventMaskReq;

typedef xmcIdReq xmcGrabPointerReq;
typedef xmcIdReq xmcUngrabPointerReq;
typedef xmcIdReq xmcGrabKeyboardReq;
typedef xmcIdReq xmcUngrabKeyboardReq;

typedef xmcIdReq xmcShareSelectionsReq;
typedef xmcIdReq xmcUnshareSelectionsReq;

typedef struct {
	CARD_8		code;
	CARD_8		mask;
	CARD_16		length;
	TPTRID		tpID;
	CARD_32		srcID;
	CARD_32		mskID;
	INT_16		hotx;
	INT_16		hoty;
	CARD_16		foreRed;
	CARD_16		foreGreen;
	CARD_16		foreBlue;
	CARD_16		backRed;
	CARD_16		backGreen;
	CARD_16		backBlue;
}xmcCreateTptrReq;

typedef struct {
	CARD_8		code;
	CARD_8		mask;
	CARD_16		length;
	TPTRID		tpID;
	CARD_32		srcID;
	CARD_32		mskID;
	CARD_16		srcChar;
	CARD_16		mskChar;
	CARD_16		foreRed;
	CARD_16		foreGreen;
	CARD_16		foreBlue;
	CARD_16		backRed;
	CARD_16		backGreen;
	CARD_16		backBlue;
}xmcCreateGlyphTptrReq;

typedef xmcIdReq xmcDestroyTptrReq;

typedef struct {
	CARD_8		code;
	CARD_8		pad0;
	CARD_16		length;
	DISPID		dispID;
	TPTRID		tpID;
}xmcAssignTptrReq;

typedef xmcIdReq xmcHideTptrReq;
typedef xmcIdReq xmcShowTptrReq;

/************************************************************************
*									*
*  Replies								*
*									*
************************************************************************/
typedef struct {
	CARD_8		reply;
	CARD_8		pad;
	CARD_16		seqNo;
	CARD_32		length;
}xmcReply;

typedef struct {
	CARD_8		reply;
	CARD_8		pad;
	CARD_16		seqNo;
	CARD_32		length;
	CARD_32		pMask;
}xmcGetAuthReply;

typedef struct {
	CARD_8		reply;
	CARD_8		family;
	CARD_16		seqNo;
	CARD_32		length;
	CARD_32		pad0;
	CARD_16		nBytesAddress;
	CARD_16		displayNumber;
	CARD_8		mode;
	CARD_8		pad1;
	CARD_16		nBytesTag;
	TPTRID		tpID;
	WINDOW		window;
	CARD_16		screen;
	CARD_16		pad2;
}xmcQueryDisplayReply;

typedef struct {
	CARD_8		reply;
	CARD_8		pad0;
	CARD_16		seqNo;
	CARD_32		length;
	CARD_16		nDisplays;
	CARD_16		pad1;
}xmcListDisplaysReply;

typedef struct {
	CARD_8		reply;
	CARD_8		family;
	CARD_16		seqNo;
	CARD_32		length;
	DISPID		dispID;
	CARD_16		nBytesAddress;
	CARD_16		displayNumber;
	CARD_8		mode;
	CARD_8		pad0;
	CARD_16		nBytesTag;
	TPTRID		tpID;
	WINDOW		window;
	CARD_16		screen;
	CARD_16		count;	/* how many more? if zero, last reply */
}xmcListDisplaysWithInfoReply;

typedef xmcReply xmcSyncReply;

typedef struct {
	CARD_8		reply;
	CARD_8		pad0;
	CARD_16		seqNo;
	CARD_32		length;
	CARD_16		width;
	CARD_16		height;
	CARD_16		nDepthTypes;
	CARD_16		nExtensions;
}xmcGetConfigReply;

typedef struct {
	CARD_8		reply;
	CARD_8		pad0;
	CARD_16		seqNo;
	CARD_32		length;
	CARD_32		mask;
}xmcGetEventMaskReply;

typedef	xmcGetEventMaskReply xmcGetXEventMaskReply;

/************************************************************************
*									*
*  Events								*
*									*
************************************************************************/
typedef struct {
	CARD_8		code;
	CARD_8		pad0;
	CARD_16		seqNo;
	DISPID		dispID;
}xmcDisplayIdEvent;

typedef struct {
	CARD_8		code;
	CARD_8		detail;
	CARD_16		seqNo;
	DISPID		dispID;
	CARD_32		time;
	CARD_32		event;
	CARD_32		child;
	INT_16		rootX;
	INT_16		rootY;
	INT_16		eventX;
	INT_16		eventY;
	CARD_16		state;
	CARD_16		pad;
}xmcKeyButtonEvent;

typedef struct {
	CARD_8		code;
	CARD_8		pad0;
	CARD_16		seqNo;
	DISPID		dispID;
	TPTRID		tpID;
}xmcTptrAssignEvent;

typedef struct {
	CARD_8		code;
	CARD_8		pad0;
	CARD_16		seqNo;
	TPTRID		tpID;
}xmcTptrEvent;

typedef struct {
	CARD_8		code;
	CARD_8		mode;
	CARD_16		seqNo;
}xmcConfigModeEvent;

typedef union {
        struct {
		CARD_8		code;
		CARD_8		pad0;
		CARD_16		seqNo;
	}u;
	xmcDisplayIdEvent	display;
	xmcKeyButtonEvent	keyButton;
	xmcTptrAssignEvent	tptrAssign;
	xmcTptrEvent		tptr;
	xmcConfigModeEvent	config;
}xmcEvent;

/************************************************************************
*									*
*  Errors								*
*									*
************************************************************************/
typedef struct {
	CARD_8		code;
	CARD_8		errorCode;
        CARD_16		seqNo;
	CARD_8		opcode;
        CARD_8		pad0;
        CARD_16		pad1;
	CARD_32		data;
}xmcError;

#endif /* XMCP_H */
