/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.cabinet;

import com.aimluck.eip.cabinet.CabinetFolderResultData;
import com.aimluck.eip.cabinet.FolderInfo;
import com.aimluck.eip.cabinet.util.CabinetUtils;
import com.aimluck.eip.cayenne.om.portlet.EipTCabinetFolder;
import com.aimluck.eip.cayenne.om.portlet.EipTCabinetFolderMap;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class CabinetFolderSelectData
extends ALAbstractSelectData<EipTCabinetFolder, EipTCabinetFolder> {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)CabinetFolderSelectData.class.getName());
    private List<ALEipUser> members;
    int folder_id = 0;
    private RunData rundata;
    private FolderInfo selected_folderinfo = null;
    private List<FolderInfo> folder_hierarchy_list;
    private boolean isAccessible = true;
    private boolean isEditable = true;
    private boolean isNormalContext = false;

    public void setIsNormalContext(boolean flg) {
        this.isNormalContext = flg;
    }

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        int fid;
        block18: {
            String tmpfid;
            String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
            if (sort == null || sort.equals("")) {
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p3c-sort"));
                logger.debug((Object)("[CabinetSelectData] Init Parameter. : " + ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p3c-sort")));
            }
            fid = 1;
            if (this.isNormalContext) {
                if (ALEipUtils.isMatch((RunData)rundata, (Context)context) && rundata.getParameters().containsKey((Object)"folder_id")) {
                    ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"folder_id", (String)rundata.getParameters().getString("folder_id"));
                }
                if ((tmpfid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"folder_id")) != null && !"".equals(tmpfid)) {
                    try {
                        fid = Integer.parseInt(tmpfid);
                        if (fid == 0) {
                            this.isAccessible = true;
                            this.isEditable = true;
                            break block18;
                        }
                        this.isAccessible = CabinetUtils.isAccessibleFolder(fid, rundata);
                        this.isEditable = CabinetUtils.isEditableFolder(fid, rundata);
                    }
                    catch (Exception e) {
                        fid = 1;
                    }
                } else {
                    String id = ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p3a-folder");
                    fid = Integer.parseInt(id);
                }
            } else {
                if (ALEipUtils.isMatch((RunData)rundata, (Context)context) && rundata.getParameters().containsKey((Object)"folder_id")) {
                    ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"folder_id", (String)rundata.getParameters().getString("folder_id"));
                }
                if ((tmpfid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"folder_id")) != null && !"".equals(tmpfid)) {
                    try {
                        fid = Integer.parseInt(tmpfid);
                        if (fid == 0) {
                            this.isAccessible = true;
                            this.isEditable = true;
                        } else {
                            this.isAccessible = CabinetUtils.isAccessibleFolder(fid, rundata);
                            this.isEditable = CabinetUtils.isEditableFolder(fid, rundata);
                        }
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        fid = 1;
                    }
                }
            }
        }
        this.folder_hierarchy_list = CabinetUtils.getFolderList();
        if (this.folder_hierarchy_list != null && this.folder_hierarchy_list.size() > 0) {
            int size = this.folder_hierarchy_list.size();
            for (int i = 0; i < size; ++i) {
                FolderInfo info = this.folder_hierarchy_list.get(i);
                if (info.getFolderId() != fid) continue;
                this.selected_folderinfo = info;
                break;
            }
        }
        this.members = new ArrayList<ALEipUser>();
        this.rundata = rundata;
        super.init(action, rundata, context);
    }

    protected ResultList<EipTCabinetFolder> selectList(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        CabinetUtils.setFolderVisible(this.folder_hierarchy_list, this.selected_folderinfo, rundata);
        return null;
    }

    protected EipTCabinetFolder selectDetail(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        return CabinetUtils.getEipTCabinetFolder(rundata, context);
    }

    public void loadFolderList() {
        this.folder_hierarchy_list = CabinetUtils.getFolderList();
    }

    protected Object getResultData(EipTCabinetFolder obj) throws ALPageNotFoundException, ALDBErrorException {
        return null;
    }

    protected Object getResultDataDetail(EipTCabinetFolder record) throws ALPageNotFoundException, ALDBErrorException {
        try {
            int access_control_folder_id;
            this.folder_id = record.getFolderId();
            CabinetFolderResultData rd = new CabinetFolderResultData();
            rd.initField();
            rd.setFolderId(record.getFolderId().longValue());
            rd.setFolderName(record.getFolderName());
            rd.setNote(record.getNote());
            rd.setPosition(CabinetUtils.getFolderPosition(this.folder_hierarchy_list, this.folder_id));
            int tmp_public_flag = Integer.valueOf(record.getPublicFlag());
            if (tmp_public_flag == 0) {
                access_control_folder_id = CabinetUtils.getAccessControlFolderId(record.getParentId());
                rd.setAccessFlag(Integer.valueOf(CabinetUtils.getFolderByPK(access_control_folder_id).getPublicFlag()));
            } else {
                rd.setAccessFlag(tmp_public_flag);
                access_control_folder_id = (int)rd.getFolderId().getValue();
            }
            String createUserName = "";
            ALEipUser createUser = ALEipUtils.getALEipUser((int)record.getCreateUserId());
            if (createUser != null) {
                createUserName = createUser.getAliasName().getValue();
            }
            rd.setCreateUser(createUserName);
            rd.setCreateUserId(record.getCreateUserId().intValue());
            rd.setCreateDate(new SimpleDateFormat(ALLocalizationUtils.getl10n((String)"CABINET_YEAR_MONTH_DAY")).format(record.getCreateDate()));
            String updateUserName = "";
            ALEipUser updateUser = ALEipUtils.getALEipUser((int)record.getUpdateUserId());
            if (updateUser != null) {
                updateUserName = updateUser.getAliasName().getValue();
            }
            SelectQuery mapquery = Database.query(EipTCabinetFolderMap.class);
            Expression mapexp = ExpressionFactory.matchDbExp((String)"eipTCabinetFolder", (Object)access_control_folder_id);
            mapquery.setQualifier(mapexp);
            List list = mapquery.fetchList();
            ArrayList<Integer> users = new ArrayList<Integer>();
            for (int i = 0; i < list.size(); ++i) {
                EipTCabinetFolderMap map = (EipTCabinetFolderMap)list.get(i);
                users.add(map.getUserId());
            }
            SelectQuery query = Database.query(TurbineUser.class);
            Expression exp = ExpressionFactory.inDbExp((String)"USER_ID", users);
            Expression nonDisabledexp = ExpressionFactory.noMatchExp((String)"disabled", (Object)"T");
            query.setQualifier(exp.andExp(nonDisabledexp));
            this.members.addAll(ALEipUtils.getUsersFromSelectQuery((SelectQuery)query));
            rd.setUpdateUser(updateUserName);
            rd.setUpdateUserId(record.getUpdateUserId().intValue());
            rd.setUpdateDate(new SimpleDateFormat(ALLocalizationUtils.getl10n((String)"CABINET_YEAR_MONTH_DAY_HOUR_MINUTE")).format(record.getUpdateDate()));
            int size = this.folder_hierarchy_list.size();
            for (int i = 0; i < size; ++i) {
                FolderInfo info = this.folder_hierarchy_list.get(i);
                if (info.getFolderId() != record.getFolderId().intValue()) continue;
                rd.setCanUpdate(info.canUpdate());
                break;
            }
            this.isEditable = CabinetUtils.isEditableFolder(record.getFolderId(), this.rundata);
            return rd;
        }
        catch (RuntimeException ex) {
            logger.error((Object)"cabinet", (Throwable)ex);
            return null;
        }
        catch (Exception ex) {
            logger.error((Object)"cabinet", (Throwable)ex);
            return null;
        }
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        return map;
    }

    public int getFolderId() {
        return this.folder_id;
    }

    public List<FolderInfo> getFolderHierarchyList() {
        return this.folder_hierarchy_list;
    }

    public FolderInfo getSelectedFolderInfo() {
        return this.selected_folderinfo;
    }

    public List<ALEipUser> getMemberList() {
        return this.members;
    }

    public String getAclPortletFeature() {
        return "cabinet_file";
    }

    public boolean isAccessible() {
        return this.isAccessible;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean isEditable) {
        this.isEditable = isEditable;
    }
}

