/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.cabinet;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cabinet.CabinetFileResultData;
import com.aimluck.eip.cabinet.FolderInfo;
import com.aimluck.eip.cabinet.util.CabinetUtils;
import com.aimluck.eip.cayenne.om.portlet.EipTCabinetFile;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipGroup;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipPost;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class CabinetSelectData
extends ALAbstractSelectData<EipTCabinetFile, EipTCabinetFile> {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)CabinetSelectData.class.getName());
    private FolderInfo selected_folderinfo = null;
    private List<FolderInfo> folder_hierarchy_list;
    private int fileSum;
    private boolean isAccessible = true;
    private boolean isEditable = true;
    private boolean isNormalContext = false;
    private int table_colum_num;
    private RunData rundata;
    private List<ALEipGroup> myGroupList;
    private String post_name;
    private String post_alias_name;
    private ALStringField target_keyword;
    protected boolean isFileUploadable;

    public void setIsNormalContext(boolean flg) {
        this.isNormalContext = flg;
    }

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String id;
        String tmpfid;
        String fidParam;
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        if (sort == null || sort.equals("")) {
            try {
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p1c-sort"));
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)"update_date");
            }
        }
        int fid = 0;
        if (this.isNormalContext) {
            if (ALEipUtils.isMatch((RunData)rundata, (Context)context) && rundata.getParameters().containsKey((Object)"folder_id")) {
                fidParam = rundata.getParameters().getString("folder_id");
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"folder_id", (String)fidParam);
                ALEipUtils.setPsmlParameters((RunData)rundata, (Context)context, (String)"p3a-folder", (String)fidParam);
            }
            if ((tmpfid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"folder_id")) != null && !"".equals(tmpfid)) {
                try {
                    fid = Integer.parseInt(tmpfid);
                    if (fid == 0) {
                        this.isAccessible = true;
                        this.isEditable = true;
                    }
                    this.isAccessible = CabinetUtils.isAccessibleFolder(fid, rundata);
                    this.isEditable = CabinetUtils.isEditableFolder(fid, rundata);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    fid = 1;
                }
            } else if (this.table_colum_num == 2 || this.table_colum_num == 4) {
                id = ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p3a-folder");
                fid = Integer.parseInt(id);
            }
        } else {
            if (ALEipUtils.isMatch((RunData)rundata, (Context)context) && rundata.getParameters().containsKey((Object)"folder_id")) {
                fidParam = rundata.getParameters().getString("folder_id");
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"folder_id", (String)fidParam);
                ALEipUtils.setPsmlParameters((RunData)rundata, (Context)context, (String)"p3a-folder", (String)fidParam);
            }
            if ((tmpfid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"folder_id")) != null && !"".equals(tmpfid)) {
                try {
                    fid = Integer.parseInt(tmpfid);
                    if (fid == 0) {
                        this.isAccessible = true;
                        this.isEditable = true;
                    }
                    this.isAccessible = CabinetUtils.isAccessibleFolder(fid, rundata);
                    this.isEditable = CabinetUtils.isEditableFolder(fid, rundata);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    fid = 1;
                }
            } else {
                id = ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p3a-folder");
                if (id != null && !"".equals(id)) {
                    try {
                        fid = Integer.parseInt(id);
                    }
                    catch (Exception e) {
                        fid = 1;
                    }
                }
            }
        }
        List myGroups = ALEipUtils.getMyGroups((RunData)rundata);
        this.myGroupList = new ArrayList<ALEipGroup>();
        int length = myGroups.size();
        for (int i = 0; i < length; ++i) {
            this.myGroupList.add((ALEipGroup)myGroups.get(i));
        }
        if (rundata.getParameters().containsKey((Object)"post_name")) {
            String tmppid;
            this.post_name = tmppid = rundata.getParameters().getString("post_name");
            ALEipUtils.setPsmlParameters((RunData)rundata, (Context)context, (String)"p3b-post", (String)this.post_name);
        } else {
            try {
                this.post_name = ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p3b-post");
            }
            catch (Exception e) {
                this.post_name = "";
            }
        }
        if (this.post_name == null) {
            this.post_name = "";
        }
        this.updatePostNames();
        this.folder_hierarchy_list = CabinetUtils.getFolderList();
        if (this.folder_hierarchy_list != null && this.folder_hierarchy_list.size() > 0) {
            int size = this.folder_hierarchy_list.size();
            for (int i = 0; i < size; ++i) {
                FolderInfo info = this.folder_hierarchy_list.get(i);
                if (info.getFolderId() != fid) continue;
                this.selected_folderinfo = info;
                break;
            }
        }
        this.rundata = rundata;
        this.target_keyword = new ALStringField();
        super.init(action, rundata, context);
        this.isFileUploadable = ALEipUtils.isFileUploadable((RunData)rundata);
    }

    protected ResultList<EipTCabinetFile> selectList(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        try {
            if (CabinetUtils.hasResetFlag(rundata, context)) {
                CabinetUtils.resetFilter(rundata, context, ((Object)((Object)this)).getClass().getName());
                this.target_keyword.setValue("");
                this.post_name = "0";
                ALEipUtils.setPsmlParameters((RunData)rundata, (Context)context, (String)"p3b-post", (String)this.post_name);
                this.updatePostNames();
            } else {
                this.target_keyword.setValue(CabinetUtils.getTargetKeyword(rundata, context));
            }
            CabinetUtils.setFolderVisible(this.folder_hierarchy_list, this.selected_folderinfo, rundata);
            SelectQuery<EipTCabinetFile> query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            String tmpsort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
            if (tmpsort != null && "update_date".equals(tmpsort) && ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_TYPE_STR) == null) {
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_TYPE_STR, (String)"desc");
            }
            this.buildSelectQueryForListViewSort(query, rundata, context);
            ResultList list = query.getResultList();
            if (list == null) {
                return new ResultList(new ArrayList());
            }
            this.fileSum = list.size();
            return list;
        }
        catch (Exception ex) {
            logger.error((Object)"cabinet", (Throwable)ex);
            return null;
        }
    }

    private SelectQuery<EipTCabinetFile> getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = Database.query(EipTCabinetFile.class);
        if (this.selected_folderinfo != null) {
            Expression exp = ExpressionFactory.matchDbExp((String)"FOLDER_ID", (Object)this.selected_folderinfo.getFolderId());
            query.setQualifier(exp);
        } else {
            List<Integer> ids = CabinetUtils.getAuthorizedVisibleFolderIds(rundata);
            if (ids.size() == 0) {
                ids.add(-1);
            }
            Expression exp = ExpressionFactory.inExp((String)"folderId", ids);
            query.andQualifier(exp);
        }
        if (this.target_keyword != null && !this.target_keyword.getValue().equals("")) {
            String keyword = "%" + this.target_keyword.getValue() + "%";
            Expression target_exp1 = ExpressionFactory.likeExp((String)"fileName", (Object)keyword);
            Expression target_exp2 = ExpressionFactory.likeExp((String)"fileTitle", (Object)keyword);
            Expression expression = ExpressionFactory.likeExp((String)"note", (Object)keyword);
            query.andQualifier(target_exp1.orExp(target_exp2.orExp(expression)));
        }
        if (!this.post_name.equals("") && !this.post_name.equals("0")) {
            boolean existPost = false;
            for (int i = 0; i < this.myGroupList.size(); ++i) {
                String pid = this.myGroupList.get(i).getName().toString();
                if (!pid.equals(this.post_name)) continue;
                existPost = true;
                break;
            }
            Map map = ALEipManager.getInstance().getPostMap();
            for (Map.Entry entry : map.entrySet()) {
                String pid = ((ALEipPost)entry.getValue()).getGroupName().toString();
                if (!pid.equals(this.post_name)) continue;
                existPost = true;
                break;
            }
            if (existPost) {
                HashSet userIds = new HashSet();
                List list = ALEipUtils.getUserIds((String)this.post_name);
                if (list.isEmpty()) {
                    list.add(-1);
                }
                userIds.addAll(list);
                Expression exp = ExpressionFactory.inExp((String)"createUserId", userIds);
                query.andQualifier(exp);
            } else {
                this.post_name = "0";
                this.updatePostNames();
            }
        }
        query.distinct(true);
        return this.buildSelectQueryForFilter(query, rundata, context);
    }

    protected EipTCabinetFile selectDetail(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        return CabinetUtils.getEipTCabinetFile(rundata, context);
    }

    protected Object getResultData(EipTCabinetFile record) throws ALPageNotFoundException, ALDBErrorException {
        try {
            CabinetFileResultData rd = new CabinetFileResultData();
            rd.initField();
            rd.setFileId(record.getFileId().intValue());
            rd.setFileTitle(record.getFileTitle());
            rd.setFileName(record.getFileName());
            rd.setFileSize(record.getFileSize());
            rd.setFolderName(ALCommonUtils.compressString((String)record.getEipTCabinetFolder().getFolderName(), (int)this.getStrLength()));
            rd.setCounter(record.getCounter());
            String updateUserName = "";
            ALEipUser updateUser = ALEipUtils.getALEipUser((int)record.getUpdateUserId());
            if (updateUser != null) {
                updateUserName = updateUser.getAliasName().getValue();
            }
            rd.setUpdateUser(updateUserName);
            rd.setUpdateUserId(record.getUpdateUserId().intValue());
            rd.setUpdateDate(record.getUpdateDate());
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"cabinet", (Throwable)ex);
            return null;
        }
    }

    protected Object getResultDataDetail(EipTCabinetFile obj) throws ALPageNotFoundException, ALDBErrorException {
        try {
            EipTCabinetFile record = obj;
            CabinetFileResultData rd = new CabinetFileResultData();
            rd.initField();
            rd.setFileId(record.getFileId().longValue());
            rd.setFileTitle(record.getFileTitle());
            rd.setFileName(record.getFileName());
            rd.setFileSize(record.getFileSize());
            rd.setCounter(record.getCounter());
            rd.setPosition(CabinetUtils.getFolderPosition(this.folder_hierarchy_list, record.getFolderId()));
            rd.setNote(record.getNote());
            rd.setisEditable(CabinetUtils.isEditableFolder(record.getFolderId(), this.rundata));
            String createUserName = "";
            ALEipUser createUser = ALEipUtils.getALEipUser((int)record.getCreateUserId());
            if (createUser != null) {
                createUserName = createUser.getAliasName().getValue();
            }
            rd.setCreateUser(createUserName);
            rd.setCreateUserId(record.getCreateUserId().intValue());
            rd.setCreateDate(new SimpleDateFormat(ALLocalizationUtils.getl10n((String)"CABINET_YEAR_MONTH_DAY")).format(record.getCreateDate()));
            String updateUserName = "";
            ALEipUser updateUser = ALEipUtils.getALEipUser((int)record.getUpdateUserId());
            if (updateUser != null) {
                updateUserName = updateUser.getAliasName().getValue();
            }
            rd.setUpdateUser(updateUserName);
            rd.setUpdateUserId(record.getUpdateUserId().intValue());
            rd.setUpdateDate(record.getUpdateDate());
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"cabinet", (Throwable)ex);
            return null;
        }
    }

    public List<FolderInfo> getFolderHierarchyList() {
        return this.folder_hierarchy_list;
    }

    public FolderInfo getSelectedFolderInfo() {
        return this.selected_folderinfo;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("file_title", "fileTitle");
        map.putValue("file_name", "fileName");
        map.putValue("update_date", "updateDate");
        map.putValue("file_size", "fileSize");
        map.putValue("counter", "counter");
        map.putValue("update_user", "turbineUser.lastNameKana");
        return map;
    }

    public boolean isMatch(int id1, long id2) {
        return id1 == (int)id2;
    }

    public int getFileSum() {
        return this.fileSum;
    }

    public String getAclPortletFeature() {
        return "cabinet_file";
    }

    public boolean isAccessible() {
        return this.isAccessible;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean isEditable) {
        this.isEditable = isEditable;
    }

    public ALStringField getTargetKeyword() {
        return this.target_keyword;
    }

    public int getTableColumNum() {
        return this.table_colum_num;
    }

    public void setTableColumNum(int table_colum_num) {
        this.table_colum_num = table_colum_num;
    }

    public boolean isFileUploadable() {
        return this.isFileUploadable;
    }

    public List<ALEipGroup> getMyGroupList() {
        return this.myGroupList;
    }

    public void updatePostNames() {
        this.post_alias_name = "";
        if (this.post_name.equals("") || this.post_name.equals("0")) {
            this.post_alias_name = ALLocalizationUtils.getl10n((String)"CABINET_ALL_GROUP");
            return;
        }
        List<ALEipGroup> mgl = this.myGroupList;
        for (ALEipGroup n : mgl) {
            if (!n.getName().toString().equals(this.post_name)) continue;
            this.post_alias_name = n.getAliasName().toString();
            return;
        }
        Map<Integer, ALEipPost> pm = this.getPostMap();
        for (ALEipPost n : pm.values()) {
            if (!n.getGroupName().toString().equals(this.post_name)) continue;
            this.post_alias_name = n.getPostName().toString();
            return;
        }
    }

    public Map<Integer, ALEipPost> getPostMap() {
        return ALEipManager.getInstance().getPostMap();
    }

    public String getSelectedPostAliasName() {
        return this.post_alias_name;
    }

    public String getSelectedPostName() {
        return this.post_name;
    }
}

