/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.access.ChildDiffLoader;
import org.apache.cayenne.access.ClientServerChannelQueryAction;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.IncrementalFaultList;
import org.apache.cayenne.access.ServerToClientDiffConverter;
import org.apache.cayenne.event.EventManager;
import org.apache.cayenne.graph.CompoundDiff;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.graph.GraphEvent;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.Query;

public class ClientServerChannel
implements DataChannel {
    protected DataContext serverContext;
    protected boolean lifecycleEventsEnabled;
    protected Map paginatedResults;

    public ClientServerChannel(DataDomain domain) {
        this(domain, false);
    }

    public ClientServerChannel(DataDomain domain, boolean lifecycleEventsEnabled) {
        this(domain.createDataContext(), lifecycleEventsEnabled);
    }

    ClientServerChannel(DataContext serverContext, boolean lifecycleEventsEnabled) {
        this.serverContext = serverContext;
        this.lifecycleEventsEnabled = lifecycleEventsEnabled;
    }

    public QueryResponse onQuery(ObjectContext context, Query query) {
        return new ClientServerChannelQueryAction(this, query).execute();
    }

    synchronized void addPaginatedResult(String cacheKey, IncrementalFaultList result) {
        if (this.paginatedResults == null) {
            this.paginatedResults = new HashMap();
        }
        this.paginatedResults.put(cacheKey, result);
    }

    synchronized IncrementalFaultList getPaginatedResult(String cacheKey) {
        return this.paginatedResults != null ? (IncrementalFaultList)this.paginatedResults.get(cacheKey) : null;
    }

    DataContext getServerContext() {
        return this.serverContext;
    }

    public EntityResolver getEntityResolver() {
        return this.serverContext.getEntityResolver();
    }

    public EventManager getEventManager() {
        return this.serverContext != null ? this.serverContext.getEventManager() : null;
    }

    public boolean isLifecycleEventsEnabled() {
        return this.lifecycleEventsEnabled;
    }

    public void setLifecycleEventsEnabled(boolean lifecycleEventsEnabled) {
        this.lifecycleEventsEnabled = lifecycleEventsEnabled;
    }

    public GraphDiff onSync(ObjectContext originatingContext, GraphDiff changes, int syncType) {
        switch (syncType) {
            case 3: {
                return this.onRollback(changes);
            }
            case 1: {
                return this.onFlush(changes);
            }
            case 2: {
                return this.onCommit(changes);
            }
        }
        throw new CayenneRuntimeException("Unrecognized SyncMessage type: " + syncType);
    }

    GraphDiff onRollback(GraphDiff childDiff) {
        if (this.serverContext.hasChanges()) {
            EventManager eventManager;
            this.serverContext.rollbackChanges();
            if (this.lifecycleEventsEnabled && (eventManager = this.getEventManager()) != null) {
                eventManager.postEvent(new GraphEvent((Object)this, null), DataChannel.GRAPH_ROLLEDBACK_SUBJECT);
            }
        }
        return null;
    }

    GraphDiff onFlush(GraphDiff childDiff) {
        EventManager eventManager;
        childDiff.apply(new ChildDiffLoader(this.serverContext));
        if (this.lifecycleEventsEnabled && (eventManager = this.getEventManager()) != null) {
            eventManager.postEvent(new GraphEvent((Object)this, childDiff), DataChannel.GRAPH_CHANGED_SUBJECT);
        }
        return null;
    }

    GraphDiff onCommit(GraphDiff childDiff) {
        EventManager eventManager;
        GraphDiff returnClientDiff;
        GraphDiff diff = this.serverContext.onContextFlush(null, childDiff, true);
        if (diff.isNoop()) {
            returnClientDiff = diff;
        } else {
            ServerToClientDiffConverter clientConverter = new ServerToClientDiffConverter(this.serverContext.getEntityResolver());
            diff.apply(clientConverter);
            returnClientDiff = clientConverter.getClientDiff();
        }
        if (this.lifecycleEventsEnabled && (eventManager = this.getEventManager()) != null) {
            CompoundDiff notification = new CompoundDiff();
            notification.add(childDiff);
            notification.add(returnClientDiff);
            eventManager.postEvent(new GraphEvent((Object)this, notification), DataChannel.GRAPH_FLUSHED_SUBJECT);
        }
        return returnClientDiff;
    }
}

