/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import org.apache.cayenne.DataChannelListener;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.ObjectStore;
import org.apache.cayenne.access.event.SnapshotEvent;
import org.apache.cayenne.graph.GraphChangeHandler;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.graph.GraphEvent;
import org.apache.cayenne.property.ClassDescriptor;
import org.apache.cayenne.property.CollectionProperty;
import org.apache.cayenne.property.Property;
import org.apache.cayenne.property.SingleObjectArcProperty;
import org.apache.cayenne.util.Util;

class DataContextMergeHandler
implements GraphChangeHandler,
DataChannelListener {
    private boolean active = true;
    private DataContext context;

    DataContextMergeHandler(DataContext context) {
        this.context = context;
    }

    void setActive(boolean active) {
        this.active = active;
    }

    private boolean shouldProcessEvent(GraphEvent e) {
        if (!this.active) {
            return false;
        }
        return e.getSource() == this.context.getChannel() && e.getPostedBy() != this.context && e.getPostedBy() != this.context.getChannel();
    }

    private Property propertyForId(Object nodeId, String propertyName) {
        ClassDescriptor descriptor = this.context.getEntityResolver().getClassDescriptor(((ObjectId)nodeId).getEntityName());
        return descriptor.getProperty(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void graphChanged(GraphEvent event) {
        if (this.shouldProcessEvent(event)) {
            GraphDiff diff = event.getDiff();
            if (diff instanceof ObjectStore.SnapshotEventDecorator) {
                SnapshotEvent decoratedEvent = ((ObjectStore.SnapshotEventDecorator)diff).getEvent();
                this.context.getObjectStore().processSnapshotEvent(decoratedEvent);
            } else {
                ObjectStore objectStore = this.context.getObjectStore();
                synchronized (objectStore) {
                    diff.apply(this);
                }
            }
            this.context.fireDataChannelChanged(event.getPostedBy(), event.getDiff());
        }
    }

    public void graphFlushed(GraphEvent event) {
        if (this.shouldProcessEvent(event)) {
            event.getDiff().apply(this);
            this.context.fireDataChannelChanged(event.getPostedBy(), event.getDiff());
        }
    }

    public void graphRolledback(GraphEvent event) {
    }

    public void nodeIdChanged(Object nodeId, Object newId) {
        this.context.getObjectStore().processIdChange(nodeId, newId);
    }

    public void nodeCreated(Object nodeId) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeRemoved(Object nodeId) {
        ObjectStore os;
        ObjectStore objectStore = os = this.context.getObjectStore();
        synchronized (objectStore) {
            os.processDeletedID(nodeId);
        }
    }

    public void nodePropertyChanged(Object nodeId, String property, Object oldValue, Object newValue) {
        Property p;
        Persistent object = (Persistent)this.context.getGraphManager().getNode(nodeId);
        if (object != null && object.getPersistenceState() != 5 && Util.nullSafeEquals((p = this.propertyForId(nodeId, property)).readPropertyDirectly(object), oldValue)) {
            p.writePropertyDirectly(object, oldValue, newValue);
        }
    }

    public void arcCreated(Object nodeId, Object targetNodeId, Object arcId) {
        Persistent source = (Persistent)this.context.getGraphManager().getNode(nodeId);
        if (source != null && source.getPersistenceState() != 5) {
            Persistent target = targetNodeId != null ? this.context.localObject((ObjectId)targetNodeId, null) : null;
            Property p = this.propertyForId(nodeId, arcId.toString());
            if (p instanceof CollectionProperty) {
                ((CollectionProperty)p).addTarget(source, target, false);
            } else {
                ((SingleObjectArcProperty)p).setTarget(source, target, false);
            }
        }
    }

    public void arcDeleted(Object nodeId, Object targetNodeId, Object arcId) {
        Persistent source = (Persistent)this.context.getGraphManager().getNode(nodeId);
        if (source != null && source.getPersistenceState() != 5) {
            Persistent target = this.context.localObject((ObjectId)targetNodeId, null);
            Property p = this.propertyForId(nodeId, arcId.toString());
            if (p instanceof CollectionProperty) {
                ((CollectionProperty)p).removeTarget(source, target, false);
            } else {
                ((SingleObjectArcProperty)p).setTarget(source, null, false);
            }
        }
    }
}

