/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.derby;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collections;
import org.apache.cayenne.CayenneException;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.QueryLogger;
import org.apache.cayenne.dba.JdbcPkGenerator;
import org.apache.cayenne.map.DbEntity;

public class DerbyPkGenerator
extends JdbcPkGenerator {
    static final String SELECT_QUERY = "SELECT NEXT_ID FROM AUTO_PK_SUPPORT WHERE TABLE_NAME = ? FOR UPDATE";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int pkFromDatabase(DataNode node, DbEntity entity) throws Exception {
        if (QueryLogger.isLoggable()) {
            QueryLogger.logQuery(SELECT_QUERY, Collections.singletonList(entity.getName()));
        }
        Connection c = node.getDataSource().getConnection();
        try {
            PreparedStatement select = c.prepareStatement(SELECT_QUERY, 1003, 1008);
            select.setString(1, entity.getName());
            ResultSet rs = select.executeQuery();
            if (!rs.next()) {
                throw new CayenneException("PK lookup failed for table: " + entity.getName());
            }
            int nextId = rs.getInt(1);
            rs.updateInt(1, nextId + this.pkCacheSize);
            rs.updateRow();
            if (rs.next()) {
                throw new CayenneException("More than one PK record for table: " + entity.getName());
            }
            rs.close();
            select.close();
            c.commit();
            int n = nextId;
            return n;
        }
        finally {
            c.close();
        }
    }
}

