/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.sqlserver;

import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.JdbcActionBuilder;
import org.apache.cayenne.dba.sqlserver.SQLServerBatchAction;
import org.apache.cayenne.dba.sqlserver.SQLServerProcedureAction;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.BatchQuery;
import org.apache.cayenne.query.ProcedureQuery;
import org.apache.cayenne.query.SQLAction;

public class SQLServerActionBuilder
extends JdbcActionBuilder {
    public SQLServerActionBuilder(DbAdapter adapter, EntityResolver resolver) {
        super(adapter, resolver);
    }

    public SQLAction batchAction(BatchQuery query) {
        boolean useOptimisticLock = query.isUsingOptimisticLocking();
        boolean runningAsBatch = !useOptimisticLock && this.adapter.supportsBatchUpdates();
        SQLServerBatchAction action = new SQLServerBatchAction(query, this.adapter, this.entityResolver);
        action.setBatch(runningAsBatch);
        return action;
    }

    public SQLAction procedureAction(ProcedureQuery query) {
        return new SQLServerProcedureAction(query, this.getAdapter(), this.getEntityResolver());
    }
}

