/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.util.Iterator;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.event.AttributeEvent;
import org.apache.cayenne.map.event.DbAttributeListener;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.util.XMLEncoder;

public class DbAttribute
extends Attribute {
    protected int type = Integer.MAX_VALUE;
    protected boolean mandatory;
    protected boolean primaryKey;
    protected boolean generated;
    protected int maxLength = -1;
    protected int precision = -1;

    public DbAttribute() {
    }

    public DbAttribute(String name) {
        super(name);
    }

    public DbAttribute(String name, int type, DbEntity entity) {
        this.setName(name);
        this.setType(type);
        this.setEntity(entity);
    }

    public void encodeAsXML(XMLEncoder encoder) {
        encoder.print("<db-attribute name=\"");
        encoder.print(Util.encodeXmlAttribute(this.getName()));
        encoder.print('\"');
        String type = TypesMapping.getSqlNameByType(this.getType());
        if (type != null) {
            encoder.print(" type=\"" + type + '\"');
        }
        if (this.isPrimaryKey()) {
            encoder.print(" isPrimaryKey=\"true\"");
            if (this.isGenerated()) {
                encoder.print(" isGenerated=\"true\"");
            }
        }
        if (this.isMandatory()) {
            encoder.print(" isMandatory=\"true\"");
        }
        if (this.getMaxLength() > 0) {
            encoder.print(" length=\"");
            encoder.print(this.getMaxLength());
            encoder.print('\"');
        }
        if (this.getPrecision() > 0) {
            encoder.print(" precision=\"");
            encoder.print(this.getPrecision());
            encoder.print('\"');
        }
        encoder.println("/>");
    }

    public String getAliasedName(String alias) {
        return alias != null ? alias + '.' + this.getName() : this.getName();
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public boolean isForeignKey() {
        String name = this.getName();
        if (name == null) {
            return false;
        }
        Iterator relationships = this.getEntity().getRelationships().iterator();
        while (relationships.hasNext()) {
            DbRelationship relationship = (DbRelationship)relationships.next();
            Iterator joins = relationship.getJoins().iterator();
            while (joins.hasNext()) {
                DbAttribute target;
                DbJoin join = (DbJoin)joins.next();
                if (!name.equals(join.getSourceName()) || (target = join.getTarget()) == null || !target.isPrimaryKey()) continue;
                return true;
            }
        }
        return false;
    }

    public void setPrimaryKey(boolean primaryKey) {
        if (this.primaryKey != primaryKey) {
            this.primaryKey = primaryKey;
            Entity e = this.getEntity();
            if (e instanceof DbAttributeListener) {
                ((DbAttributeListener)((Object)e)).dbAttributeChanged(new AttributeEvent((Object)this, this, e));
            }
        }
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public boolean isGenerated() {
        return this.generated;
    }

    public void setGenerated(boolean generated) {
        if (this.generated != generated) {
            this.generated = generated;
            Entity e = this.getEntity();
            if (e instanceof DbAttributeListener) {
                ((DbAttributeListener)((Object)e)).dbAttributeChanged(new AttributeEvent((Object)this, this, e));
            }
        }
    }
}

