/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.map.EntityInheritanceTree;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.property.AbstractSingleObjectArcProperty;
import org.apache.cayenne.property.BaseClassDescriptor;
import org.apache.cayenne.property.BeanAccessor;
import org.apache.cayenne.property.ClassDescriptor;
import org.apache.cayenne.property.DataObjectAccessor;
import org.apache.cayenne.property.FieldAccessor;
import org.apache.cayenne.property.ListProperty;
import org.apache.cayenne.property.PersistentObjectProperty;
import org.apache.cayenne.property.Property;
import org.apache.cayenne.property.PropertyAccessException;
import org.apache.cayenne.property.PropertyAccessor;
import org.apache.cayenne.property.SimpleProperty;
import org.apache.cayenne.property.ToManyListProperty;
import org.apache.cayenne.property.ValueHolderProperty;
import org.apache.commons.lang.builder.ToStringBuilder;

public class EntityDescriptor
extends BaseClassDescriptor {
    protected ObjEntity entity;
    protected boolean dataObject;
    boolean persistent;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$org$apache$cayenne$ValueHolder;

    public EntityDescriptor(ObjEntity entity, ClassDescriptor superclassDescriptor) {
        super(superclassDescriptor);
        this.entity = entity;
    }

    public void shallowMerge(Object from, Object to) throws PropertyAccessException {
        super.shallowMerge(from, to);
        if (this.dataObject && from instanceof DataObject && to instanceof DataObject) {
            ((DataObject)to).setSnapshotVersion(((DataObject)from).getSnapshotVersion());
        }
    }

    public ObjEntity getEntity() {
        return this.entity;
    }

    public void setDeclaredProperty(Property property) {
        this.declaredProperties.put(property.getName(), property);
    }

    public void removeDeclaredProperty(String propertyName) {
        this.declaredProperties.remove(propertyName);
    }

    public void compile(EntityResolver resolver) {
        if (this.entity == null) {
            throw new IllegalStateException("Entity is not initialized, can't index descriptor.");
        }
        this.objectClass = this.entity.getJavaClass();
        this.persistent = Persistent.class.isAssignableFrom(this.objectClass);
        this.dataObject = this.persistent && DataObject.class.isAssignableFrom(this.objectClass);
        this.compileSpecialProperties();
        HashMap allDescriptors = new HashMap();
        this.compileRelationships(resolver, allDescriptors);
        if (!allDescriptors.isEmpty()) {
            this.valueHolderProperties = new HashMap(allDescriptors);
        }
        this.compileAttributes(allDescriptors);
        this.declaredProperties = allDescriptors;
        EntityInheritanceTree inheritanceTree = resolver.lookupInheritanceTree(this.entity);
        if (inheritanceTree == null) {
            this.subclassDescriptors = null;
        } else {
            HashMap subclassMapping = new HashMap();
            this.compileSubclassMapping(resolver, subclassMapping, inheritanceTree);
            this.subclassDescriptors = subclassMapping;
        }
    }

    protected void compileSubclassMapping(EntityResolver resolver, Map subclassDescriptors, EntityInheritanceTree treeNode) {
        ObjEntity entity = treeNode.getEntity();
        ClassDescriptor descriptor = resolver.getClassDescriptor(entity.getName());
        subclassDescriptors.put(entity.getClassName(), descriptor);
        Iterator it = treeNode.getChildren().iterator();
        while (it.hasNext()) {
            EntityInheritanceTree child = (EntityInheritanceTree)it.next();
            this.compileSubclassMapping(resolver, subclassDescriptors, child);
        }
    }

    protected void compileSpecialProperties() {
        this.persistenceStateProperty = new BeanAccessor(this.objectClass, "persistenceState", Integer.TYPE);
    }

    protected void compileAttributes(Map allDescriptors) {
        Iterator it = this.entity.getDeclaredAttributes().iterator();
        while (it.hasNext()) {
            ObjAttribute attribute = (ObjAttribute)it.next();
            Class propertyType = attribute.getJavaClass();
            PropertyAccessor accessor = this.makeAccessor(attribute.getName(), propertyType);
            allDescriptors.put(attribute.getName(), this.persistent ? new SimplePersistentProperty(this, accessor) : new SimpleProperty(this, accessor));
        }
    }

    protected void compileRelationships(EntityResolver resolver, Map allDescriptors) {
        Iterator it = this.entity.getDeclaredRelationships().iterator();
        while (it.hasNext()) {
            AbstractSingleObjectArcProperty property;
            PropertyAccessor accessor;
            ObjRelationship relationship = (ObjRelationship)it.next();
            ClassDescriptor targetDescriptor = resolver.getClassDescriptor(relationship.getTargetEntityName());
            String reverseName = relationship.getReverseRelationshipName();
            if (relationship.isToMany()) {
                accessor = this.makeAccessor(relationship.getName(), class$java$util$List == null ? EntityDescriptor.class$("java.util.List") : class$java$util$List);
                property = this.dataObject ? new ToManyListProperty(this, targetDescriptor, accessor, reverseName) : new ListProperty(this, targetDescriptor, accessor, reverseName);
            } else if (this.dataObject) {
                ObjEntity targetEntity = (ObjEntity)relationship.getTargetEntity();
                PropertyAccessor accessor2 = this.makeAccessor(relationship.getName(), targetEntity.getJavaClass());
                property = new PersistentObjectProperty(this, targetDescriptor, accessor2, reverseName);
            } else {
                accessor = this.makeAccessor(relationship.getName(), class$org$apache$cayenne$ValueHolder == null ? EntityDescriptor.class$("org.apache.cayenne.ValueHolder") : class$org$apache$cayenne$ValueHolder);
                property = new ValueHolderProperty(this, targetDescriptor, accessor, reverseName);
            }
            allDescriptors.put(relationship.getName(), property);
        }
    }

    PropertyAccessor makeAccessor(String propertyName, Class propertyType) throws PropertyAccessException {
        if (this.dataObject) {
            return new DataObjectAccessor(propertyName);
        }
        try {
            return new FieldAccessor(this.objectClass, propertyName, propertyType);
        }
        catch (Throwable th) {
            throw new PropertyAccessException("Can't create accessor for property '" + propertyName + "' of class '" + this.objectClass.getName() + "'", null, null);
        }
    }

    public String toString() {
        String entityName = this.entity != null ? this.entity.getName() : null;
        String className = this.objectClass != null ? this.objectClass.getName() : null;
        return new ToStringBuilder(this).append("entity", entityName).append("objectClass", className).toString();
    }

    final class SimplePersistentProperty
    extends SimpleProperty {
        SimplePersistentProperty(ClassDescriptor owner, PropertyAccessor accessor) {
            super(owner, accessor);
        }

        public Object readProperty(Object object) throws PropertyAccessException {
            this.resolveFault(object);
            return super.readProperty(object);
        }

        public void writeProperty(Object object, Object oldValue, Object newValue) throws PropertyAccessException {
            this.resolveFault(object);
            super.writeProperty(object, oldValue, newValue);
        }

        void resolveFault(Object object) throws PropertyAccessException {
            try {
                Persistent persistent = (Persistent)object;
                ObjectContext context = persistent.getObjectContext();
                if (context != null) {
                    context.prepareForAccess(persistent, this.getName());
                }
            }
            catch (ClassCastException e) {
                throw new PropertyAccessException("Object is not a Persistent: '" + object.getClass().getName() + "'", this, object, e);
            }
        }
    }
}

