/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project;

import java.io.PrintWriter;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.conf.ConfigSaver;
import org.apache.cayenne.conf.DriverDataSourceFactory;
import org.apache.cayenne.project.Project;
import org.apache.cayenne.project.ProjectDataSource;
import org.apache.cayenne.project.ProjectFile;

public class DataNodeFile
extends ProjectFile {
    public static final String LOCATION_SUFFIX = ".driver.xml";
    protected DataNode nodeObj;

    public DataNodeFile() {
    }

    public DataNodeFile(Project project, DataNode node) {
        super(project, node.getDataSourceLocation());
        this.nodeObj = node;
    }

    public Object getObject() {
        return this.nodeObj;
    }

    public String getObjectName() {
        return this.nodeObj.getName();
    }

    public void save(PrintWriter out) throws Exception {
        ProjectDataSource src = (ProjectDataSource)this.nodeObj.getDataSource();
        new ConfigSaver().storeDataNode(out, src.getDataSourceInfo());
    }

    public boolean canHandle(Object obj) {
        if (obj instanceof DataNode) {
            DataNode node = (DataNode)obj;
            if (DriverDataSourceFactory.class.getName().equals(node.getDataSourceFactory())) {
                return true;
            }
        }
        return false;
    }

    public void willSave() {
        super.willSave();
        if (this.nodeObj != null && this.canHandle(this.nodeObj)) {
            this.nodeObj.setDataSourceLocation(this.getLocation());
        }
    }

    public String getLocationSuffix() {
        return LOCATION_SUFFIX;
    }
}

