/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.property;

import java.util.Iterator;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.property.ClassDescriptor;
import org.apache.cayenne.property.Property;
import org.apache.cayenne.property.PropertyAccessException;
import org.apache.cayenne.property.PropertyAccessor;
import org.apache.cayenne.property.PropertyVisitor;
import org.apache.commons.collections.IteratorUtils;

public abstract class BaseClassDescriptor
implements ClassDescriptor {
    static final Integer TRANSIENT_STATE = new Integer(1);
    static final Integer HOLLOW_STATE = new Integer(5);
    static final Integer COMMITTED_STATE = new Integer(3);
    protected ClassDescriptor superclassDescriptor;
    protected Class objectClass;
    protected Map declaredProperties;
    protected Map valueHolderProperties;
    protected Map subclassDescriptors;
    protected PropertyAccessor persistenceStateProperty;

    public BaseClassDescriptor(ClassDescriptor superclassDescriptor) {
        this.superclassDescriptor = superclassDescriptor;
    }

    public boolean isFault(Object object) {
        if (this.superclassDescriptor != null) {
            return this.superclassDescriptor.isFault(object);
        }
        if (object == null) {
            return false;
        }
        return HOLLOW_STATE.equals(this.persistenceStateProperty.readPropertyDirectly(object));
    }

    public boolean isValid() {
        return this.objectClass != null && this.declaredProperties != null;
    }

    public Class getObjectClass() {
        return this.objectClass;
    }

    public ClassDescriptor getSubclassDescriptor(Class objectClass) {
        if (objectClass == null) {
            throw new IllegalArgumentException("Null objectClass");
        }
        if (this.subclassDescriptors == null) {
            return this;
        }
        ClassDescriptor subclassDescriptor = (ClassDescriptor)this.subclassDescriptors.get(objectClass.getName());
        if (subclassDescriptor == null) {
            Class currentClass = objectClass;
            while (subclassDescriptor == null && (currentClass = currentClass.getSuperclass()) != null) {
                subclassDescriptor = (ClassDescriptor)this.subclassDescriptors.get(currentClass.getName());
            }
        }
        return subclassDescriptor != null ? subclassDescriptor : this;
    }

    public Iterator getProperties() {
        Iterator declaredIt = IteratorUtils.unmodifiableIterator(this.declaredProperties.values().iterator());
        if (this.getSuperclassDescriptor() == null) {
            return declaredIt;
        }
        return IteratorUtils.chainedIterator(this.superclassDescriptor.getProperties(), declaredIt);
    }

    public Property getProperty(String propertyName) {
        Property property = this.getDeclaredProperty(propertyName);
        if (property == null && this.superclassDescriptor != null) {
            property = this.superclassDescriptor.getProperty(propertyName);
        }
        return property;
    }

    public Property getDeclaredProperty(String propertyName) {
        return (Property)this.declaredProperties.get(propertyName);
    }

    public ClassDescriptor getSuperclassDescriptor() {
        return this.superclassDescriptor;
    }

    public Object createObject() {
        if (this.objectClass == null) {
            throw new NullPointerException("Null objectClass. Descriptor wasn't initialized properly.");
        }
        try {
            return this.objectClass.newInstance();
        }
        catch (Throwable e) {
            throw new CayenneRuntimeException("Error creating object of class '" + this.objectClass.getName() + "'", e);
        }
    }

    public void injectValueHolders(Object object) throws PropertyAccessException {
        if (this.getSuperclassDescriptor() != null) {
            this.getSuperclassDescriptor().injectValueHolders(object);
        }
        if (this.valueHolderProperties != null) {
            Iterator it = this.valueHolderProperties.values().iterator();
            while (it.hasNext()) {
                Property property = (Property)it.next();
                property.injectValueHolder(object);
            }
        }
    }

    public void shallowMerge(Object from, Object to) throws PropertyAccessException {
        if (this.getSuperclassDescriptor() != null) {
            this.getSuperclassDescriptor().shallowMerge(from, to);
        }
        Iterator it = this.declaredProperties.values().iterator();
        while (it.hasNext()) {
            Property property = (Property)it.next();
            property.shallowMerge(from, to);
        }
    }

    public boolean visitProperties(PropertyVisitor visitor) {
        if (this.superclassDescriptor != null && !this.superclassDescriptor.visitProperties(visitor)) {
            return false;
        }
        Iterator it = this.declaredProperties.values().iterator();
        while (it.hasNext()) {
            Property next = (Property)it.next();
            if (next.visit(visitor)) continue;
            return false;
        }
        return true;
    }
}

