/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.property;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import org.apache.cayenne.property.PropertyAccessException;
import org.apache.cayenne.property.PropertyAccessor;
import org.apache.cayenne.property.PropertyUtils;

public class BeanAccessor
implements PropertyAccessor {
    protected String propertyName;
    protected Method readMethod;
    protected Method writeMethod;
    protected Object nullValue;

    public BeanAccessor(Class objectClass, String propertyName, Class propertyType) {
        if (objectClass == null) {
            throw new IllegalArgumentException("Null objectClass");
        }
        if (propertyName == null) {
            throw new IllegalArgumentException("Null propertyName");
        }
        this.propertyName = propertyName;
        this.nullValue = PropertyUtils.defaultNullValueForType(propertyType);
        try {
            PropertyDescriptor descriptor = new PropertyDescriptor(propertyName, objectClass);
            this.readMethod = descriptor.getReadMethod();
            this.writeMethod = descriptor.getWriteMethod();
        }
        catch (IntrospectionException e) {
            throw new PropertyAccessException("Invalid bean property: " + propertyName, null, e);
        }
    }

    public String getName() {
        return this.propertyName;
    }

    public Object readPropertyDirectly(Object object) throws PropertyAccessException {
        if (this.readMethod == null) {
            throw new PropertyAccessException("Property '" + this.propertyName + "' is not readable", this, object);
        }
        try {
            return this.readMethod.invoke(object, null);
        }
        catch (Throwable th) {
            throw new PropertyAccessException("Error reading property: " + this.propertyName, this, object, th);
        }
    }

    public void writePropertyDirectly(Object object, Object oldValue, Object newValue) throws PropertyAccessException {
        if (this.writeMethod == null) {
            throw new PropertyAccessException("Property '" + this.propertyName + "' is not writable", this, object);
        }
        if (newValue == null) {
            newValue = this.nullValue;
        }
        try {
            this.writeMethod.invoke(object, newValue);
        }
        catch (Throwable th) {
            throw new PropertyAccessException("Error reading property: " + this.propertyName, this, object, th);
        }
    }
}

