/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.remote;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.event.EventBridge;
import org.apache.cayenne.event.EventBridgeFactory;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public class RemoteSession
implements Serializable {
    static final Collection SUBJECTS = Arrays.asList(DataChannel.GRAPH_CHANGED_SUBJECT, DataChannel.GRAPH_FLUSHED_SUBJECT, DataChannel.GRAPH_ROLLEDBACK_SUBJECT);
    protected String name;
    protected String sessionId;
    protected String eventBridgeFactory;
    protected Map eventBridgeParameters;

    private RemoteSession() {
    }

    public RemoteSession(String sessionId) {
        this(sessionId, null, null);
    }

    public RemoteSession(String sessionId, String eventBridgeFactory, Map eventBridgeParameters) {
        if (sessionId == null) {
            throw new IllegalArgumentException("Null sessionId");
        }
        this.sessionId = sessionId;
        this.eventBridgeFactory = eventBridgeFactory;
        this.eventBridgeParameters = eventBridgeParameters;
    }

    public int hashCode() {
        return new HashCodeBuilder(71, 5).append(this.sessionId).toHashCode();
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isServerEventsEnabled() {
        return this.eventBridgeFactory != null;
    }

    public EventBridge createServerEventBridge() throws CayenneRuntimeException {
        if (!this.isServerEventsEnabled()) {
            return null;
        }
        try {
            EventBridgeFactory factory = (EventBridgeFactory)Class.forName(this.eventBridgeFactory).newInstance();
            Map parameters = this.eventBridgeParameters != null ? this.eventBridgeParameters : Collections.EMPTY_MAP;
            return factory.createEventBridge(SUBJECTS, this.name, parameters);
        }
        catch (Exception ex) {
            throw new CayenneRuntimeException("Error creating EventBridge.", ex);
        }
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this).append("sessionId", this.sessionId);
        if (this.eventBridgeFactory != null) {
            builder.append("eventBridgeFactory", this.eventBridgeFactory);
        }
        if (this.name != null) {
            builder.append("name", this.name);
        }
        return builder.toString();
    }
}

