/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

class RegexUtil {
    static final Pattern BACKSLASH = Pattern.compile("\\\\");
    static final Pattern DOT = Pattern.compile("\\.");

    static String substBackslashes(String string) {
        if (string == null) {
            return null;
        }
        Matcher matcher = BACKSLASH.matcher(string);
        return matcher.find() ? matcher.replaceAll("\\/") : string;
    }

    static String getPackagePath(String className) {
        if (className == null) {
            return "";
        }
        Matcher matcher = DOT.matcher(className);
        if (matcher.find()) {
            String path = matcher.replaceAll("\\/");
            return path.substring(0, path.lastIndexOf("/"));
        }
        return "";
    }

    static String sqlPatternToRegex(String pattern) {
        if (pattern == null) {
            throw new NullPointerException("Null pattern.");
        }
        if (pattern.length() == 0) {
            throw new IllegalArgumentException("Empty pattern.");
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("^");
        for (int j = 0; j < pattern.length(); ++j) {
            char nextChar = pattern.charAt(j);
            if (nextChar == '%') {
                nextChar = '*';
            }
            if (nextChar == '*' || nextChar == '?') {
                buffer.append('.');
            } else if (nextChar == '.' || nextChar == '/' || nextChar == '$' || nextChar == '^') {
                buffer.append('\\');
            }
            buffer.append(nextChar);
        }
        buffer.append("$");
        return buffer.toString();
    }

    private RegexUtil() {
    }
}

