/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.ashwood.graph;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.UnboundedFifoBuffer;
import org.objectstyle.ashwood.graph.Algorithm;
import org.objectstyle.ashwood.graph.ArcIterator;
import org.objectstyle.ashwood.graph.DigraphIteration;
import org.objectstyle.ashwood.util.Attribute;
import org.objectstyle.ashwood.util.ConstAttribute;

public class BreadthFirstSearch
extends Algorithm {
    private DigraphIteration factory;
    private Collection firstVertices;
    private Buffer queue = new UnboundedFifoBuffer();
    private Set seen = new HashSet();
    private Attribute level;
    private boolean validTree;

    public BreadthFirstSearch(DigraphIteration digraphIteration, Object object) {
        this(digraphIteration, object, (Attribute)new ConstAttribute(new Integer(-1)));
    }

    public BreadthFirstSearch(DigraphIteration digraphIteration, Object object, Attribute attribute) {
        this.factory = digraphIteration;
        this.reset(object, attribute);
    }

    public BreadthFirstSearch(DigraphIteration digraphIteration, Collection collection) {
        this(digraphIteration, collection, (Attribute)new ConstAttribute(new Integer(-1)));
    }

    public BreadthFirstSearch(DigraphIteration digraphIteration, Collection collection, Attribute attribute) {
        this.factory = digraphIteration;
        this.reset(collection, attribute);
    }

    public void reset(Object object) {
        this.reset(object, (Attribute)new ConstAttribute(new Integer(-1)));
    }

    public void reset(Object object, Attribute attribute) {
        this.reset(Collections.singletonList(object), attribute);
    }

    public void reset(Collection collection, Attribute attribute) {
        if (!this.queue.isEmpty()) {
            this.queue.clear();
        }
        if (!this.seen.isEmpty()) {
            this.seen.clear();
        }
        this.firstVertices = collection;
        this.level = attribute;
        this.queue.addAll(this.firstVertices);
        this.seen.addAll(this.firstVertices);
        Iterator iterator = this.firstVertices.iterator();
        while (iterator.hasNext()) {
            attribute.set(iterator.next(), new Integer(0));
        }
        this.validTree = true;
    }

    public Attribute getLevel() {
        return this.level;
    }

    public boolean hasNext() {
        return !this.queue.isEmpty();
    }

    public Object next() {
        ArcIterator arcIterator = this.factory.outgoingIterator(this.queue.remove());
        Object object = arcIterator.getOrigin();
        Integer n = new Integer(this.level.get(object).hashCode() + 1);
        while (arcIterator.hasNext()) {
            arcIterator.next();
            Object object2 = arcIterator.getDestination();
            if (this.seen.add(object2)) {
                this.queue.add(object2);
                this.level.set(object2, n);
                continue;
            }
            this.validTree = false;
        }
        return object;
    }

    public Set getSeenVertices() {
        return Collections.unmodifiableSet(this.seen);
    }

    public boolean isValidTree() {
        return this.validTree;
    }
}

