/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.ashwood.graph;

import java.util.Map;
import org.objectstyle.ashwood.graph.ArcIterator;
import org.objectstyle.ashwood.graph.DepthFirstSearch;
import org.objectstyle.ashwood.graph.DigraphIteration;

public class DepthFirstStampSearch
extends DepthFirstSearch {
    public static final int UNDEFINED_STAMP = -1;
    public static final int GROW_DEPTH_STAMP = 0;
    public static final int GROW_BREADTH_STAMP = 1;
    public static final int SHRINK_STAMP = 2;
    public static final int LEAF_STAMP = 3;
    private int stamp = -1;

    public DepthFirstStampSearch(DigraphIteration digraphIteration, Object object) {
        super(digraphIteration, object);
    }

    public int getStamp() {
        return this.stamp;
    }

    public Object next() {
        ArcIterator arcIterator = (ArcIterator)this.stack.peek();
        Object object = arcIterator.getOrigin();
        Object object2 = arcIterator.getDestination();
        if (object2 == null) {
            if (arcIterator.hasNext()) {
                arcIterator.next();
                object2 = arcIterator.getDestination();
            } else {
                this.stack.pop();
                this.stamp = 3;
                return object;
            }
        }
        if (this.seen.add(object2)) {
            this.stack.push(this.factory.outgoingIterator(object2));
            this.stamp = 0;
            if (arcIterator.hasNext()) {
                arcIterator.next();
            }
        } else if (arcIterator.hasNext()) {
            arcIterator.next();
            this.stamp = 1;
        } else {
            this.stack.pop();
            this.stamp = 2;
        }
        return object;
    }

    public Map traverse(Map map) {
        int n = 0;
        int n2 = 0;
        while (this.hasNext()) {
            Object object = this.next();
            int n3 = this.getStamp();
            if (n3 == 2) {
                ++n2;
                OrderPair orderPair = (OrderPair)map.get(object);
                if (orderPair == null) {
                    map.put(object, new OrderPair(++n, n2));
                    continue;
                }
                orderPair.postOrder = n2;
                continue;
            }
            if (n3 == 3) {
                map.put(object, new OrderPair(++n, ++n2));
                continue;
            }
            if (map.containsKey(object)) continue;
            map.put(object, new OrderPair(++n, -1));
        }
        return map;
    }

    public static class OrderPair {
        private int preOrder;
        private int postOrder;

        public OrderPair(int n, int n2) {
            this.preOrder = n;
            this.postOrder = n2;
        }

        public int getPreOrder() {
            return this.preOrder;
        }

        public int getPostOrder() {
            return this.postOrder;
        }

        public String toString() {
            return "(" + this.preOrder + ", " + this.postOrder + ")";
        }
    }
}

