/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.ashwood.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.collections.ArrayStack;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.objectstyle.ashwood.graph.Algorithm;
import org.objectstyle.ashwood.graph.ArcIterator;
import org.objectstyle.ashwood.graph.CollectionFactory;
import org.objectstyle.ashwood.graph.DepthFirstSearch;
import org.objectstyle.ashwood.graph.DepthFirstStampSearch;
import org.objectstyle.ashwood.graph.Digraph;
import org.objectstyle.ashwood.graph.DigraphIteration;
import org.objectstyle.ashwood.graph.FilterIteration;
import org.objectstyle.ashwood.graph.GraphUtils;
import org.objectstyle.ashwood.graph.ReversedIteration;

public class StrongConnection
extends Algorithm {
    private DigraphIteration digraph;
    private DigraphIteration reverseDigraph;
    private DigraphIteration filteredDigraph;
    private DepthFirstStampSearch directDfs;
    private DepthFirstSearch reverseDfs;
    private Set seen = new HashSet();
    private Iterator vertexIterator;
    private ArrayStack dfsStack = new ArrayStack();
    private DFSSeenVerticesPredicate reverseDFSFilter = new DFSSeenVerticesPredicate();
    private CollectionFactory componentFactory;

    public StrongConnection(DigraphIteration digraphIteration, CollectionFactory collectionFactory) {
        this.digraph = digraphIteration;
        this.componentFactory = collectionFactory;
        this.filteredDigraph = new FilterIteration(digraphIteration, new NotSeenPredicate(), GraphUtils.TRUE_PREDICATE);
        this.reverseDigraph = new FilterIteration(new ReversedIteration(digraphIteration), this.reverseDFSFilter, GraphUtils.TRUE_PREDICATE);
        this.vertexIterator = this.filteredDigraph.vertexIterator();
        this.runDirectDFS();
    }

    public boolean hasNext() {
        return !this.dfsStack.isEmpty();
    }

    public Object next() {
        Collection collection = this.buildStronglyConnectedComponent();
        if (this.dfsStack.isEmpty()) {
            this.runDirectDFS();
        }
        return collection;
    }

    public Digraph contract(Digraph digraph) {
        return this.contract(digraph, null);
    }

    public Digraph contract(Digraph digraph, CollectionFactory collectionFactory) {
        Object object;
        Object object2;
        ArrayList arrayList = new ArrayList();
        CollectionUtils.addAll(arrayList, this);
        HashMap hashMap = new HashMap();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object2 = (Collection)iterator.next();
            object = object2.iterator();
            while (object.hasNext()) {
                hashMap.put(object.next(), object2);
            }
        }
        object2 = arrayList.iterator();
        while (object2.hasNext()) {
            object = (Collection)object2.next();
            digraph.addVertex(object);
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                ArcIterator arcIterator = this.digraph.outgoingIterator(e);
                while (arcIterator.hasNext()) {
                    Object e2 = arcIterator.next();
                    Object object3 = arcIterator.getDestination();
                    if (object.contains(object3)) continue;
                    Collection collection = (Collection)hashMap.get(object3);
                    if (collectionFactory == null) {
                        digraph.putArc(object, collection, e2);
                        continue;
                    }
                    Collection collection2 = (Collection)digraph.getArc(object, collection);
                    if (collection2 == null) {
                        collection2 = collectionFactory.createSingleton(e2);
                        digraph.putArc(object, collection, collection2);
                        continue;
                    }
                    if (collection2.size() == 1) {
                        Collection collection3 = collection2;
                        collection2 = collectionFactory.create();
                        collection2.addAll(collection3);
                        digraph.putArc(object, collection, collection2);
                    }
                    collection2.add(e2);
                }
            }
        }
        return digraph;
    }

    private Object nextDFSRoot() {
        return this.vertexIterator.hasNext() ? this.vertexIterator.next() : null;
    }

    private boolean runDirectDFS() {
        this.dfsStack.clear();
        this.reverseDFSFilter.seenVertices.clear();
        Object object = this.nextDFSRoot();
        if (object == null) {
            return false;
        }
        if (this.directDfs == null) {
            this.directDfs = new DepthFirstStampSearch(this.filteredDigraph, object);
        } else {
            this.directDfs.reset(object);
        }
        while (this.directDfs.hasNext()) {
            Object object2 = this.directDfs.next();
            int n = this.directDfs.getStamp();
            if (n != 2 && n != 3) continue;
            this.dfsStack.push(object2);
            this.reverseDFSFilter.seenVertices.add(object2);
        }
        this.seen.addAll(this.dfsStack);
        return true;
    }

    private Collection buildStronglyConnectedComponent() {
        Object object = this.dfsStack.pop();
        Collection collection = this.componentFactory.createSingleton(object);
        boolean bl = true;
        if (this.reverseDfs == null) {
            this.reverseDfs = new DepthFirstSearch(this.reverseDigraph, object);
        } else {
            this.reverseDfs.reset(object);
        }
        while (this.reverseDfs.hasNext()) {
            Object object2 = this.reverseDfs.next();
            if (object2 == object) continue;
            if (bl) {
                Collection collection2 = collection;
                collection = this.componentFactory.create();
                collection.addAll(collection2);
                bl = false;
            }
            collection.add(object2);
            this.dfsStack.remove(object2);
        }
        this.reverseDFSFilter.seenVertices.removeAll(collection);
        return collection;
    }

    private class NotSeenPredicate
    implements Predicate {
        private NotSeenPredicate() {
        }

        public boolean evaluate(Object object) {
            return !StrongConnection.this.seen.contains(object);
        }
    }

    private class DFSSeenVerticesPredicate
    implements Predicate {
        private Set seenVertices = new HashSet();

        private DFSSeenVerticesPredicate() {
        }

        public boolean evaluate(Object object) {
            return this.seenVertices.contains(object);
        }
    }
}

