/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.ashwood.graph.layout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.Predicate;
import org.objectstyle.ashwood.graph.layout.BorderVertex;
import org.objectstyle.ashwood.graph.layout.LayerVertex;
import org.objectstyle.ashwood.graph.layout.NestingTreeNode;
import org.objectstyle.ashwood.graph.layout.VertexSegment;

public class NestedSubgraph
implements NestingTreeNode {
    private List children;
    private VertexSegment leftBorder;
    private VertexSegment rightBorder;
    private int minRank = Integer.MAX_VALUE;
    private int maxRank = Integer.MIN_VALUE;
    private NestedSubgraph parentSubgraph;
    private int vertexCount;
    private double position;
    private Map layerPositions = new HashMap(3);
    private Map layerVertexCounts = new HashMap(3);
    private String label;

    public NestedSubgraph() {
        this.children = new ArrayList();
    }

    public NestedSubgraph(int n) {
        this.children = new ArrayList(n);
    }

    public boolean contains(LayerVertex layerVertex) {
        return this.children.contains(layerVertex);
    }

    public boolean contains(NestedSubgraph nestedSubgraph) {
        return this.children.contains(nestedSubgraph);
    }

    public boolean add(LayerVertex layerVertex) {
        int n = layerVertex.getRank();
        this.minRank = Math.min(this.minRank, n);
        this.maxRank = Math.max(this.maxRank, n);
        layerVertex.setParentSubgraph(this);
        return this.children.add(layerVertex);
    }

    public boolean add(NestedSubgraph nestedSubgraph) {
        this.minRank = Math.min(this.minRank, nestedSubgraph.getMinRank());
        this.maxRank = Math.max(this.maxRank, nestedSubgraph.getMaxRank());
        nestedSubgraph.setParentSubgraph(this);
        return this.children.add(nestedSubgraph);
    }

    public List getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public void createBorders() {
        this.leftBorder = new VertexSegment();
        this.rightBorder = new VertexSegment();
        LayerVertex layerVertex = null;
        LayerVertex layerVertex2 = null;
        int n = this.minRank;
        while (n <= this.maxRank) {
            BorderVertex borderVertex = new BorderVertex();
            this.leftBorder.add(borderVertex);
            this.children.add(borderVertex);
            borderVertex.setParentSubgraph(this);
            borderVertex.setRank(n);
            if (layerVertex != null) {
                layerVertex.getSuccessors().add(borderVertex);
                borderVertex.getPredecessors().add(layerVertex);
            }
            layerVertex = borderVertex;
            BorderVertex borderVertex2 = new BorderVertex();
            this.rightBorder.add(borderVertex2);
            this.children.add(borderVertex2);
            borderVertex2.setParentSubgraph(this);
            borderVertex2.setRank(n);
            if (layerVertex2 != null) {
                layerVertex2.getSuccessors().add(borderVertex2);
                borderVertex2.getPredecessors().add(layerVertex2);
            }
            layerVertex2 = borderVertex2;
            ++n;
        }
    }

    public double layerPosition(ArrayList arrayList) {
        double d = 0.0;
        int n = 0;
        int n2 = 0;
        while (n2 < arrayList.size()) {
            if (this.children.contains(arrayList.get(n2))) {
                d += (double)n2;
                ++n;
            }
            ++n2;
        }
        d = n > 0 ? d / (double)n : -1.0;
        return d;
    }

    public double position(ArrayList[] arrayListArray) {
        double d = 0.0;
        int n = 0;
        int n2 = 0;
        while (n2 < arrayListArray.length) {
            int n3 = 0;
            while (n3 < arrayListArray[n2].size()) {
                if (this.children.contains(arrayListArray[n2].get(n3))) {
                    d += (double)n3;
                    ++n;
                }
                ++n3;
            }
            ++n2;
        }
        d = n > 0 ? d / (double)n : -1.0;
        return d;
    }

    public boolean isLeftOf(NestedSubgraph nestedSubgraph, ArrayList[] arrayListArray) {
        int n = 0;
        while (n < arrayListArray.length) {
            int n2 = 0;
            while (n2 < arrayListArray[n].size() - 1) {
                if (this.children.contains(arrayListArray[n].get(n2)) && nestedSubgraph.children.contains(arrayListArray[n].get(n2 + 1))) {
                    return true;
                }
                ++n2;
            }
            ++n;
        }
        return false;
    }

    public int getMaxRank() {
        return this.maxRank;
    }

    public int getMinRank() {
        return this.minRank;
    }

    public VertexSegment getRightBorder() {
        return this.rightBorder;
    }

    public VertexSegment getLeftBorder() {
        return this.leftBorder;
    }

    public LayerVertex getLeftBorderVertex(int n) {
        return this.leftBorder.getVertex(n - this.minRank);
    }

    public LayerVertex getRightBorderVertex(int n) {
        return this.rightBorder.getVertex(n - this.minRank);
    }

    public void setParentSubgraph(NestedSubgraph nestedSubgraph) {
        this.parentSubgraph = nestedSubgraph;
    }

    public NestedSubgraph getParentSubgraph() {
        return this.parentSubgraph;
    }

    public double getPosition() {
        return this.position;
    }

    public int countVertices(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.children.size()) {
            NestingTreeNode nestingTreeNode = (NestingTreeNode)this.children.get(n3);
            n2 += nestingTreeNode.countVertices(n);
            ++n3;
        }
        this.layerVertexCounts.put(new Integer(n), new Integer(n2));
        return n2;
    }

    public double computePosition(int n) {
        int n2 = this.countVertices(n);
        if (n2 == 0) {
            return Double.NaN;
        }
        double d = 0.0;
        int n3 = 0;
        while (n3 < this.children.size()) {
            NestingTreeNode nestingTreeNode = (NestingTreeNode)this.children.get(n3);
            double d2 = nestingTreeNode.computePosition(n);
            if (!Double.isNaN(d2)) {
                d += (double)nestingTreeNode.getVertexCount(n) * d2;
            }
            ++n3;
        }
        this.layerPositions.put(new Integer(n), new Double(d /= (double)n2));
        return d;
    }

    public int countVertices() {
        this.vertexCount = 0;
        int n = 0;
        while (n < this.children.size()) {
            NestingTreeNode nestingTreeNode = (NestingTreeNode)this.children.get(n);
            this.vertexCount += nestingTreeNode.countVertices();
            ++n;
        }
        return this.vertexCount;
    }

    public double getPosition(int n) {
        Double d = (Double)this.layerPositions.get(new Integer(n));
        return d != null ? d : Double.NaN;
    }

    public int getVertexCount(int n) {
        Integer n2 = (Integer)this.layerVertexCounts.get(new Integer(n));
        return n2 != null ? n2 : 0;
    }

    public int getVertexCount() {
        return this.vertexCount;
    }

    public double computePosition() {
        int n = this.countVertices();
        if (n == 0) {
            this.position = Double.NaN;
            return Double.NaN;
        }
        this.position = 0.0;
        int n2 = 0;
        while (n2 < this.children.size()) {
            NestingTreeNode nestingTreeNode = (NestingTreeNode)this.children.get(n2);
            double d = nestingTreeNode.computePosition();
            if (!Double.isNaN(d)) {
                this.position += (double)nestingTreeNode.getVertexCount() * d;
            }
            ++n2;
        }
        this.position /= (double)n;
        return this.position;
    }

    public int reindex(int n, int n2) {
        return this.reindex(n, n2, new PositionComparator(n), new PositionPredicate(n));
    }

    public int reindex(int n, int n2, Comparator comparator, Predicate predicate) {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n3 = 0;
        while (n3 < this.children.size()) {
            object = (NestingTreeNode)this.children.get(n3);
            if (object.includesRank(n)) {
                arrayList.add(object);
            }
            ++n3;
        }
        Collections.sort(arrayList, comparator);
        object = arrayList.iterator();
        while (object.hasNext()) {
            NestingTreeNode nestingTreeNode = (NestingTreeNode)object.next();
            n2 = nestingTreeNode.reindex(n, n2, comparator, predicate);
            if (!(nestingTreeNode instanceof LayerVertex)) continue;
            LayerVertex layerVertex = (LayerVertex)nestingTreeNode;
        }
        return n2;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean includesRank(int n) {
        return this.minRank <= n && n <= this.maxRank;
    }

    public static class PositionPredicate
    implements Predicate {
        private int rank = -1;

        public PositionPredicate() {
        }

        public PositionPredicate(int n) {
            this.rank = n;
        }

        public boolean evaluate(Object object) {
            NestingTreeNode nestingTreeNode = (NestingTreeNode)object;
            if (this.rank < 0) {
                return !Double.isNaN(nestingTreeNode.getPosition());
            }
            return !Double.isNaN(nestingTreeNode.getPosition(this.rank));
        }
    }

    public static class PositionComparator
    implements Comparator {
        private int rank = -1;

        public PositionComparator() {
        }

        public PositionComparator(int n) {
            this.rank = n;
        }

        public int compare(Object object, Object object2) {
            NestingTreeNode nestingTreeNode = (NestingTreeNode)object;
            NestingTreeNode nestingTreeNode2 = (NestingTreeNode)object2;
            if (this.rank < 0) {
                return Double.compare(nestingTreeNode.getPosition(), nestingTreeNode2.getPosition());
            }
            return Double.compare(nestingTreeNode.getPosition(this.rank), nestingTreeNode2.getPosition(this.rank));
        }
    }
}

