/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.modules.screens;

import com.aimluck.eip.common.ALPermissionException;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.services.storage.ALStorageService;
import com.aimluck.eip.util.ALEipUtils;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.modules.screens.RawScreen;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;

public class FileuploadRawScreen
extends RawScreen {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)FileuploadRawScreen.class.getName());
    private String fileName = null;
    private String filepath = null;

    protected String getContentType(RunData rundata) {
        return "application/octet-stream";
    }

    protected String getFileName() {
        return this.fileName;
    }

    protected String getFilePath() {
        return this.filepath;
    }

    protected void setFileName(String fileName) {
        this.fileName = fileName;
    }

    protected void setFilePath(String filepath) {
        this.filepath = filepath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doOutput(RunData rundata) throws Exception {
        InputStream in = null;
        OutputStream out = null;
        try {
            int length;
            String attachmentRealName = null;
            boolean isAndroid = ALEipUtils.isAndroidBrowser((RunData)rundata);
            if (isAndroid) {
                attachmentRealName = "file";
                if (this.getFileName().lastIndexOf(".") > -1) {
                    attachmentRealName = attachmentRealName + this.getFileName().substring(this.getFileName().lastIndexOf("."));
                }
            } else {
                boolean isMsie = ALEipUtils.isMsieBrowser((RunData)rundata);
                attachmentRealName = isMsie ? new String(this.getFileName().getBytes("Windows-31J"), "8859_1") : new String(this.getFileName().getBytes("UTF-8"), "8859_1");
            }
            HttpServletResponse response = rundata.getResponse();
            response.setHeader("Content-disposition", "attachment; filename=\"" + attachmentRealName + "\"");
            response.setHeader("Cache-Control", "aipo");
            response.setHeader("Pragma", "aipo");
            out = response.getOutputStream();
            String path = this.getFilePath();
            if (path == null || "".equals(path)) {
                throw new FileNotFoundException();
            }
            in = ALStorageService.getFile((String)this.filepath);
            out = new BufferedOutputStream((OutputStream)response.getOutputStream());
            byte[] buf = new byte[1024];
            while ((length = in.read(buf)) > 0) {
                out.write(buf, 0, length);
            }
        }
        catch (Exception e) {
            logger.error((Object)"FileuploadRawScreen.doOutput", (Throwable)e);
        }
        finally {
            try {
                if (out != null) {
                    out.flush();
                    out.close();
                }
            }
            catch (IOException ex) {
                logger.error((Object)"FileuploadRawScreen.doOutput", (Throwable)ex);
            }
        }
    }

    protected boolean doCheckAclPermission(RunData rundata, String pfeature, int defineAclType) throws ALPermissionException {
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        if (!aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), pfeature, defineAclType)) {
            throw new ALPermissionException();
        }
        return true;
    }
}

