/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.commons.field;

import com.aimluck.commons.field.ALAbstractField;
import com.aimluck.commons.field.ALDateContainer;
import com.aimluck.commons.field.ALIllegalDateException;
import com.aimluck.commons.utils.ALStringUtil;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.StringTokenizer;

public class ALDateField
extends ALAbstractField {
    private static final long serialVersionUID = 5926176023655878545L;
    protected ALDateContainer value = null;

    public ALDateField() {
    }

    public ALDateField(ALDateContainer container) {
        this.setValue(container);
    }

    public void setValue(ALDateContainer container) {
        this.value = container;
    }

    public ALDateContainer getValue() {
        return this.value;
    }

    public boolean validate(List<String> msgList) {
        if (msgList == null) {
            msgList = new ArrayList<String>();
        }
        if (!this.isNotNullValue()) {
            if (this.isNotNull()) {
                msgList.add(ALLocalizationUtils.getl10nFormat("COMMONS_FIELD_INPUT_NAME_SPAN", this.fieldName));
                return false;
            }
        } else {
            try {
                this.value.getDate();
                int year = this.value.getYear();
                if (year <= 1582) {
                    msgList.add(ALLocalizationUtils.getl10nFormat("COMMONS_FIELD_ERROR_DATE", this.fieldName));
                    return false;
                }
            }
            catch (NumberFormatException ex) {
                msgList.add(ALLocalizationUtils.getl10nFormat("COMMONS_FIELD_INPUT_ERROR_SPAN", this.fieldName));
                return false;
            }
            catch (ALIllegalDateException ex) {
                msgList.add(ALLocalizationUtils.getl10nFormat("COMMONS_FIELD_INPUT_ERROR_SPAN", this.fieldName));
                return false;
            }
        }
        return true;
    }

    public String toStringYear() {
        if (this.value == null) {
            return ALStringUtil.sanitizing(null);
        }
        return ALStringUtil.sanitizing(this.value.toStringYear());
    }

    public String toStringMonth() {
        if (this.value == null) {
            return ALStringUtil.sanitizing(null);
        }
        return ALStringUtil.sanitizing(this.value.toStringMonth());
    }

    public String toStringDay() {
        if (this.value == null) {
            return ALStringUtil.sanitizing(null);
        }
        return ALStringUtil.sanitizing(this.value.toStringDay());
    }

    @Override
    public void setValue(String str) {
        if (str == null) {
            this.value = null;
            return;
        }
        String year = null;
        String month = null;
        String day = null;
        StringTokenizer st = new StringTokenizer(str.trim(), "-");
        if (!st.hasMoreTokens()) {
            this.value = null;
            return;
        }
        year = st.nextToken();
        if (!st.hasMoreTokens()) {
            this.value = null;
            return;
        }
        month = st.nextToken();
        if (!st.hasMoreTokens()) {
            this.value = null;
            return;
        }
        day = st.nextToken();
        this.value = new ALDateContainer();
        this.value.setYear(year);
        this.value.setMonth(month);
        this.value.setDay(day);
    }

    public void setValue(Date date) {
        String year = null;
        String month = null;
        String day = null;
        try {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(date);
            year = Integer.toString(calendar.get(1));
            month = Integer.toString(calendar.get(2) + 1);
            day = Integer.toString(calendar.get(5));
        }
        catch (Throwable ex) {
            this.value = null;
        }
        this.value = new ALDateContainer();
        this.value.setYear(year);
        this.value.setMonth(month);
        this.value.setDay(day);
    }

    public String getYear() {
        return this.toStringYear();
    }

    public String getMonth() {
        return this.toStringMonth();
    }

    public String getDay() {
        return this.toStringDay();
    }

    protected boolean isNotNullValue() {
        return this.value != null && (!this.value.isNullYear() || !this.value.isNullMonth() || !this.value.isNullDay());
    }

    public String toString() {
        if (this.value == null) {
            return ALStringUtil.sanitizing(null);
        }
        return ALStringUtil.sanitizing(this.value.toStringYear() + '/' + this.value.toStringMonth() + '/' + this.value.toStringDay());
    }
}

