/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.common;

import com.aimluck.eip.common.ALEipConstants;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;

public class ALEipInformation {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALEipInformation.class.getName());
    protected static final String KEY_ENCODING = "content.defaultencoding";
    protected static final String DATE_KEY = "aipo.information.date";
    protected static final String TEXT_KEY = "aipo.information.text";
    protected static final String INFORMATION_CONFIG_CONCATE = "=";
    public static final String INFORMATION_COOKIE_PREFIX = "aui_info_disp_";
    public static final String INFORMATION_TITLE = JetspeedResources.getString((String)"aipo.alias");
    private static ALEipInformation information = new ALEipInformation();
    private final String FILE_INFORMATION_DEFAULT = JetspeedResources.getString((String)"aipo.home", (String)"").equals("") ? "" : JetspeedResources.getString((String)"aipo.home", (String)"") + File.separator + "conf" + File.separator + "information.properties";
    private String informationText = "";
    private String informationDate = "";
    private String informationCookie = "";

    private ALEipInformation() {
        this.loadInformations();
    }

    public static ALEipInformation getInstance() {
        return information;
    }

    private void loadInformations() {
        File defaultFile = new File(this.FILE_INFORMATION_DEFAULT);
        this.informationText = "";
        this.informationDate = "";
        this.informationCookie = "";
        BufferedReader reader = null;
        try {
            if (defaultFile.exists()) {
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(defaultFile), ALEipConstants.DEF_CONTENT_ENCODING));
                this.loadInformation(reader);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"ALEipInformation.loadInformations", (Throwable)ex);
            return;
        }
    }

    private void loadInformation(BufferedReader reader) throws Exception {
        if (reader == null) {
            return;
        }
        String line = null;
        while ((line = reader.readLine()) != null) {
            String dayStr;
            if (line.startsWith("#")) continue;
            if (line.startsWith(DATE_KEY) && (dayStr = line.replaceAll("aipo.information.date=", "")) != null && !"".equals(dayStr)) {
                this.informationDate = dayStr;
                this.informationCookie = INFORMATION_COOKIE_PREFIX + dayStr;
            }
            if (!line.startsWith(TEXT_KEY) || (dayStr = line.replaceAll("aipo.information.text=", "")) == null || "".equals(dayStr)) continue;
            this.informationText = dayStr;
        }
    }

    public String getInformationText() {
        return this.informationText;
    }

    public String getInformationDate() {
        return this.informationDate;
    }

    public String getInformationCookie() {
        return this.informationCookie;
    }
}

