/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.filter;

import com.aimluck.eip.cayenne.om.account.JetspeedUserProfile;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.om.profile.Entry;
import org.apache.jetspeed.om.profile.Layout;
import org.apache.jetspeed.om.profile.Parameter;
import org.apache.jetspeed.om.profile.Portlets;
import org.apache.jetspeed.om.profile.psml.PsmlEntry;
import org.apache.jetspeed.om.profile.psml.PsmlLayout;
import org.apache.jetspeed.om.profile.psml.PsmlParameter;
import org.apache.jetspeed.services.idgenerator.JetspeedIdGenerator;
import org.apache.jetspeed.services.psmlmanager.db.DBUtils;
import org.exolab.castor.mapping.Mapping;
import org.xml.sax.InputSource;

public class ALMigrateFilter
implements Filter {
    public FilterConfig filterConfig;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        chain.doFilter(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
        ServletContext servletContext = this.filterConfig.getServletContext();
        InputStream resourceAsStream = servletContext.getResourceAsStream("WEB-INF/datasource/dbcp-org001.properties");
        Connection conn = null;
        Statement stmt = null;
        try {
            Properties dbcpProp = new Properties();
            dbcpProp.load(resourceAsStream);
            String driverClassName = dbcpProp.get("cayenne.dbcp.driverClassName").toString();
            String url = dbcpProp.get("cayenne.dbcp.url").toString();
            String username = dbcpProp.get("cayenne.dbcp.username").toString();
            String password = dbcpProp.get("cayenne.dbcp.password").toString();
            if (url.startsWith("jdbc:postgresql")) {
                Class.forName(driverClassName);
                System.out.println("Connecting to " + url);
                conn = DriverManager.getConnection(url, username, password);
                stmt = conn.createStatement();
                ArrayList<String> columnsTurbineUser = new ArrayList<String>();
                DatabaseMetaData meta = conn.getMetaData();
                ResultSet columns = meta.getColumns(null, null, "turbine_user", null);
                while (columns.next()) {
                    columnsTurbineUser.add(columns.getString("COLUMN_NAME").toUpperCase());
                }
                columns.close();
                boolean hasBatch = false;
                if (!columnsTurbineUser.contains("TUTORIAL_FORBID")) {
                    stmt.addBatch("ALTER TABLE TURBINE_USER ADD COLUMN TUTORIAL_FORBID VARCHAR (1) DEFAULT 'F';");
                    stmt.addBatch("UPDATE TURBINE_USER SET TUTORIAL_FORBID = 'T' ;");
                    hasBatch = true;
                }
                if (!columnsTurbineUser.contains("PHOTO_MODIFIED_SMARTPHONE")) {
                    stmt.addBatch("UPDATE EIP_T_ACL_PORTLET_FEATURE SET ACL_TYPE = 41 WHERE FEATURE_ID = 172 AND FEATURE_NAME = 'timecard_timecard_other';");
                    stmt.addBatch("UPDATE EIP_T_ACL_PORTLET_FEATURE SET ACL_TYPE = 45 WHERE FEATURE_ID = 172 AND FEATURE_NAME = 'timecard_timecard_other';");
                    stmt.addBatch("ALTER TABLE activity ALTER COLUMN title TYPE character varying(255);");
                    stmt.addBatch("ALTER TABLE activity ALTER COLUMN title SET NOT NULL;");
                    if (!columnsTurbineUser.contains("PHOTO_SMARTPHONE")) {
                        stmt.addBatch("ALTER TABLE turbine_user  ADD PHOTO_SMARTPHONE bytea;");
                    }
                    if (!columnsTurbineUser.contains("HAS_PHOTO_SMARTPHONE")) {
                        stmt.addBatch("ALTER TABLE turbine_user  ADD HAS_PHOTO_SMARTPHONE  VARCHAR (1) DEFAULT 'F';");
                    }
                    stmt.addBatch("ALTER TABLE turbine_user  ADD PHOTO_MODIFIED_SMARTPHONE TIMESTAMP;");
                    hasBatch = true;
                }
                if (hasBatch) {
                    stmt.executeBatch();
                }
                SelectQuery query = new SelectQuery(JetspeedUserProfile.class);
                Expression exp = ExpressionFactory.matchExp((String)"mediaType", (Object)"html");
                query.setQualifier(exp);
                DataContext dataContext = DataContext.getThreadDataContext();
                List list = dataContext.performQuery((Query)query);
                String mapFile = "conf/psml-mapping.xml";
                File map = new File(mapFile);
                Mapping mapping = new Mapping();
                InputSource is = new InputSource(new FileReader(map));
                is.setSystemId(mapFile);
                mapping.loadMapping(is);
                if (list != null) {
                    for (JetspeedUserProfile prof : list) {
                        Portlets portlets = DBUtils.bytesToPortlets((byte[])prof.getProfile(), (Mapping)mapping);
                        Iterator iterator = portlets.getPortletsIterator();
                        while (iterator.hasNext()) {
                            Layout layout;
                            Portlets childPortlets = (Portlets)iterator.next();
                            long afterPos = 0L;
                            for (Entry entry : childPortlets.getEntriesArray()) {
                                if (!"Cellular".equals(entry.getParent())) continue;
                                layout = entry.getLayout();
                                afterPos = layout.getPosition();
                                break;
                            }
                            for (Entry entry : childPortlets.getEntriesArray()) {
                                layout = entry.getLayout();
                                if ("Cellular".equals(entry.getParent())) {
                                    PsmlEntry entryPsml = new PsmlEntry();
                                    entryPsml.setId(JetspeedIdGenerator.getNextPeid());
                                    entryPsml.setParent("Cellular");
                                    PsmlLayout newLayout = new PsmlLayout();
                                    PsmlParameter columnParam = new PsmlParameter();
                                    columnParam.setName("column");
                                    columnParam.setValue("0");
                                    PsmlParameter rowParam = new PsmlParameter();
                                    rowParam.setName("row");
                                    rowParam.setValue("0");
                                    newLayout.addParameter((Parameter)columnParam);
                                    newLayout.addParameter((Parameter)rowParam);
                                    newLayout.setPosition(layout.getPosition() + 1L);
                                    entryPsml.setLayout((Layout)newLayout);
                                    childPortlets.addEntry((Entry)entryPsml);
                                    continue;
                                }
                                if (layout.getPosition() <= afterPos) continue;
                                layout.setPosition(layout.getPosition() + 1L);
                            }
                            byte[] newProfBytes = DBUtils.portletsToBytes((Portlets)portlets, (Mapping)mapping);
                            prof.setProfile(newProfBytes);
                            dataContext.commitChanges();
                        }
                    }
                }
            }
        }
        catch (SQLException e) {
            while (e != null) {
                System.err.println(e.getMessage());
                System.err.println(e.getSQLState());
                System.err.println(e.getErrorCode());
                System.out.println("");
                e = e.getNextException();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                stmt.close();
            }
            catch (Exception i2) {}
            try {
                conn.close();
            }
            catch (Exception i3) {}
        }
    }

    public void destroy() {
    }
}

