/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.modules.actions.portlets;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.common.ALApplication;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.services.portal.ALPortalApplicationService;
import com.aimluck.eip.services.social.ALApplicationService;
import com.aimluck.eip.services.social.model.ALApplicationGetRequest;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.CustomizeUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.jetspeed.modules.actions.portlets.PortletFilter;
import org.apache.jetspeed.modules.actions.portlets.VelocityPortletAction;
import org.apache.jetspeed.om.BaseSecurityReference;
import org.apache.jetspeed.om.SecurityReference;
import org.apache.jetspeed.om.profile.Control;
import org.apache.jetspeed.om.profile.Controller;
import org.apache.jetspeed.om.profile.Entry;
import org.apache.jetspeed.om.profile.IdentityElement;
import org.apache.jetspeed.om.profile.Layout;
import org.apache.jetspeed.om.profile.MetaInfo;
import org.apache.jetspeed.om.profile.PSMLDocument;
import org.apache.jetspeed.om.profile.Parameter;
import org.apache.jetspeed.om.profile.Portlets;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.profile.ProfileException;
import org.apache.jetspeed.om.profile.ProfileLocator;
import org.apache.jetspeed.om.profile.QueryLocator;
import org.apache.jetspeed.om.profile.Reference;
import org.apache.jetspeed.om.profile.Skin;
import org.apache.jetspeed.om.profile.psml.PsmlControl;
import org.apache.jetspeed.om.profile.psml.PsmlController;
import org.apache.jetspeed.om.profile.psml.PsmlEntry;
import org.apache.jetspeed.om.profile.psml.PsmlLayout;
import org.apache.jetspeed.om.profile.psml.PsmlMetaInfo;
import org.apache.jetspeed.om.profile.psml.PsmlParameter;
import org.apache.jetspeed.om.profile.psml.PsmlPortlets;
import org.apache.jetspeed.om.profile.psml.PsmlReference;
import org.apache.jetspeed.om.profile.psml.PsmlSkin;
import org.apache.jetspeed.om.registry.PortletEntry;
import org.apache.jetspeed.om.registry.PortletInfoEntry;
import org.apache.jetspeed.om.registry.RegistryEntry;
import org.apache.jetspeed.om.registry.base.BaseCategory;
import org.apache.jetspeed.om.registry.base.BasePortletEntry;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.portal.PortletController;
import org.apache.jetspeed.portal.PortletSet;
import org.apache.jetspeed.portal.PortletSetController;
import org.apache.jetspeed.portal.PortletSkin;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.PortalToolkit;
import org.apache.jetspeed.services.Profiler;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.services.TemplateLocator;
import org.apache.jetspeed.services.customlocalization.CustomLocalization;
import org.apache.jetspeed.services.idgenerator.JetspeedIdGenerator;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.security.PortalResource;
import org.apache.jetspeed.services.statemanager.SessionState;
import org.apache.jetspeed.util.AutoProfile;
import org.apache.jetspeed.util.PortletSessionState;
import org.apache.jetspeed.util.template.JetspeedLink;
import org.apache.jetspeed.util.template.JetspeedLinkFactory;
import org.apache.turbine.services.localization.Localization;
import org.apache.turbine.util.DynamicURI;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ALCustomizeSetAction
extends VelocityPortletAction {
    private static final String USER_SELECTIONS = "session.portlets.user.selections";
    private static final String UI_PORTLETS_SELECTED = "portletsSelected";
    private static final String PORTLET_LIST = "session.portlets.list";
    private static final String HIDE_EMPTY_CATEGORIES = "customizer.hide.empty.categories";
    public static final String FILTER_FIELDS = "filter_fields";
    public static final String FILTER_VALUES = "filter_values";
    protected boolean hasAuthority;
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALCustomizeSetAction.class.getName());

    protected void buildNormalContext(VelocityPortlet portlet, Context context, RunData rundata) throws Exception {
        String template;
        JetspeedRunData jdata = (JetspeedRunData)rundata;
        SessionState customizationState = jdata.getPageSessionState();
        Profile profile = jdata.getCustomizedProfile();
        String mediaType = profile.getMediaType();
        context.put("mtype", (Object)profile.getMediaType());
        context.put("runs", (Object)AutoProfile.getPortletList((RunData)rundata));
        PortletSet set = (PortletSet)jdata.getCustomized();
        String mode = rundata.getParameters().getString("mode");
        if (mode == null) {
            mode = (String)customizationState.getAttribute("customize-mode");
            if (mode == null || mode.equalsIgnoreCase("addset") || mode.equalsIgnoreCase("general")) {
                mode = "layout";
                customizationState.setAttribute("customize-mode", (Object)mode);
            }
        } else {
            if (mediaType.equalsIgnoreCase("wml") && !mode.equalsIgnoreCase("add")) {
                mode = "layout";
            }
            customizationState.setAttribute("customize-mode", (Object)mode);
        }
        if ((template = (String)context.get("template")) != null) {
            int idx = template.lastIndexOf(".");
            if (idx > 0) {
                template = template.substring(0, idx);
            }
            StringBuffer buffer = new StringBuffer(template);
            buffer.append("-").append(mode).append(".vm");
            template = TemplateLocator.locatePortletTemplate((RunData)rundata, (String)buffer.toString());
            context.put("feature", (Object)template);
        }
        if (set == null) {
            return;
        }
        String customizedPaneName = (String)customizationState.getAttribute("customize-paneName");
        if (customizedPaneName == null) {
            customizedPaneName = "*";
        }
        context.put("panename", (Object)customizedPaneName);
        context.put("skin", (Object)set.getPortletConfig().getPortletSkin());
        context.put("set", (Object)set);
        context.put("action", (Object)"portlets.ALCustomizeSetAction");
        context.put("controllers", ALCustomizeSetAction.buildInfoList(rundata, Registry.PORTLET_CONTROLLER, mediaType));
        context.put("customizer", (Object)portlet);
        String controllerName = set.getController().getConfig().getName();
        context.put("currentController", (Object)controllerName);
        context.put("currentSecurityRef", (Object)set.getPortletConfig().getSecurityRef());
        context.put("utils", (Object)new ALCommonUtils());
        this.setContexts(rundata, context);
        if (mediaType.equalsIgnoreCase("wml")) {
            context.put("currentSkin", (Object)"Not for wml!");
            context.put("allowproperties", (Object)"false");
        } else {
            if (set.getPortletConfig().getSkin() != null) {
                context.put("currentSkin", (Object)set.getPortletConfig().getPortletSkin().getName());
            }
            context.put("allowproperties", (Object)"true");
        }
        context.put("allowpane", (Object)"true");
        if (!mediaType.equalsIgnoreCase("wml") && set.getController() instanceof PortletSetController) {
            if (customizedPaneName != null) {
                context.put("allowpane", (Object)"true");
            }
        } else {
            context.put("allowportlet", (Object)"true");
        }
        if ("add".equals(mode)) {
            ALEipUtils.checkAclPermissionForCustomize(rundata, context, 4);
            int start = rundata.getParameters().getInt("start", -1);
            if (start < 0) {
                start = 0;
                PortletSessionState.clearAttribute((RunData)rundata, (String)USER_SELECTIONS);
                PortletSessionState.clearAttribute((RunData)rundata, (String)PORTLET_LIST);
            }
            ArrayList<PortletEntry> allPortlets = new ArrayList<PortletEntry>();
            List<PortletEntry> portlets = ALCustomizeSetAction.buildPortletList(rundata, set, mediaType, allPortlets);
            Map<String, PortletEntry> userSelections = ALCustomizeSetAction.getUserSelections(rundata);
            List<BaseCategory> categories = ALCustomizeSetAction.buildCategoryList(rundata, mediaType, allPortlets);
            context.put("categories", categories);
            context.put("parents", (Object)PortletFilter.buildParentList(allPortlets));
            this.addFiltersToContext(rundata, context);
            int size = this.getSize(portlet);
            int end = Math.min(start + size, portlets.size());
            if (start > 0) {
                context.put("prev", (Object)String.valueOf(Math.max(start - size, 0)));
            }
            if (start + size < portlets.size()) {
                context.put("next", (Object)String.valueOf(start + size));
            }
            context.put("browser", portlets.subList(start, end));
            context.put("size", (Object)size);
            context.put(UI_PORTLETS_SELECTED, userSelections);
            context.put("portlets", portlets);
        } else if ("addref".equals(mode)) {
            Iterator psmlIterator = null;
            psmlIterator = Profiler.query((QueryLocator)new QueryLocator(15));
            int start = rundata.getParameters().getInt("start", 0);
            int size = this.getSize(portlet);
            LinkedList<Profile> psmlList = new LinkedList<Profile>();
            Profile refProfile = null;
            int profileCounter = 0;
            while (psmlIterator.hasNext()) {
                refProfile = (Profile)psmlIterator.next();
                if (refProfile.getMediaType() != null && !profile.getMediaType().equals(refProfile.getMediaType()) || (profile.getLanguage() == null ? refProfile.getLanguage() != null : refProfile.getLanguage() != null && (!profile.getLanguage().equals(refProfile.getLanguage()) || (profile.getCountry() != null ? refProfile.getCountry() != null && !profile.getCountry().equals(refProfile.getCountry()) : refProfile.getCountry() != null)))) continue;
                if (profile.getPath().equals(refProfile.getPath())) continue;
                if (profileCounter >= start + size) break;
                if (profileCounter >= start) {
                    psmlList.add(refProfile);
                }
                ++profileCounter;
            }
            if (start > 0) {
                context.put("prev", (Object)String.valueOf(Math.max(start - size, 0)));
            }
            if (size == psmlList.size() && psmlIterator.hasNext()) {
                context.put("next", (Object)String.valueOf(start + size));
            }
            context.put("psml", psmlList.iterator());
        }
    }

    private void setContexts(RunData rundata, Context context) {
        String pid = rundata.getParameters().get("js_peid");
        if (pid == null) {
            // empty if block
        }
        context.put("js_peid", (Object)pid);
        Portlets[] portletArrays = ((JetspeedRunData)rundata).getProfile().getDocument().getPortlets().getPortletsArray();
        ALStringField pageTitle = new ALStringField();
        String mypageId = "";
        for (Portlets p : portletArrays) {
            if ("\u30de\u30a4\u30da\u30fc\u30b8".equals(p.getTitle())) {
                mypageId = p.getId();
            }
            if (!p.getId().equals(pid)) continue;
            MetaInfo info = p.getMetaInfo();
            pageTitle.setValue(info.getTitle());
        }
        context.put("isMypage", (Object)"\u30de\u30a4\u30da\u30fc\u30b8".equals(pageTitle.getValue()));
        context.put("mypageId", (Object)mypageId);
        context.put("globalPortlets", ALEipUtils.getGlobalPortlets(rundata));
        context.put("pageTitle", (Object)pageTitle);
        context.put("secid", rundata.getUser().getTemp("secid"));
    }

    public int getSize(VelocityPortlet portlet) {
        int size = 30;
        try {
            size = Integer.parseInt(portlet.getPortletConfig().getInitParameter("size"));
        }
        catch (Exception e) {
            logger.debug((Object)"CustomizeSetAction: Init param 'size' not parsed");
        }
        return size;
    }

    public void doCancel(RunData rundata, Context context) {
        SessionState customizationState = ((JetspeedRunData)rundata).getPageSessionState();
        customizationState.setAttribute("customize-mode", (Object)"layout");
    }

    public void doSave(RunData rundata, Context context) {
        this.doMetainfo(rundata, context);
        this.doSkin(rundata, context);
        this.doLayout(rundata, context);
        this.doSecurity(rundata, context);
        Profile profile = ((JetspeedRunData)rundata).getCustomizedProfile();
        try {
            String mtype = rundata.getParameters().getString("mtype");
            if (mtype != null) {
                profile.setMediaType(mtype);
            }
            profile.store();
        }
        catch (Exception e) {
            logger.error((Object)"Exception occured while saving PSML", (Throwable)e);
        }
    }

    public void doApply(RunData rundata, Context context) {
        this.doSave(rundata, context);
    }

    public void doAddset(RunData rundata, Context context) {
        Portlets portlets = ((JetspeedRunData)rundata).getCustomizedProfile().getDocument().getPortlets();
        String title = rundata.getParameters().getString("title", "My Pane");
        if (portlets != null) {
            Portlets[] portletList = portlets.getPortletsArray();
            long position = 0L;
            long tmpPosition = 0L;
            int index = 0;
            int length = portletList.length;
            for (int i = 0; i < length; ++i) {
                tmpPosition = portletList[i].getLayout().getPosition();
                if (position >= tmpPosition) continue;
                position = tmpPosition;
                index = i;
            }
            portletList[index].getLayout().setPosition(position + 1L);
            PsmlLayout newLayout = new PsmlLayout();
            newLayout.setPosition(position);
            newLayout.setSize(-1L);
            PsmlPortlets p = new PsmlPortlets();
            p.setLayout((Layout)newLayout);
            p.setMetaInfo((MetaInfo)new PsmlMetaInfo());
            p.getMetaInfo().setTitle(title);
            p.setId(JetspeedIdGenerator.getNextPeid());
            SecurityReference defaultRef = PortalToolkit.getDefaultSecurityRef((Profile)((JetspeedRunData)rundata).getCustomizedProfile());
            if (defaultRef != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("CustomizeSetAction: setting default portlet set security to [" + defaultRef.getParent() + "]"));
                }
                p.setSecurityRef(defaultRef);
            }
            portlets.addPortlets((Portlets)p);
        }
        SessionState customizationState = ((JetspeedRunData)rundata).getPageSessionState();
        customizationState.setAttribute("customize-mode", (Object)"layout");
    }

    public void doPrevious(RunData rundata, Context context) throws Exception {
        int queryStart = rundata.getParameters().getInt("previous", 0);
        String mtype = rundata.getParameters().getString("mtype", null);
        this.maintainUserSelections(rundata);
        JetspeedLink link = JetspeedLinkFactory.getInstance((RunData)rundata);
        DynamicURI duri = null;
        duri = mtype == null ? link.setTemplate("Customize").addQueryData("start", String.valueOf(queryStart)) : link.setTemplate("Customize").addQueryData("start", String.valueOf(queryStart)).addQueryData("mtype", mtype);
        JetspeedLinkFactory.putInstance((JetspeedLink)link);
        rundata.setRedirectURI(duri.toString());
    }

    public void doNext(RunData rundata, Context context) throws Exception {
        int queryStart = rundata.getParameters().getInt("next", 0);
        String mtype = rundata.getParameters().getString("mtype", null);
        this.maintainUserSelections(rundata);
        JetspeedLink link = JetspeedLinkFactory.getInstance((RunData)rundata);
        DynamicURI duri = null;
        duri = mtype == null ? link.setTemplate("Customize").addQueryData("start", String.valueOf(queryStart)) : link.setTemplate("Customize").addQueryData("start", String.valueOf(queryStart)).addQueryData("mtype", mtype);
        JetspeedLinkFactory.putInstance((JetspeedLink)link);
        rundata.setRedirectURI(duri.toString());
    }

    protected void maintainUserSelections(RunData rundata) throws Exception {
        String[] pnames = rundata.getParameters().getStrings("pname");
        Map<String, PortletEntry> userSelections = ALCustomizeSetAction.getUserSelections(rundata);
        List portlets = (List)PortletSessionState.getAttribute((RunData)rundata, (String)PORTLET_LIST, null);
        if (portlets != null) {
            block0: for (String pname : pnames) {
                for (PortletEntry entry : portlets) {
                    String name = entry.getName();
                    if (!name.equals(pname)) continue;
                    userSelections.put(pname, userSelections.get(pname));
                    continue block0;
                }
            }
        } else {
            throw new Exception("Master Portlet List is null!");
        }
        PortletSessionState.setAttribute((RunData)rundata, (String)USER_SELECTIONS, userSelections);
    }

    public void doAdd(RunData rundata, Context context) throws Exception {
        PortletSet set = (PortletSet)((JetspeedRunData)rundata).getCustomized();
        this.maintainUserSelections(rundata);
        Map<String, PortletEntry> userSelections = ALCustomizeSetAction.getUserSelections(rundata);
        String[] pnames = new String[userSelections.size()];
        userSelections.keySet().toArray(pnames);
        PsmlControl ctrl = new PsmlControl();
        ctrl.setName("ClearPortletControl");
        if (pnames != null && set != null) {
            Portlets portlets = ((JetspeedRunData)rundata).getCustomizedProfile().getDocument().getPortletsById(set.getID());
            for (int i = 0; i < pnames.length; ++i) {
                boolean addIt;
                String pname = pnames[i];
                PortletEntry entry = null;
                boolean isGadgets = false;
                ALApplication app = null;
                if (pname.startsWith("GadgetsTemplate::")) {
                    String[] split = pname.split("::");
                    String appId = split[1];
                    app = ALApplicationService.get(new ALApplicationGetRequest().withAppId(appId));
                    entry = (PortletEntry)Registry.getEntry((String)Registry.PORTLET, (String)"GadgetsTemplate");
                    isGadgets = true;
                } else {
                    entry = (PortletEntry)Registry.getEntry((String)Registry.PORTLET, (String)pnames[i]);
                }
                if (entry == null || portlets == null || !(addIt = true)) continue;
                PsmlEntry p = new PsmlEntry();
                p.setParent(isGadgets ? "GadgetsTemplate" : pnames[i]);
                p.setId(JetspeedIdGenerator.getNextPeid());
                if (isGadgets) {
                    p.setTitle(app.getTitle().getValue());
                    PsmlParameter p1 = new PsmlParameter();
                    p1.setName("aid");
                    p1.setValue(app.getAppId().getValue());
                    p.addParameter((Parameter)p1);
                    PsmlParameter p2 = new PsmlParameter();
                    p2.setName("url");
                    p2.setValue(app.getUrl().getValue());
                    p.addParameter((Parameter)p2);
                    PsmlParameter p3 = new PsmlParameter();
                    p3.setName("mid");
                    p3.setValue(String.valueOf(ALApplicationService.getNextModuleId()));
                    p.addParameter((Parameter)p3);
                }
                portlets.addEntry((Entry)p);
            }
        }
        this.doSaveAddAction(rundata, context);
        SessionState customizationState = ((JetspeedRunData)rundata).getPageSessionState();
        customizationState.setAttribute("customize-mode", (Object)"layout");
        JetspeedLink jsLink = JetspeedLinkFactory.getInstance((RunData)rundata);
        if (set != null) {
            rundata.setRedirectURI(jsLink.getTemplate().addPathInfo("js_peid", set.getID()).addPathInfo("mode", "layout").addQueryData("mtype", "html").addQueryData("action", "controls.Customize").toString());
            rundata.getResponse().sendRedirect(rundata.getRedirectURI());
            jsLink = null;
        }
    }

    public void doSaveAddAction(RunData data, Context context) {
        this.setPageLayout(data, context);
        SessionState customizationState = ((JetspeedRunData)data).getPageSessionState();
        List[] columns = (List[])customizationState.getAttribute("customize-columns");
        for (int col = 0; col < columns.length; ++col) {
            for (int row = 0; row < columns[col].size(); ++row) {
                ALCustomizeSetAction.setPosition((IdentityElement)columns[col].get(row), col, row);
            }
        }
        try {
            ((JetspeedRunData)data).getCustomizedProfile().store();
        }
        catch (Exception e) {
            logger.error((Object)"Unable to save profile ", (Throwable)e);
        }
    }

    public void doAddref(RunData rundata, Context context) throws Exception {
        PortletSet set = (PortletSet)((JetspeedRunData)rundata).getCustomized();
        String[] refNames = rundata.getParameters().getStrings("refname");
        PsmlControl ctrl = new PsmlControl();
        ctrl.setName("ClearPortletControl");
        if (refNames != null && set != null) {
            Portlets portlets = ((JetspeedRunData)rundata).getCustomizedProfile().getDocument().getPortletsById(set.getID());
            for (int i = 0; i < refNames.length; ++i) {
                SecurityReference sref = this.getSecurityReference(rundata, refNames[i]);
                if (sref != null) {
                    PsmlReference ref = new PsmlReference();
                    ref.setPath(refNames[i]);
                    ref.setSecurityRef(sref);
                    portlets.addReference((Reference)ref);
                    continue;
                }
                String tmpl = CustomLocalization.getString((String)"CUSTOMIZER_ADD_REF_ERROR", (RunData)rundata);
                Object[] args = new Object[]{refNames[i]};
                String message = MessageFormat.format(tmpl, args);
                rundata.addMessage(message.concat("<br>"));
                if (!logger.isWarnEnabled()) continue;
                logger.warn((Object)message);
            }
        }
        SessionState customizationState = ((JetspeedRunData)rundata).getPageSessionState();
        customizationState.setAttribute("customize-mode", (Object)"layout");
    }

    protected SecurityReference getSecurityReference(RunData rundata, String path) {
        try {
            PSMLDocument doc;
            ProfileLocator locator = Profiler.createLocator();
            locator.createFromPath(path);
            Profile profile = Profiler.getProfile((ProfileLocator)locator);
            if (profile != null && (doc = profile.getDocument()) != null) {
                Portlets rootSet = doc.getPortlets();
                return rootSet.getSecurityRef();
            }
        }
        catch (ProfileException e) {
            logger.error((Object)"ALCustomizeSetAction.getSecurityReference", (Throwable)e);
        }
        return null;
    }

    public void doMetainfo(RunData rundata, Context context) {
        Portlets portlets;
        PortletSet set = (PortletSet)((JetspeedRunData)rundata).getCustomized();
        String title = rundata.getParameters().getString("title");
        String description = rundata.getParameters().getString("description");
        if (set != null && (portlets = ((JetspeedRunData)rundata).getCustomizedProfile().getDocument().getPortletsById(set.getID())) != null) {
            MetaInfo meta = portlets.getMetaInfo();
            if (meta == null) {
                meta = new PsmlMetaInfo();
                portlets.setMetaInfo(meta);
            }
            if (title != null) {
                meta.setTitle(title);
                set.setTitle(title);
            }
            if (description != null) {
                meta.setDescription(description);
                set.setDescription(description);
            }
        }
    }

    public void doLayout(RunData rundata, Context context) {
        ALEipUtils.checkAclPermissionForCustomize(rundata, context, 8);
        PortletSet set = (PortletSet)((JetspeedRunData)rundata).getCustomized();
        try {
            String controller = rundata.getParameters().getString("controller");
            if (controller != null) {
                Profile profile = ((JetspeedRunData)rundata).getCustomizedProfile();
                PortletController pc = PortalToolkit.getController((String)controller);
                if (pc != null) {
                    set.setController(pc);
                    Portlets portlets = profile.getDocument().getPortletsById(set.getID());
                    Controller c = portlets.getController();
                    if (c == null) {
                        c = new PsmlController();
                        portlets.setController(c);
                    }
                    c.setName(controller);
                    String linkedControl = pc.getConfig().getInitParameter("control");
                    if (linkedControl != null) {
                        PsmlControl ctl = new PsmlControl();
                        ctl.setName(linkedControl);
                        portlets.setControl((Control)ctl);
                    } else {
                        portlets.setControl(null);
                    }
                }
            }
            this.setContexts(rundata, context);
        }
        catch (Exception e) {
            logger.error((Object)"ALCustomizeSetAction.doLayout", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doSkin(RunData rundata, Context context) {
        PortletSet set = (PortletSet)((JetspeedRunData)rundata).getCustomized();
        try {
            String skin = rundata.getParameters().getString("skin");
            Profile profile = ((JetspeedRunData)rundata).getCustomizedProfile();
            Portlets portlets = profile.getDocument().getPortletsById(set.getID());
            if (skin != null && skin.trim().length() > 0) {
                PortletSkin s = PortalToolkit.getSkin((String)skin);
                if (s == null) {
                    logger.warn((Object)("Unable to update skin for portlet set " + set.getID() + " because skin " + skin + " does not exist."));
                    return;
                }
                set.getPortletConfig().setPortletSkin(s);
                Skin psmlSkin = portlets.getSkin();
                if (psmlSkin == null) {
                    portlets.setSkin((Skin)new PsmlSkin());
                }
                portlets.getSkin().setName(skin);
                return;
            }
            String custPortletSetID = portlets.getId();
            String rootPortletSetID = profile.getRootSet().getID();
            if (custPortletSetID != null && rootPortletSetID != null && custPortletSetID.equals(rootPortletSetID)) {
                String defaultSkinName = JetspeedResources.getString((String)"services.PortalToolkit.default.skin");
                PortletSkin defaultSkin = PortalToolkit.getSkin((String)defaultSkinName);
                if (defaultSkin == null) {
                    logger.warn((Object)("Unable to set default skin for root portlet set " + set.getID() + " because skin " + skin + " does not exist."));
                    return;
                }
                set.getPortletConfig().setPortletSkin(defaultSkin);
                Skin psmlSkin = portlets.getSkin();
                if (psmlSkin == null) {
                    portlets.setSkin((Skin)new PsmlSkin());
                }
                portlets.getSkin().setName(defaultSkin.getName());
                return;
            }
            set.getPortletConfig().setPortletSkin((PortletSkin)null);
            portlets.setSkin(null);
            return;
        }
        catch (Exception e) {
            logger.error((Object)"ALCustomizeSetAction.doSkin", (Throwable)e);
        }
    }

    public void doSecurity(RunData rundata, Context context) {
        PortletSet set = (PortletSet)((JetspeedRunData)rundata).getCustomized();
        try {
            String securityRefName = rundata.getParameters().getString("securityRef");
            BaseSecurityReference securityRef = null;
            Profile profile = ((JetspeedRunData)rundata).getCustomizedProfile();
            Portlets portlets = profile.getDocument().getPortletsById(set.getID());
            if (securityRefName != null && securityRefName.trim().length() > 0) {
                securityRef = new BaseSecurityReference();
                securityRef.setParent(securityRefName);
            }
            set.getPortletConfig().setSecurityRef(securityRef);
            portlets.setSecurityRef(securityRef);
        }
        catch (Exception e) {
            logger.error((Object)"ALCustomizeSetAction.doSecurity", (Throwable)e);
        }
    }

    public static List<PortletEntry> buildPortletList(RunData data, PortletSet set, String mediaType, List<PortletEntry> allPortlets) {
        ArrayList<PortletEntry> list = new ArrayList();
        Iterator i = Registry.get((String)Registry.PORTLET).listEntryNames();
        while (i.hasNext()) {
            PortletEntry entry = (PortletEntry)Registry.getEntry((String)Registry.PORTLET, (String)((String)i.next()));
            allPortlets.add(entry);
            if (!JetspeedSecurity.checkPermission((JetspeedUser)((JetspeedUser)data.getUser()), (PortalResource)new PortalResource((RegistryEntry)entry), (String)"view") || entry.isHidden() || entry.getType().equals("abstract") || !entry.hasMediaType(mediaType) || entry.getSecurityRef().getParent().equals("admin-view") || !CustomizeUtils.isAdminUserView(entry, data) || !ALPortalApplicationService.isActive(entry.getName())) continue;
            list.add(entry);
        }
        ResultList<ALApplication> resultList = ALApplicationService.getList(new ALApplicationGetRequest().withStatus(ALApplicationGetRequest.Status.ACTIVE));
        for (ALApplication app : resultList) {
            BasePortletEntry entry = new BasePortletEntry();
            entry.setTitle(app.getTitle().getValue());
            entry.setDescription(app.getDescription().getValue());
            entry.setName("GadgetsTemplate::" + app.getAppId().getValue());
            entry.setParent("GadgetsTemplate");
            entry.addParameter("aid", app.getAppId().getValue());
            entry.addParameter("url", app.getUrl().getValue());
            list.add((PortletEntry)entry);
        }
        String[] filterFields = (String[])PortletSessionState.getAttribute((RunData)data, (String)FILTER_FIELDS);
        String[] filterValues = (String[])PortletSessionState.getAttribute((RunData)data, (String)FILTER_VALUES);
        list = PortletFilter.filterPortlets(list, (String[])filterFields, (String[])filterValues);
        Collections.sort(list, new Comparator<PortletEntry>(){

            @Override
            public int compare(PortletEntry o1, PortletEntry o2) {
                String t1 = o1.getTitle() != null ? o1.getTitle().toLowerCase() : o1.getName().toLowerCase();
                String t2 = o2.getTitle() != null ? o2.getTitle().toLowerCase() : o2.getName().toLowerCase();
                return t1.compareTo(t2);
            }
        });
        PortletSessionState.setAttribute((RunData)data, (String)PORTLET_LIST, list);
        return list;
    }

    public static Map<String, PortletEntry> getUserSelections(RunData data) {
        HashMap userSelections = (HashMap)PortletSessionState.getAttribute((RunData)data, (String)USER_SELECTIONS, null);
        if (userSelections == null) {
            userSelections = new HashMap();
            PortletSessionState.setAttribute((RunData)data, (String)USER_SELECTIONS, userSelections);
        }
        return userSelections;
    }

    public static List<PortletInfoEntry> buildInfoList(RunData data, String regName, String mediaType) {
        ArrayList<PortletInfoEntry> list = new ArrayList<PortletInfoEntry>();
        Iterator i = Registry.get((String)regName).listEntryNames();
        while (i.hasNext()) {
            PortletInfoEntry entry = (PortletInfoEntry)Registry.getEntry((String)regName, (String)((String)i.next()));
            if (!JetspeedSecurity.checkPermission((JetspeedUser)((JetspeedUser)data.getUser()), (PortalResource)new PortalResource((RegistryEntry)entry), (String)"customize") || entry.isHidden() || !entry.hasMediaType(mediaType)) continue;
            list.add(entry);
        }
        Collections.sort(list, new Comparator<RegistryEntry>(){

            @Override
            public int compare(RegistryEntry o1, RegistryEntry o2) {
                String t1 = o1.getTitle() != null ? o1.getTitle() : o1.getName();
                String t2 = o2.getTitle() != null ? o2.getTitle() : o2.getName();
                return t1.compareTo(t2);
            }
        });
        return list;
    }

    public static List<RegistryEntry> buildList(RunData data, String regName) {
        ArrayList<RegistryEntry> list = new ArrayList<RegistryEntry>();
        Iterator i = Registry.get((String)regName).listEntryNames();
        while (i.hasNext()) {
            RegistryEntry entry = Registry.getEntry((String)regName, (String)((String)i.next()));
            if (!JetspeedSecurity.checkPermission((JetspeedUser)((JetspeedUser)data.getUser()), (PortalResource)new PortalResource(entry), (String)"customize") || entry.isHidden()) continue;
            list.add(entry);
        }
        Collections.sort(list, new Comparator<RegistryEntry>(){

            @Override
            public int compare(RegistryEntry o1, RegistryEntry o2) {
                String t1 = o1.getTitle() != null ? o1.getTitle() : o1.getName();
                String t2 = o2.getTitle() != null ? o2.getTitle() : o2.getName();
                return t1.compareTo(t2);
            }
        });
        return list;
    }

    public static List<BaseCategory> buildCategoryList(RunData data, String mediaType, List<PortletEntry> portlets) {
        boolean hideEmpties = JetspeedResources.getBoolean((String)HIDE_EMPTY_CATEGORIES, (boolean)true);
        TreeMap<String, BaseCategory> catMap = new TreeMap<String, BaseCategory>();
        for (PortletEntry entry : portlets) {
            BaseCategory cat;
            Iterator cItr;
            if (hideEmpties) {
                if (!JetspeedSecurity.checkPermission((JetspeedUser)((JetspeedUser)data.getUser()), (PortalResource)new PortalResource((RegistryEntry)entry), (String)"view") || entry.isHidden() || entry.getType().equals("abstract") || !entry.hasMediaType(mediaType)) continue;
                cItr = entry.listCategories();
                while (cItr.hasNext()) {
                    cat = (BaseCategory)cItr.next();
                    catMap.put(cat.getName(), cat);
                }
                continue;
            }
            cItr = entry.listCategories();
            while (cItr.hasNext()) {
                cat = (BaseCategory)cItr.next();
                catMap.put(cat.getName(), cat);
            }
        }
        return new ArrayList<BaseCategory>(catMap.values());
    }

    public void doFiltercategory(RunData rundata, Context context) throws Exception {
        String filterCat = rundata.getParameters().getString("filter_category", "All Portlets");
        PortletSessionState.setAttribute((RunData)rundata, (String)"filter_category", (Object)filterCat);
        this.maintainUserSelections(rundata);
        String mtype = rundata.getParameters().getString("mtype", null);
        JetspeedLink link = JetspeedLinkFactory.getInstance((RunData)rundata);
        DynamicURI duri = null;
        duri = mtype == null ? link.setTemplate("Customize").addQueryData("start", "0") : link.setTemplate("Customize").addQueryData("start", "0").addQueryData("mtype", mtype);
        JetspeedLinkFactory.putInstance((JetspeedLink)link);
        rundata.setRedirectURI(duri.toString());
    }

    public void doFilter(RunData rundata, Context context) throws Exception {
        String[] filterFields = rundata.getParameters().getStrings("filter_field");
        String[] filterValues = new String[filterFields.length];
        for (int i = 0; i < filterFields.length; ++i) {
            String filterValue;
            String filterField = filterFields[i];
            if (filterField == null) continue;
            filterValues[i] = filterValue = rundata.getParameters().getString(filterField + ":filter_value");
        }
        PortletSessionState.setAttribute((RunData)rundata, (String)FILTER_FIELDS, (Object)filterFields);
        PortletSessionState.setAttribute((RunData)rundata, (String)FILTER_VALUES, (Object)filterValues);
        this.maintainUserSelections(rundata);
        String mtype = rundata.getParameters().getString("mtype", null);
        JetspeedLink link = JetspeedLinkFactory.getInstance((RunData)rundata);
        DynamicURI duri = null;
        duri = mtype == null ? link.setTemplate("Customize").addQueryData("start", "0") : link.setTemplate("Customize").addQueryData("start", "0").addQueryData("mtype", mtype);
        JetspeedLinkFactory.putInstance((JetspeedLink)link);
        rundata.setRedirectURI(duri.toString());
    }

    private void addFiltersToContext(RunData data, Context context) {
        String[] filterFields = (String[])PortletSessionState.getAttribute((RunData)data, (String)FILTER_FIELDS);
        String[] filterValues = (String[])PortletSessionState.getAttribute((RunData)data, (String)FILTER_VALUES);
        if (filterFields != null && filterValues != null && filterFields.length == filterValues.length) {
            for (int i = 0; i < filterFields.length; ++i) {
                String field = filterFields[i];
                String value = filterValues[i];
                context.put(field + "_filter_value", (Object)value);
            }
        }
    }

    protected static void setPosition(IdentityElement identityElement, int col, int row) {
        boolean colFound = false;
        boolean rowFound = false;
        if (identityElement != null) {
            Layout layout = identityElement.getLayout();
            if (layout == null) {
                layout = new PsmlLayout();
                identityElement.setLayout(layout);
            }
            for (int i = 0; i < layout.getParameterCount(); ++i) {
                Parameter p = layout.getParameter(i);
                if (p.getName().equals("column")) {
                    p.setValue(String.valueOf(col));
                    colFound = true;
                    continue;
                }
                if (!p.getName().equals("row")) continue;
                p.setValue(String.valueOf(row));
                rowFound = true;
            }
            if (!colFound) {
                PsmlParameter p = new PsmlParameter();
                p.setName("column");
                p.setValue(String.valueOf(col));
                layout.addParameter((Parameter)p);
            }
            if (!rowFound) {
                PsmlParameter p = new PsmlParameter();
                p.setName("row");
                p.setValue(String.valueOf(row));
                layout.addParameter((Parameter)p);
            }
        }
    }

    private void setPageLayout(RunData rundata, Context context) {
        JetspeedRunData jdata = (JetspeedRunData)rundata;
        SessionState customizationState = jdata.getPageSessionState();
        PortletSet portletSet = (PortletSet)jdata.getCustomized();
        PortletController controller = portletSet.getController();
        Object[] columns = null;
        String cols = controller.getConfig().getInitParameter("cols");
        int colNum = 0;
        try {
            colNum = Integer.parseInt(cols);
        }
        catch (Exception e) {
            colNum = 3;
        }
        columns = (List[])customizationState.getAttribute("customize-columns");
        PortletSet customizedSet = (PortletSet)jdata.getCustomized();
        Portlets set = jdata.getCustomizedProfile().getDocument().getPortletsById(customizedSet.getID());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("MultiCol: columns " + Arrays.toString(columns) + " set " + set));
        }
        if (columns != null && columns.length == colNum) {
            int eCount = 0;
            for (int i = 0; i < columns.length; ++i) {
                eCount += columns[i].size();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("MultiCol: eCount " + eCount + " setCount" + set.getEntryCount() + set.getPortletsCount()));
            }
            if (eCount != set.getEntryCount() + set.getPortletsCount()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"MultiCol: rebuilding columns ");
                }
                columns = ALCustomizeSetAction.buildColumns(set, colNum);
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"MultiCol: rebuilding columns ");
            }
            columns = ALCustomizeSetAction.buildColumns(set, colNum);
        }
        customizationState.setAttribute("customize-columns", (Object)columns);
        context.put("portlets", (Object)columns);
        HashMap<String, String> titles = new HashMap<String, String>();
        for (int col = 0; col < columns.length; ++col) {
            for (int row = 0; row < columns[col].size(); ++row) {
                IdentityElement identityElement = (IdentityElement)columns[col].get(row);
                MetaInfo metaInfo = identityElement.getMetaInfo();
                if (metaInfo != null && metaInfo.getTitle() != null) {
                    titles.put(identityElement.getId(), metaInfo.getTitle());
                    continue;
                }
                if (identityElement instanceof Entry) {
                    Entry entry = (Entry)identityElement;
                    PortletEntry pentry = (PortletEntry)Registry.getEntry((String)Registry.PORTLET, (String)entry.getParent());
                    if (pentry != null && pentry.getTitle() != null) {
                        titles.put(entry.getId(), pentry.getTitle());
                        continue;
                    }
                    titles.put(entry.getId(), entry.getParent());
                    continue;
                }
                if (identityElement instanceof Reference) {
                    titles.put(identityElement.getId(), Localization.getString((RunData)rundata, (String)"CUSTOMIZER_REF_DEFAULTTITLE"));
                    continue;
                }
                titles.put(identityElement.getId(), Localization.getString((RunData)rundata, (String)"CUSTOMIZER_NOTITLESET"));
            }
        }
        HashMap<String, String> descriptions = new HashMap<String, String>();
        for (int col = 0; col < columns.length; ++col) {
            for (int row = 0; row < columns[col].size(); ++row) {
                IdentityElement identityElement = (IdentityElement)columns[col].get(row);
                MetaInfo metaInfo = identityElement.getMetaInfo();
                if (metaInfo != null && metaInfo.getDescription() != null) {
                    descriptions.put(identityElement.getId(), metaInfo.getDescription());
                    continue;
                }
                if (!(identityElement instanceof Entry)) continue;
                Entry entry = (Entry)identityElement;
                PortletEntry pentry = (PortletEntry)Registry.getEntry((String)Registry.PORTLET, (String)entry.getParent());
                if (pentry != null && pentry.getDescription() != null) {
                    descriptions.put(entry.getId(), pentry.getDescription());
                    continue;
                }
                descriptions.put(entry.getId(), entry.getParent());
            }
        }
    }

    protected static List<?>[] buildColumns(Portlets set, int colNum) {
        int i;
        Iterator iterator = set.getEntriesIterator();
        int row = 0;
        int col = 0;
        int rowNum = 0;
        while (iterator.hasNext()) {
            IdentityElement identityElement = (IdentityElement)iterator.next();
            Layout layout = identityElement.getLayout();
            if (layout == null) continue;
            for (int p = 0; p < layout.getParameterCount(); ++p) {
                Parameter prop = layout.getParameter(p);
                try {
                    if (prop.getName().equals("row")) {
                        row = Integer.parseInt(prop.getValue());
                        if (row <= rowNum) continue;
                        rowNum = row;
                        continue;
                    }
                    if (!prop.getName().equals("column") || (col = Integer.parseInt(prop.getValue())) <= colNum) continue;
                    prop.setValue(String.valueOf(col % colNum));
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        int sCount = set.getEntryCount() + set.getPortletsCount();
        row = sCount / colNum + 1;
        if (row > rowNum) {
            rowNum = row;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Controller customize colNum: " + colNum + " rowNum: " + rowNum));
        }
        List[] table = new List[colNum];
        List<Object> filler = Collections.nCopies(rowNum + 1, null);
        for (int i2 = 0; i2 < colNum; ++i2) {
            table[i2] = new ArrayList();
            table[i2].addAll(filler);
        }
        ArrayList<IdentityElement> work = new ArrayList<IdentityElement>();
        for (i = 0; i < set.getEntryCount(); ++i) {
            ALCustomizeSetAction.addElement((IdentityElement)set.getEntry(i), table, work, colNum);
        }
        for (i = 0; i < set.getReferenceCount(); ++i) {
            ALCustomizeSetAction.addElement((IdentityElement)set.getReference(i), table, work, colNum);
        }
        Iterator i3 = work.iterator();
        for (row = 0; row < rowNum; ++row) {
            for (col = 0; i3.hasNext() && col < colNum; ++col) {
                if (table[col].get(row) != null) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Set portlet at col " + col + " row " + row));
                }
                table[col].set(row, i3.next());
            }
        }
        for (int j = 0; j < table.length; ++j) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Column " + j));
            }
            i3 = table[j].iterator();
            while (i3.hasNext()) {
                Object obj = i3.next();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Element " + obj));
                }
                if (obj != null) continue;
                i3.remove();
            }
        }
        return table;
    }

    protected static void addElement(IdentityElement element, List[] table, List<IdentityElement> work, int columnCount) {
        Layout layout = element.getLayout();
        int row = -1;
        int col = -1;
        if (layout != null) {
            try {
                for (int p = 0; p < layout.getParameterCount(); ++p) {
                    Parameter prop = layout.getParameter(p);
                    if (prop.getName().equals("row")) {
                        row = Integer.parseInt(prop.getValue());
                        continue;
                    }
                    if (!prop.getName().equals("column")) continue;
                    col = Integer.parseInt(prop.getValue());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Constraints col " + col + " row " + row));
        }
        if (row >= 0 && col >= 0 && col < columnCount) {
            table[col].set(row, element);
        } else {
            if (layout != null) {
                element.setLayout(null);
                layout = null;
            }
            work.add(element);
        }
    }
}

