/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.services.security;

import com.aimluck.eip.common.ALBaseUser;
import com.aimluck.eip.util.ALCommonUtils;
import java.security.Principal;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.servlet.ServletConfig;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.om.security.UserNamePrincipal;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.JetspeedUserManagement;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.rundata.JetspeedRunDataService;
import org.apache.jetspeed.services.security.CredentialExpiredException;
import org.apache.jetspeed.services.security.FailedLoginException;
import org.apache.jetspeed.services.security.JetspeedSecurityCache;
import org.apache.jetspeed.services.security.JetspeedSecurityException;
import org.apache.jetspeed.services.security.LoginException;
import org.apache.jetspeed.services.security.PortalAuthentication;
import org.apache.jetspeed.services.security.UnknownUserException;
import org.apache.turbine.om.security.User;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.resources.ResourceService;

public class ALEipAuthentication
extends TurbineBaseService
implements PortalAuthentication {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALEipAuthentication.class.getName());
    private JetspeedRunDataService runDataService = null;
    private static final String CONFIG_ANONYMOUS_USER = "user.anonymous";
    String anonymousUser = "anon";
    private static final String CACHING_ENABLE = "caching.enable";
    private boolean cachingEnable = true;
    private static final String CONFIG_PASSWORD_EXPIRATION_PERIOD = "password.expiration.period";
    private int expirationPeriod = 0;

    public JetspeedUser loginCellularUid(String username, String cellular_uid) throws UnknownUserException, JetspeedSecurityException {
        JetspeedUser user = JetspeedUserManagement.getUser((Principal)new UserNamePrincipal(username));
        ALBaseUser baseUser = (ALBaseUser)user;
        if (cellular_uid == null || cellular_uid.length() == 0 || baseUser == null || !cellular_uid.equals(baseUser.getCelluarUId())) {
            logger.error((Object)("Invalid cellular uid for user: " + username));
            throw new UnknownUserException("[ALEipAuthentication] Credential authentication failure");
        }
        return user;
    }

    public JetspeedUser login(String username, String password) throws LoginException {
        JetspeedRunData rundata;
        if (username.equals(this.anonymousUser)) {
            throw new LoginException("Anonymous user cannot login");
        }
        JetspeedUser user = null;
        username = JetspeedSecurity.convertUserName((String)username);
        if ((password = JetspeedSecurity.convertPassword((String)password)).startsWith("cellularuid_")) {
            String cellularUid = password.substring("cellularuid_".length(), password.length());
            try {
                user = this.loginCellularUid(username, cellularUid);
            }
            catch (UnknownUserException e) {
                logger.warn((Object)("Unknown user attempted access: " + username), (Throwable)e);
                throw new FailedLoginException(e.toString());
            }
            catch (JetspeedSecurityException e) {
                logger.warn((Object)("User denied authentication: " + username), (Throwable)e);
                throw new LoginException(e.toString());
            }
        }
        try {
            user = JetspeedUserManagement.getUser((Principal)new UserNamePrincipal(username));
            password = JetspeedSecurity.encryptPassword((String)password);
        }
        catch (UnknownUserException e) {
            logger.warn((Object)("Unknown user attempted access: " + username), (Throwable)e);
            throw new FailedLoginException(e.toString());
        }
        catch (JetspeedSecurityException e) {
            logger.warn((Object)("User denied authentication: " + username), (Throwable)e);
            throw new LoginException(e.toString());
        }
        if (user == null || !user.getPassword().equals(password)) {
            logger.error((Object)("Invalid password for user: " + username));
            throw new FailedLoginException("Credential authentication failure");
        }
        if ("T".equals(user.getDisabled())) {
            logger.error((Object)("User deleted : " + username));
            throw new FailedLoginException("T");
        }
        if ("N".equals(user.getDisabled())) {
            logger.error((Object)("User disabled : " + username));
            throw new FailedLoginException("N");
        }
        if (this.expirationPeriod > 0) {
            Date passwordLastChangedDate = user.getPasswordChanged();
            Date passwordExpireDate = null;
            if (passwordLastChangedDate != null) {
                GregorianCalendar gcal = (GregorianCalendar)GregorianCalendar.getInstance();
                gcal.setTime(passwordLastChangedDate);
                gcal.add(5, this.expirationPeriod);
                passwordExpireDate = gcal.getTime();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("TurbineAuthentication: password last changed = " + passwordLastChangedDate.toString() + ", password expires = " + passwordExpireDate.toString()));
                }
            }
            if (passwordExpireDate == null || new Date().getTime() > passwordExpireDate.getTime()) {
                throw new CredentialExpiredException("Password expired");
            }
        }
        if ((rundata = this.getRunData()) != null) {
            rundata.getSession().invalidate();
            rundata.setSession(rundata.getRequest().getSession(true));
        }
        user.setHasLoggedIn(Boolean.TRUE);
        try {
            user.updateLastLogin();
            this.putUserIntoContext(user);
            if (this.cachingEnable) {
                JetspeedSecurityCache.load((String)username);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to update last login ", (Throwable)e);
            this.putUserIntoContext(JetspeedSecurity.getAnonymousUser());
            throw new LoginException("Failed to update last login ", (Throwable)e);
        }
        if (rundata != null) {
            rundata.getUser().setTemp("secid", (Object)ALCommonUtils.getSecureRandomString());
        }
        return user;
    }

    public JetspeedUser getAnonymousUser() throws LoginException {
        JetspeedUser user = null;
        try {
            user = JetspeedUserManagement.getUser((Principal)new UserNamePrincipal(this.anonymousUser));
            user.setHasLoggedIn(Boolean.FALSE);
            this.putUserIntoContext(user);
            if (this.cachingEnable) {
                JetspeedSecurityCache.load((String)user.getUserName());
            }
        }
        catch (JetspeedSecurityException e) {
            logger.error((Object)"Failed to get anonymous user: ", (Throwable)e);
            throw new LoginException("Failed to get anonymous user: ", (Throwable)e);
        }
        return user;
    }

    public void logout() throws LoginException {
        try {
            this.getAnonymousUser();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public synchronized void init(ServletConfig conf) throws InitializationException {
        if (this.getInit()) {
            return;
        }
        super.init(conf);
        ResourceService serviceConf = ((TurbineServices)TurbineServices.getInstance()).getResources("JetspeedSecurity");
        this.anonymousUser = serviceConf.getString(CONFIG_ANONYMOUS_USER, this.anonymousUser);
        this.cachingEnable = serviceConf.getBoolean(CACHING_ENABLE, this.cachingEnable);
        this.expirationPeriod = serviceConf.getInt(CONFIG_PASSWORD_EXPIRATION_PERIOD, 0);
        this.runDataService = (JetspeedRunDataService)TurbineServices.getInstance().getService("RunDataService");
        this.setInit(true);
    }

    protected JetspeedRunData getRunData() {
        JetspeedRunData rundata = null;
        if (this.runDataService != null) {
            rundata = this.runDataService.getCurrentRunData();
        }
        return rundata;
    }

    protected JetspeedUser getUserFromContext() {
        JetspeedRunData rundata = this.getRunData();
        JetspeedUser user = null;
        if (rundata != null) {
            user = (JetspeedUser)rundata.getUser();
        }
        return user;
    }

    protected JetspeedRunData putUserIntoContext(JetspeedUser user) {
        JetspeedRunData rundata = this.getRunData();
        if (rundata != null) {
            rundata.setUser((User)user);
            rundata.save();
        }
        return rundata;
    }
}

