/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.services.security;

import com.aimluck.eip.http.HttpServletRequestLocator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import org.apache.jetspeed.om.security.Group;
import org.apache.jetspeed.om.security.Permission;
import org.apache.jetspeed.om.security.Role;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.security.CachedAcl;
import org.apache.jetspeed.services.security.JetspeedSecurityException;
import org.apache.jetspeed.services.security.SecurityCacheService;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;

public class ALSecurityCache
extends TurbineBaseService
implements SecurityCacheService {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALSecurityCache.class.getName());
    private static String ACLS_KEY = "com.aimluck.eip.services.security.ALSecurityCache.acls";
    private static String PERMS_KEY = "com.aimluck.eip.services.security.ALSecurityCache.perms";

    protected static SecurityCacheService getService() {
        return (SecurityCacheService)TurbineServices.getInstance().getService("SecurityCache");
    }

    public void load(String username) throws JetspeedSecurityException {
        Map<String, CachedAcl> acls = this.getAclsFromRequest();
        Map<String, Map<String, Permission>> perms = this.getPermissionsFromRequest();
        CachedAcl acl = new CachedAcl(username);
        acl.setRoles(JetspeedSecurity.getRoles((String)username));
        if (acls == null) {
            acls = new HashMap<String, CachedAcl>();
        }
        acls.put(username, acl);
        this.saveAclsToRequest(acls);
        if (perms != null) {
            this.loadRolePermissions();
        }
    }

    public void unload(String username) {
        Map<String, CachedAcl> acls = this.getAclsFromRequest();
        if (acls != null) {
            acls.remove(username);
            this.saveAclsToRequest(acls);
        }
    }

    public Role getRole(String username, String roleName) {
        Map<String, CachedAcl> acls = this.getAclsFromRequest();
        if (acls != null) {
            CachedAcl acl = acls.get(username);
            if (acl == null) {
                return null;
            }
            return acl.getRole(roleName);
        }
        return null;
    }

    public Role getRole(String username, String roleName, String groupName) {
        Map<String, CachedAcl> acls = this.getAclsFromRequest();
        if (acls != null) {
            CachedAcl acl = acls.get(username);
            if (acl == null) {
                return null;
            }
            return acl.getRole(roleName, groupName);
        }
        return null;
    }

    public void addRole(Role role) {
        Map<String, Map<String, Permission>> perms = this.getPermissionsFromRequest();
        if (perms != null) {
            if (!perms.containsKey(role.getName())) {
                perms.put(role.getName(), new HashMap());
            }
            this.savePermissionsToRequest(perms);
        }
    }

    public void addRole(String username, Role role) {
        CachedAcl acl;
        Map<String, CachedAcl> acls = this.getAclsFromRequest();
        Map<String, Map<String, Permission>> perms = this.getPermissionsFromRequest();
        if (acls != null && (acl = acls.get(username)) != null) {
            acl.addRole(role);
            acls.put(username, acl);
            this.saveAclsToRequest(acls);
        }
        if (perms != null) {
            if (!perms.containsKey(role.getName())) {
                perms.put(role.getName(), new HashMap());
            }
            this.savePermissionsToRequest(perms);
        }
    }

    public void addRole(String username, Role role, Group group) {
        CachedAcl acl;
        Map<String, CachedAcl> acls = this.getAclsFromRequest();
        Map<String, Map<String, Permission>> perms = this.getPermissionsFromRequest();
        if (acls != null && (acl = acls.get(username)) != null) {
            acl.addRole(role, group);
            acls.put(username, acl);
            this.saveAclsToRequest(acls);
        }
        if (perms != null) {
            if (!perms.containsKey(role.getName())) {
                perms.put(role.getName(), new HashMap());
            }
            this.savePermissionsToRequest(perms);
        }
    }

    public boolean hasRole(String username, String roleName) {
        return this.hasRole(username, roleName, "Jetspeed");
    }

    public boolean hasRole(String username, String roleName, String groupName) {
        CachedAcl acl;
        Map<String, CachedAcl> acls = this.getAclsFromRequest();
        if (acls != null && (acl = acls.get(username)) != null) {
            return acl.hasRole(roleName, groupName);
        }
        return false;
    }

    public void removeRole(String username, String roleName) {
        this.removeRole(username, roleName, "Jetspeed");
    }

    public void removeRole(String username, String roleName, String groupName) {
        CachedAcl acl;
        Map<String, CachedAcl> acls = this.getAclsFromRequest();
        Map<String, Map<String, Permission>> perms = this.getPermissionsFromRequest();
        if (acls != null && (acl = acls.get(username)) != null) {
            acl.removeRole(roleName, groupName);
            acls.put(username, acl);
            this.saveAclsToRequest(acls);
        }
        if (perms != null) {
            perms.remove(roleName);
            this.savePermissionsToRequest(perms);
        }
    }

    public CachedAcl getAcl(String username) {
        Map<String, CachedAcl> acls = this.getAclsFromRequest();
        if (acls != null) {
            return acls.get(username);
        }
        return null;
    }

    public Iterator<?> getRoles(String username) {
        CachedAcl acl;
        Map<String, CachedAcl> acls = this.getAclsFromRequest();
        if (acls != null && (acl = acls.get(username)) != null) {
            return acl.getRoles();
        }
        return null;
    }

    public Permission getPermission(String roleName, String permissionName) {
        Map<String, Permission> map;
        Map<String, Map<String, Permission>> perms = this.getPermissionsFromRequest();
        if (perms != null && (map = perms.get(roleName)) != null) {
            return map.get(permissionName);
        }
        return null;
    }

    public void addPermission(String roleName, Permission permission) {
        Map<String, Permission> map;
        Map<String, Map<String, Permission>> perms = this.getPermissionsFromRequest();
        if (perms != null && (map = perms.get(roleName)) != null) {
            map.put(permission.getName(), permission);
            perms.put(roleName, map);
            this.savePermissionsToRequest(perms);
        }
    }

    public boolean hasPermission(String roleName, String permissionName) {
        Map<String, Permission> map;
        Map<String, Map<String, Permission>> perms = this.getPermissionsFromRequest();
        if (perms != null && (map = perms.get(roleName)) != null) {
            return map.containsKey(permissionName);
        }
        return false;
    }

    public void removePermission(String roleName, String permissionName) {
        Map<String, Permission> map;
        Map<String, Map<String, Permission>> perms = this.getPermissionsFromRequest();
        if (perms != null && (map = perms.get(roleName)) != null) {
            map.remove(permissionName);
            perms.put(roleName, map);
            this.savePermissionsToRequest(perms);
        }
    }

    public Iterator<?> getPermissions(String roleName) {
        Map<String, Permission> map;
        Map<String, Map<String, Permission>> perms = this.getPermissionsFromRequest();
        if (perms != null && (map = perms.get(roleName)) != null) {
            return map.values().iterator();
        }
        return null;
    }

    public void removeAllRoles(String rolename) {
        Map<String, CachedAcl> acls = this.getAclsFromRequest();
        Map<String, Map<String, Permission>> perms = this.getPermissionsFromRequest();
        if (acls != null) {
            for (CachedAcl acl : acls.values()) {
                acl.removeRole(rolename);
            }
            this.saveAclsToRequest(acls);
        }
        if (perms != null) {
            perms.remove(rolename);
            this.savePermissionsToRequest(perms);
        }
    }

    public void removeAllPermissions(String permissionName) {
        Map<String, Map<String, Permission>> perms = this.getPermissionsFromRequest();
        if (perms != null) {
            for (Map<String, Permission> map : perms.values()) {
                map.remove(permissionName);
            }
            this.savePermissionsToRequest(perms);
        }
    }

    public void loadRolePermissions() {
        Map<String, Map<String, Permission>> perms = this.getPermissionsFromRequest();
        try {
            if (perms != null) {
                Iterator roles = JetspeedSecurity.getRoles();
                while (roles.hasNext()) {
                    Role role = (Role)roles.next();
                    HashMap<String, Permission> map = new HashMap<String, Permission>();
                    Iterator prms = JetspeedSecurity.getPermissions((String)role.getName());
                    while (prms.hasNext()) {
                        Permission perm = (Permission)prms.next();
                        map.put(perm.getName(), perm);
                    }
                    perms.put(role.getName(), map);
                }
                this.savePermissionsToRequest(perms);
            }
        }
        catch (JetspeedSecurityException e) {
            logger.error((Object)"ALSecurityCache.loadRolePermissions", (Throwable)e);
        }
    }

    protected Map<String, CachedAcl> getAclsFromRequest() {
        HttpServletRequest request = HttpServletRequestLocator.get();
        if (request != null) {
            Map cache = null;
            try {
                cache = (Map)request.getAttribute(ACLS_KEY);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return cache;
        }
        return null;
    }

    protected void saveAclsToRequest(Map<String, CachedAcl> map) {
        HttpServletRequest request = HttpServletRequestLocator.get();
        if (request != null) {
            request.setAttribute(ACLS_KEY, map);
        }
    }

    protected Map<String, Map<String, Permission>> getPermissionsFromRequest() {
        HttpServletRequest request = HttpServletRequestLocator.get();
        if (request != null) {
            Map cache = null;
            try {
                cache = (Map)request.getAttribute(PERMS_KEY);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return cache;
        }
        return null;
    }

    protected void savePermissionsToRequest(Map<String, Map<String, Permission>> map) {
        HttpServletRequest request = HttpServletRequestLocator.get();
        if (request != null) {
            request.setAttribute(PERMS_KEY, map);
        }
    }

    public synchronized void init(ServletConfig conf) throws InitializationException {
        if (this.getInit()) {
            return;
        }
        super.init(conf);
        this.setInit(true);
    }
}

