/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.services.social.gadgets;

import com.aimluck.eip.services.social.ALContainerConfigService;
import com.aimluck.eip.services.social.ALSocialApplicationHandler;
import com.aimluck.eip.services.social.gadgets.AipoBlobCrypterSecurityToken;
import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.shindig.common.crypto.BasicBlobCrypter;
import org.apache.shindig.common.crypto.BlobCrypter;
import org.apache.shindig.common.util.Base32;
import org.apache.shindig.common.util.CharsetUtil;
import org.apache.turbine.util.RunData;

public class ALGadgetContext {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALGadgetContext.class.getName());
    private final String SECURITY_TOKEN_KEY = "/WEB-INF/conf/securityTokenKey.txt";
    private final String viewer;
    private final String appId;
    private String appUrl;
    private String container = "default";
    private String domain = "shindig";
    private long moduleId = 0L;
    private String activeUrl;
    private final RunData runData;

    public ALGadgetContext(RunData runData, String viewer, String appId, String appUrl, long moduleId) {
        this.runData = runData;
        this.viewer = viewer;
        this.appId = appId;
        this.appUrl = appUrl;
        this.moduleId = moduleId;
        HttpServletRequest request = ((JetspeedRunData)runData).getRequest();
        this.activeUrl = request.getRequestURL().toString();
    }

    public ALGadgetContext(RunData runData, String viewer, String appId, String appUrl, long moduleId, String activeUrl) {
        this.runData = runData;
        this.viewer = viewer;
        this.appId = appId;
        this.appUrl = appUrl;
        this.moduleId = moduleId;
        this.activeUrl = activeUrl;
    }

    public String getSecureToken() {
        try {
            AipoBlobCrypterSecurityToken token = new AipoBlobCrypterSecurityToken(this.loadCrypterFromFile(this.runData), this.container, this.domain);
            token.setOwnerId(this.viewer);
            token.setViewerId(this.viewer);
            token.setAppUrl(this.appUrl);
            token.setAppId(this.appId);
            token.setModuleId(this.moduleId);
            token.setActiveUrl(this.activeUrl);
            return token.encrypt();
        }
        catch (Exception ex) {
            logger.error((Object)"ALGadgetContext.getSecureToken", (Throwable)ex);
            return "";
        }
    }

    public String getServerBase() {
        HttpServletRequest request = ((JetspeedRunData)this.runData).getRequest();
        StringBuilder builder = new StringBuilder();
        String scheme = request.getScheme();
        String serverName = request.getServerName();
        int serverPort = request.getServerPort();
        builder.append(scheme).append("://");
        if (this.isLockedDomainRequired()) {
            byte[] sha1 = DigestUtils.sha((String)this.appUrl);
            String hash = new String(Base32.encodeBase32((byte[])sha1));
            builder.append(hash).append(this.getLockedDomainSuffix());
        } else {
            builder.append(serverName);
            if (serverPort != 80 || serverPort != 443) {
                builder.append(":").append(serverPort);
            }
        }
        String containerPath = JetspeedResources.getString((String)"aipo.container.path");
        return builder.append(containerPath == null ? "" : containerPath).append("/gadgets/").toString();
    }

    protected boolean isLockedDomainRequired() {
        String config = ALContainerConfigService.get(ALSocialApplicationHandler.Property.LOCKED_DOMAIN_REQUIRED);
        return "true".equalsIgnoreCase(config);
    }

    protected String getLockedDomainSuffix() {
        String config = ALContainerConfigService.get(ALSocialApplicationHandler.Property.LOCKED_DOMAIN_SUFFIX);
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BlobCrypter loadCrypterFromFile(RunData rundata) throws IOException {
        BufferedReader reader = null;
        byte[] keyBytes = null;
        try {
            ServletContext servletContext = ((JetspeedRunData)rundata).getServletContext();
            InputStream resourceAsStream = servletContext.getResourceAsStream("/WEB-INF/conf/securityTokenKey.txt");
            reader = new BufferedReader(new InputStreamReader(resourceAsStream, Charsets.UTF_8));
            String line = reader.readLine();
            if (line == null) {
                throw new IOException("Unexpectedly empty keyfile: /WEB-INF/conf/securityTokenKey.txt");
            }
            line = line.trim();
            keyBytes = CharsetUtil.getUtf8Bytes((String)line);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {}
        }
        return new BasicBlobCrypter(keyBytes);
    }

    public String getContainer() {
        return this.container;
    }

    public void setContainer(String container) {
        this.container = container;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public long getModuleId() {
        return this.moduleId;
    }

    public void setModuleId(long moduleId) {
        this.moduleId = moduleId;
    }

    public String getAppUrl() {
        return this.appUrl;
    }

    public void setAppUrl(String appUrl) {
        this.appUrl = appUrl;
    }

    public String getActiveUrl() {
        return this.activeUrl;
    }

    public void setActiveUrl(String activeUrl) {
        this.activeUrl = activeUrl;
    }
}

