/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.services.storage;

import com.aimluck.eip.services.storage.ALStorageService;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Calendar;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;

public abstract class ALStorageHandler {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALStorageHandler.class.getName());
    public static final String FOLDER_TMP_FOR_ATTACHMENT_FILES = JetspeedResources.getString((String)"aipo.tmp.fileupload.attachment.directory", (String)"");

    public abstract void createNewTmpFile(InputStream var1, int var2, String var3, String var4, String var5);

    public abstract void createNewFile(InputStream var1, String var2, String var3);

    public long getTmpFolderSize(int uid, String dir) {
        return this.getFolderSize(FOLDER_TMP_FOR_ATTACHMENT_FILES, uid + ALStorageService.separator() + dir);
    }

    public boolean copyTmpFile(int uid, String srcDir, String srcFileName, String destRootPath, String destDir, String destFileName) {
        return this.copyFile(FOLDER_TMP_FOR_ATTACHMENT_FILES, uid + ALStorageService.separator() + srcDir, srcFileName, destRootPath, destDir, destFileName);
    }

    public boolean deleteTmpFolder(int uid, String dir) {
        return this.deleteFolder(FOLDER_TMP_FOR_ATTACHMENT_FILES, uid + ALStorageService.separator() + dir);
    }

    public InputStream getTmpFile(int uid, String folderName, String finename) throws FileNotFoundException {
        return this.getFile(FOLDER_TMP_FOR_ATTACHMENT_FILES, uid + ALStorageService.separator() + folderName, finename);
    }

    public abstract boolean copyFile(String var1, String var2, String var3, String var4, String var5, String var6);

    public abstract long getFolderSize(String var1, String var2);

    public abstract long getFileSize(String var1, String var2, String var3);

    public abstract boolean deleteFolder(String var1, String var2);

    public abstract boolean deleteFile(String var1, String var2, String var3);

    public abstract boolean deleteFile(String var1);

    public abstract InputStream getFile(String var1, String var2, String var3) throws FileNotFoundException;

    public abstract InputStream getFile(String var1) throws FileNotFoundException;

    public abstract String getDocumentPath(String var1, String var2);

    public abstract String separator();

    public abstract void saveFile(InputStream var1, String var2, String var3);

    public abstract boolean deleteOldFolder(String var1, Calendar var2);

    public abstract void createNewFile(InputStream var1, String var2);
}

