/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.util;

import com.aimluck.eip.http.HttpServletRequestLocator;
import com.aimluck.eip.http.ServletContextLocator;
import com.aimluck.eip.services.config.ALConfigHandler;
import com.aimluck.eip.services.config.ALConfigService;
import javax.servlet.http.HttpServletRequest;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;

public class ALServletUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALServletUtils.class.getName());

    public static String getRequestBaseUrl() {
        HttpServletRequest request = HttpServletRequestLocator.get();
        String scheme = request.getScheme();
        int port = request.getServerPort();
        String serverName = request.getServerName();
        StringBuilder b = new StringBuilder(scheme);
        b.append("://").append(serverName);
        if (!("http".equals(scheme) && port == 80 || "https".equals(scheme) && port == 443)) {
            b.append(":").append(port);
        }
        return b.toString();
    }

    public static String getAccessUrl(String host, int port, boolean isGlobal) {
        String contextPath;
        String loginUrl = ALConfigService.get(ALConfigHandler.Property.EXTERNAL_LOGIN_URL);
        if (loginUrl != null && loginUrl.length() > 0) {
            return loginUrl;
        }
        if (host == null || "".equals(host)) {
            return "";
        }
        String scheme = isGlobal ? ALConfigService.get(ALConfigHandler.Property.ACCESS_GLOBAL_URL_PROTOCOL) : ALConfigService.get(ALConfigHandler.Property.ACCESS_LOCAL_URL_PROTOCOL);
        StringBuilder b = new StringBuilder(scheme);
        b.append("://").append(host);
        if (!("http".equals(scheme) && port == 80 || "https".equals(scheme) && port == 443)) {
            b.append(":").append(port);
        }
        if ((contextPath = ServletContextLocator.get().getContextPath()).equals("/")) {
            contextPath = "";
        }
        b.append(contextPath);
        b.append("/");
        return b.toString();
    }
}

