/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder;

import java.util.Enumeration;
import org.exolab.castor.builder.ClassInfo;
import org.exolab.castor.builder.ClassInfoResolver;
import org.exolab.castor.builder.CollectionInfo;
import org.exolab.castor.builder.FactoryState;
import org.exolab.castor.builder.FieldInfo;
import org.exolab.castor.builder.FieldInfoFactory;
import org.exolab.castor.builder.GroupInfo;
import org.exolab.castor.builder.MemberFactory;
import org.exolab.castor.builder.SGStateInfo;
import org.exolab.castor.builder.SGTypes;
import org.exolab.castor.builder.SourceGenerator;
import org.exolab.castor.builder.TypeConversion;
import org.exolab.castor.builder.types.XSClass;
import org.exolab.castor.builder.types.XSString;
import org.exolab.castor.builder.types.XSType;
import org.exolab.castor.xml.JavaNaming;
import org.exolab.castor.xml.schema.Annotated;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ContentModelGroup;
import org.exolab.castor.xml.schema.ContentType;
import org.exolab.castor.xml.schema.Documentation;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.Order;
import org.exolab.castor.xml.schema.Particle;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.SimpleTypesFactory;
import org.exolab.castor.xml.schema.Structure;
import org.exolab.castor.xml.schema.Wildcard;
import org.exolab.castor.xml.schema.XMLType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JConstructor;
import org.exolab.javasource.JDocComment;
import org.exolab.javasource.JDocDescriptor;
import org.exolab.javasource.JField;
import org.exolab.javasource.JMethod;
import org.exolab.javasource.JModifiers;
import org.exolab.javasource.JParameter;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public class SourceFactory {
    private static final short BASE_TYPE_ENUMERATION = 0;
    private static final short OBJECT_TYPE_ENUMERATION = 1;
    private FieldInfoFactory infoFactory = null;
    private MemberFactory memberFactory = null;
    private short enumerationType = 1;
    private boolean _createMarshalMethods = true;
    private boolean _testable = false;

    public SourceFactory() {
        this(null);
    }

    public SourceFactory(FieldInfoFactory fieldInfoFactory) {
        this.infoFactory = fieldInfoFactory == null ? new FieldInfoFactory() : fieldInfoFactory;
        this.memberFactory = new MemberFactory(fieldInfoFactory);
    }

    public static void createEqualsMethod(JClass jClass) {
        if (jClass == null) {
            throw new IllegalArgumentException("JClass must not be null");
        }
        JField[] jFieldArray = jClass.getFields();
        JMethod jMethod = new JMethod(JType.Boolean, "equals");
        jMethod.setComment("Override the java.lang.Object.equals method");
        jMethod.setComment("Note: hashCode() has not been overriden");
        jMethod.addParameter(new JParameter(SGTypes.Object, "obj"));
        jClass.addMethod(jMethod);
        JSourceCode jSourceCode = jMethod.getSourceCode();
        jSourceCode.add("if ( this == obj )");
        jSourceCode.indent();
        jSourceCode.add("return true;");
        jSourceCode.unindent();
        jSourceCode.add("");
        jSourceCode.add("if (obj instanceof ");
        jSourceCode.append(jClass.getName(true));
        jSourceCode.append(") {");
        jSourceCode.add("");
        jSourceCode.indent();
        jSourceCode.add(jClass.getName(true));
        jSourceCode.append(" temp = (");
        jSourceCode.append(jClass.getName(true));
        jSourceCode.append(")obj;");
        int n = 0;
        while (n < jFieldArray.length) {
            JField jField = jFieldArray[n];
            String string = jField.getName();
            if (jField.getType().isPrimitive()) {
                jSourceCode.add("if (this.");
                jSourceCode.append(string);
                jSourceCode.append(" != temp.");
                jSourceCode.append(string);
                jSourceCode.append(")");
            } else {
                jSourceCode.add("if ( (this.");
                jSourceCode.append(string);
                jSourceCode.append(" != null) &&");
                jSourceCode.append("!(this.");
                jSourceCode.append(string);
                jSourceCode.append(".equals(temp.");
                jSourceCode.append(string);
                jSourceCode.append("))) ");
            }
            jSourceCode.indent();
            jSourceCode.add("return false;");
            jSourceCode.unindent();
            ++n;
        }
        jSourceCode.add("return true;");
        jSourceCode.unindent();
        jSourceCode.add("}");
        jSourceCode.add("return false;");
    }

    private void createMarshalMethods(JClass jClass) {
        this.createMarshalMethods(jClass, false);
    }

    private void createMarshalMethods(JClass jClass, boolean bl) {
        Object object;
        JMethod jMethod = new JMethod(null, "marshal");
        jMethod.addException(SGTypes.MarshalException);
        jMethod.addException(SGTypes.ValidationException);
        jMethod.addParameter(new JParameter(SGTypes.Writer, "out"));
        jClass.addMethod(jMethod);
        if (bl) {
            jMethod.getModifiers().setAbstract(true);
        } else {
            object = jMethod.getSourceCode();
            ((JSourceCode)object).add("");
            ((JSourceCode)object).add("Marshaller.marshal(this, out);");
        }
        jMethod = new JMethod(null, "marshal");
        object = new JClass("org.xml.sax.DocumentHandler");
        jMethod.addException(SGTypes.MarshalException);
        jMethod.addException(SGTypes.ValidationException);
        jMethod.addParameter(new JParameter((JType)object, "handler"));
        jClass.addMethod(jMethod);
        if (bl) {
            jMethod.getModifiers().setAbstract(true);
        } else {
            JSourceCode jSourceCode = jMethod.getSourceCode();
            jSourceCode = jMethod.getSourceCode();
            jSourceCode.add("");
            jSourceCode.add("Marshaller.marshal(this, handler);");
        }
    }

    private void createPropertyChangeMethods(JClass jClass) {
        jClass.addImport("java.beans.PropertyChangeEvent");
        jClass.addImport("java.beans.PropertyChangeListener");
        String string = "propertyChangeListeners";
        JField jField = new JField(SGTypes.Vector, string);
        jField.getModifiers().makePrivate();
        jClass.addField(jField);
        JSourceCode jSourceCode = jClass.getConstructor(0).getSourceCode();
        jSourceCode.add("propertyChangeListeners = new Vector();");
        JMethod jMethod = new JMethod(null, "notifyPropertyChangeListeners");
        jMethod.getModifiers().makeProtected();
        String string2 = "Notifies all registered PropertyChangeListeners when a bound property's value changes.";
        JDocComment jDocComment = jMethod.getJDocComment();
        JDocDescriptor jDocDescriptor = null;
        jDocComment.appendComment(string2);
        jMethod.addParameter(new JParameter(SGTypes.String, "fieldName"));
        jDocDescriptor = jDocComment.getParamDescriptor("fieldName");
        jDocDescriptor.setDescription("the name of the property that has changed.");
        jMethod.addParameter(new JParameter(SGTypes.Object, "oldValue"));
        jDocDescriptor = jDocComment.getParamDescriptor("oldValue");
        jDocDescriptor.setDescription("the old value of the property.");
        jMethod.addParameter(new JParameter(SGTypes.Object, "newValue"));
        jDocDescriptor = jDocComment.getParamDescriptor("newValue");
        jDocDescriptor.setDescription("the new value of the property.");
        jClass.addMethod(jMethod);
        jSourceCode = jMethod.getSourceCode();
        jSourceCode.add("java.beans.PropertyChangeEvent event = new ");
        jSourceCode.append("java.beans.PropertyChangeEvent");
        jSourceCode.append("(this, fieldName, oldValue, newValue);");
        jSourceCode.add("");
        jSourceCode.add("for (int i = 0; i < ");
        jSourceCode.append(string);
        jSourceCode.append(".size(); i++) {");
        jSourceCode.indent();
        jSourceCode.add("((java.beans.PropertyChangeListener) ");
        jSourceCode.append(string);
        jSourceCode.append(".elementAt(i)).");
        jSourceCode.append("propertyChange(event);");
        jSourceCode.unindent();
        jSourceCode.add("}");
        JClass jClass2 = new JClass("java.beans.PropertyChangeListener");
        jMethod = new JMethod(null, "addPropertyChangeListener");
        string2 = "Registers a PropertyChangeListener with this class.";
        jDocComment = jMethod.getJDocComment();
        jDocComment.appendComment(string2);
        jMethod.addParameter(new JParameter(jClass2, "pcl"));
        string2 = "The PropertyChangeListener to register.";
        jDocDescriptor = jDocComment.getParamDescriptor("pcl");
        jDocDescriptor.setDescription(string2);
        jClass.addMethod(jMethod);
        jSourceCode = jMethod.getSourceCode();
        jSourceCode.add(string);
        jSourceCode.append(".addElement(pcl);");
        jMethod = new JMethod(JType.Boolean, "removePropertyChangeListener");
        string2 = "Removes the given PropertyChangeListener from this classes list of ProperyChangeListeners.";
        jDocComment = jMethod.getJDocComment();
        jDocComment.appendComment(string2);
        jMethod.addParameter(new JParameter(jClass2, "pcl"));
        string2 = "The PropertyChangeListener to remove.";
        jDocDescriptor = jDocComment.getParamDescriptor("pcl");
        jDocDescriptor.setDescription(string2);
        string2 = "true if the given PropertyChangeListener was removed.";
        jDocComment.addDescriptor(JDocDescriptor.createReturnDesc(string2));
        jClass.addMethod(jMethod);
        jSourceCode = jMethod.getSourceCode();
        jSourceCode.add("return ");
        jSourceCode.append(string);
        jSourceCode.append(".removeElement(pcl);");
    }

    public JClass[] createSourceCode(ComplexType complexType, SGStateInfo sGStateInfo) {
        Object object;
        Object object2;
        if (complexType == null) {
            throw new IllegalArgumentException("null ComplexType");
        }
        if (!complexType.isTopLevel()) {
            throw new IllegalArgumentException("ComplexType is not top-level.");
        }
        if (sGStateInfo == null) {
            throw new IllegalArgumentException("SGStateInfo cannot be null.");
        }
        JClass[] jClassArray = null;
        String string = JavaNaming.toJavaClassName(complexType.getName());
        string = this.resolveClassName(string, sGStateInfo.packageName);
        boolean bl = false;
        int n = complexType.getMaxOccurs();
        if (n < 0 || n > 1) {
            bl = true;
            string = String.valueOf(string) + "Item";
            jClassArray = new JClass[2];
        } else {
            jClassArray = new JClass[1];
        }
        FactoryState factoryState = new FactoryState(string, sGStateInfo);
        ClassInfo classInfo = factoryState.classInfo;
        JClass jClass = factoryState.jClass;
        factoryState.markAsProcessed(complexType);
        this.initialize(jClass);
        String string2 = SourceGenerator.getProperty("org.exolab.castor.builder.superclass", null);
        if (string2 != null) {
            jClass.setSuperClass(string2);
        }
        classInfo.setNodeName(complexType.getName());
        Schema schema = complexType.getSchema();
        classInfo.setNamespaceURI(schema.getTargetNamespace());
        this.processComplexType(complexType, factoryState);
        if (complexType.getParticleCount() == 1 && ((Structure)(object2 = complexType.getParticle(0))).getStructureType() == 9 && ((Group)(object = (Group)object2)).getOrder() == Order.choice) {
            classInfo.getGroupInfo().setAsChoice();
        }
        if (bl) {
            sGStateInfo.bindReference(jClass, classInfo);
            jClassArray[1] = jClass;
            object2 = String.valueOf(complexType.getName()) + "Item";
            object2 = JavaNaming.toJavaMemberName((String)object2, false);
            object = this.infoFactory.createCollection(new XSClass(jClass), "_items", (String)object2);
            ((FieldInfo)object).setContainer(true);
            string = string.substring(0, string.length() - 4);
            factoryState = new FactoryState(string, sGStateInfo);
            classInfo = factoryState.classInfo;
            jClass = factoryState.jClass;
            this.initialize(jClass);
            classInfo.addFieldInfo((FieldInfo)object);
            ((FieldInfo)object).createJavaField(jClass);
            ((FieldInfo)object).createAccessMethods(jClass);
            ((FieldInfo)object).generateInitializerCode(jClass.getConstructor(0).getSourceCode());
            if (string2 != null) {
                jClass.setSuperClass(string2);
            }
            classInfo.setNodeName(complexType.getName());
            classInfo.setNamespaceURI(schema.getTargetNamespace());
            classInfo.setContainer(true);
        }
        if ((object2 = this.processAnnotations(complexType)) != null) {
            jClass.getJDocComment().setComment((String)object2);
        }
        if (SourceGenerator.mappingSchemaElement2Java()) {
            jClass.getModifiers().setAbstract(true);
        }
        if (this._createMarshalMethods) {
            jClass.addImport("java.io.Writer");
            jClass.addImport("java.io.Reader");
            boolean bl2 = jClass.getModifiers().isAbstract();
            this.createValidateMethods(jClass);
            this.createMarshalMethods(jClass, bl2);
            if (!bl2) {
                this.createUnmarshalMethods(jClass);
            }
        }
        if (factoryState.hasBoundProperties()) {
            this.createPropertyChangeMethods(jClass);
        }
        sGStateInfo.bindReference(jClass, classInfo);
        sGStateInfo.bindReference(complexType, classInfo);
        jClassArray[0] = jClass;
        return jClassArray;
    }

    public JClass[] createSourceCode(ElementDecl elementDecl, SGStateInfo sGStateInfo) {
        XMLType xMLType;
        int n;
        if (elementDecl == null) {
            throw new IllegalStateException("ElementDecl may not be null.");
        }
        if (sGStateInfo == null) {
            throw new IllegalStateException("SGStateInfo may not be null.");
        }
        FactoryState factoryState = null;
        JClass[] jClassArray = new JClass[1];
        boolean bl = false;
        String string = elementDecl.getName();
        String string2 = JavaNaming.toJavaClassName(string);
        XMLType xMLType2 = elementDecl.getType();
        if (xMLType2 instanceof ComplexType && xMLType2.getName() == null && ((n = ((ComplexType)xMLType2).getMaxOccurs()) < 0 || n > 1)) {
            bl = true;
            string2 = String.valueOf(string2) + "Item";
            jClassArray = new JClass[2];
        }
        string2 = this.resolveClassName(string2, sGStateInfo.packageName);
        factoryState = new FactoryState(string2, sGStateInfo);
        ElementDecl elementDecl2 = elementDecl;
        while (elementDecl2.isReference()) {
            elementDecl2 = elementDecl2.getReference();
        }
        factoryState.markAsProcessed(elementDecl2);
        ClassInfo classInfo = factoryState.classInfo;
        JClass jClass = factoryState.jClass;
        this.initialize(jClass);
        String string3 = SourceGenerator.getProperty("org.exolab.castor.builder.superclass", null);
        if (string3 != null) {
            jClass.setSuperClass(string3);
        }
        classInfo.setNodeName(elementDecl.getName());
        Schema schema = elementDecl.getSchema();
        classInfo.setNamespaceURI(schema.getTargetNamespace());
        String string4 = this.processAnnotations(elementDecl);
        if (string4 != null) {
            jClass.getJDocComment().setComment(string4);
        }
        boolean bl2 = false;
        if (xMLType2 == null) {
            classInfo.setSchemaType(new XSClass(factoryState.jClass));
        } else if (xMLType2.isComplexType()) {
            xMLType = (ComplexType)xMLType2;
            if (!((ComplexType)xMLType).isTopLevel()) {
                if (!factoryState.processed((ComplexType)xMLType)) {
                    this.processComplexType((ComplexType)xMLType, factoryState);
                }
                if (bl) {
                    sGStateInfo.bindReference(jClass, classInfo);
                    jClassArray[1] = jClass;
                    String string5 = String.valueOf(elementDecl.getName()) + "Item";
                    string5 = JavaNaming.toJavaMemberName(string5, false);
                    CollectionInfo collectionInfo = this.infoFactory.createCollection(new XSClass(jClass), "_items", string5);
                    collectionInfo.setContainer(true);
                    string2 = string2.substring(0, string2.length() - 4);
                    factoryState = new FactoryState(string2, sGStateInfo);
                    classInfo = factoryState.classInfo;
                    jClass = factoryState.jClass;
                    this.initialize(jClass);
                    classInfo.addFieldInfo(collectionInfo);
                    collectionInfo.createJavaField(jClass);
                    ((FieldInfo)collectionInfo).createAccessMethods(jClass);
                    ((FieldInfo)collectionInfo).generateInitializerCode(jClass.getConstructor(0).getSourceCode());
                    if (string3 != null) {
                        jClass.setSuperClass(string3);
                    }
                    classInfo.setNodeName(elementDecl.getName());
                    classInfo.setNamespaceURI(schema.getTargetNamespace());
                    classInfo.setContainer(true);
                }
                bl2 = factoryState.jClass.getSuperClass() != null;
            } else {
                String string6 = xMLType.getName();
                String string7 = JavaNaming.toJavaClassName(string6);
                string7 = this.resolveClassName(string7, sGStateInfo.packageName);
                jClass.setSuperClass(string7);
                bl2 = true;
            }
        } else {
            xMLType = (SimpleType)xMLType2;
            classInfo.setSchemaType(TypeConversion.convertType((SimpleType)xMLType));
            if (((SimpleType)xMLType).hasFacet("enumeration")) {
                this.createSourceCode((SimpleType)xMLType, sGStateInfo);
            }
        }
        jClass.addImport("java.io.Writer");
        jClass.addImport("java.io.Reader");
        if (this._createMarshalMethods) {
            this.createValidateMethods(jClass);
            this.createMarshalMethods(jClass);
            this.createUnmarshalMethods(jClass);
        }
        if (SourceGenerator.equalsMethod()) {
            SourceFactory.createEqualsMethod(jClass);
        }
        if (this._testable) {
            SourceFactory.createTestableMethods(jClass);
        }
        boolean bl3 = bl2;
        if (string3 != null) {
            bl3 = false;
        }
        if (factoryState.hasBoundProperties() && !bl3) {
            this.createPropertyChangeMethods(jClass);
        }
        sGStateInfo.bindReference(jClass, classInfo);
        sGStateInfo.bindReference(elementDecl, classInfo);
        jClassArray[0] = jClass;
        return jClassArray;
    }

    public JClass[] createSourceCode(Group group, SGStateInfo sGStateInfo) {
        String string;
        if (group == null) {
            throw new IllegalArgumentException("Group may not be null.");
        }
        if (sGStateInfo == null) {
            throw new IllegalArgumentException("SGStateInfo may not be null.");
        }
        String string2 = group.getName();
        if (string2 == null && (string2 = sGStateInfo.getGroupNaming().createClassName(group)) == null) {
            String string3 = "Unable to create name for group";
            throw new IllegalStateException(string3);
        }
        JClass[] jClassArray = null;
        String string4 = JavaNaming.toJavaClassName(string2);
        string4 = this.resolveClassName(string4, sGStateInfo.packageName);
        boolean bl = false;
        int n = group.getMaxOccurs();
        if (n < 0 || n > 1) {
            bl = true;
            string4 = String.valueOf(string4) + "Item";
            jClassArray = new JClass[2];
        } else {
            jClassArray = new JClass[1];
        }
        FactoryState factoryState = new FactoryState(string4, sGStateInfo);
        ClassInfo classInfo = factoryState.classInfo;
        JClass jClass = factoryState.jClass;
        factoryState.markAsProcessed(group);
        this.initialize(jClass);
        String string5 = SourceGenerator.getProperty("org.exolab.castor.builder.superclass", null);
        if (string5 != null) {
            jClass.setSuperClass(string5);
        }
        this.processContentModel(group, factoryState);
        Order order = group.getOrder();
        if (order == Order.choice) {
            classInfo.getGroupInfo().setAsChoice();
        } else if (order == Order.seq) {
            classInfo.getGroupInfo().setAsSequence();
        } else {
            classInfo.getGroupInfo().setAsAll();
        }
        if (bl) {
            if (factoryState.hasBoundProperties()) {
                this.createPropertyChangeMethods(jClass);
            }
            sGStateInfo.bindReference(jClass, classInfo);
            jClassArray[1] = jClass;
            string = String.valueOf(string2) + "Item";
            string = JavaNaming.toJavaMemberName(string, false);
            CollectionInfo collectionInfo = this.infoFactory.createCollection(new XSClass(jClass), "_items", string);
            collectionInfo.setContainer(true);
            string4 = string4.substring(0, string4.length() - 4);
            factoryState = new FactoryState(string4, sGStateInfo);
            classInfo = factoryState.classInfo;
            jClass = factoryState.jClass;
            this.initialize(jClass);
            classInfo.addFieldInfo(collectionInfo);
            collectionInfo.createJavaField(jClass);
            ((FieldInfo)collectionInfo).createAccessMethods(jClass);
            ((FieldInfo)collectionInfo).generateInitializerCode(jClass.getConstructor(0).getSourceCode());
            if (string5 != null) {
                jClass.setSuperClass(string5);
            }
            classInfo.setNodeName(string2);
            classInfo.setContainer(true);
        }
        if ((string = this.processAnnotations(group)) != null) {
            jClass.getJDocComment().setComment(string);
        }
        if (this._createMarshalMethods) {
            jClass.addImport("java.io.Writer");
            jClass.addImport("java.io.Reader");
            boolean bl2 = jClass.getModifiers().isAbstract();
            this.createValidateMethods(jClass);
            this.createMarshalMethods(jClass, bl2);
            if (!bl2) {
                this.createUnmarshalMethods(jClass);
            }
        }
        if (factoryState.hasBoundProperties()) {
            this.createPropertyChangeMethods(jClass);
        }
        sGStateInfo.bindReference(jClass, classInfo);
        sGStateInfo.bindReference(group, classInfo);
        factoryState.classInfo.setSchemaType(new XSClass(factoryState.jClass, group.getName()));
        jClassArray[0] = jClass;
        return jClassArray;
    }

    public JClass createSourceCode(SimpleType simpleType, SGStateInfo sGStateInfo) {
        Object object;
        if (SimpleTypesFactory.isBuiltInType(simpleType.getTypeCode())) {
            String string = "You cannot construct a ClassInfo for a built-in SimpleType.";
            throw new IllegalArgumentException(string);
        }
        if (sGStateInfo == null) {
            throw new IllegalArgumentException("SGStateInfo cannot be null.");
        }
        boolean bl = false;
        String string = simpleType.getName();
        if (string == null) {
            object = simpleType.getParent();
            switch (((Structure)object).getStructureType()) {
                case 2: {
                    string = ((AttributeDecl)object).getName();
                    break;
                }
                case 7: {
                    string = ((ElementDecl)object).getName();
                    break;
                }
            }
            string = String.valueOf(string) + "Type";
        }
        object = JavaNaming.toJavaClassName(string);
        String string2 = sGStateInfo.packageName;
        if (simpleType.hasFacet("enumeration")) {
            bl = true;
            string2 = string2 != null && string2.length() > 0 ? String.valueOf(string2) + ".types" : "types";
        }
        object = this.resolveClassName((String)object, string2);
        FactoryState factoryState = new FactoryState((String)object, sGStateInfo);
        factoryState.packageName = string2;
        ClassInfo classInfo = factoryState.classInfo;
        JClass jClass = factoryState.jClass;
        this.initialize(jClass);
        Schema schema = simpleType.getSchema();
        classInfo.setNamespaceURI(schema.getTargetNamespace());
        classInfo.setNodeName(string);
        String string3 = this.processAnnotations(simpleType);
        if (string3 != null) {
            jClass.getJDocComment().setComment(string3);
        }
        XSClass xSClass = new XSClass(jClass, string);
        classInfo.setSchemaType(xSClass);
        if (bl) {
            xSClass.setAsEnumertated(true);
            this.processEnumeration(simpleType, factoryState);
        }
        if (factoryState.hasBoundProperties()) {
            this.createPropertyChangeMethods(jClass);
        }
        sGStateInfo.bindReference(jClass, classInfo);
        sGStateInfo.bindReference(simpleType, classInfo);
        return jClass;
    }

    public static void createTestableMethods(JClass jClass) {
        String string;
        Object object;
        if (jClass == null) {
            throw new IllegalArgumentException("JClass must not be null");
        }
        jClass.addInterface("org.exolab.castor.tests.framework.CastorTestable");
        jClass.addImport("org.exolab.castor.tests.framework.CastorTestable");
        jClass.addImport("org.exolab.castor.tests.framework.RandomHelper");
        JMethod jMethod = new JMethod(null, "randomizeFields");
        jMethod.addException(new JClass("InstantiationException"));
        jMethod.addException(new JClass("IllegalAccessException"));
        jMethod.setComment("implementation of org.exolab.castor.tests.framework.CastorTestable");
        jClass.addMethod(jMethod);
        JSourceCode jSourceCode = jMethod.getSourceCode();
        JField[] jFieldArray = jClass.getFields();
        int n = 0;
        while (n < jFieldArray.length) {
            JField jField = jFieldArray[n];
            object = jField.getType();
            string = null;
            String string2 = jField.getName();
            String string3 = "set" + JavaNaming.toJavaClassName(string2);
            String string4 = null;
            if (string2.indexOf("_has") == -1) {
                if (((JType)object).getName().equals("java.util.Vector") || ((JType)object).getName().equals("java.util.ArrayList")) {
                    int n2 = string2.lastIndexOf("List");
                    String string5 = string2;
                    if (n2 != -1) {
                        string5 = string5.substring(0, n2);
                    }
                    String string6 = JavaNaming.toJavaClassName(string5);
                    string6 = "get" + string6;
                    JMethod jMethod2 = jClass.getMethod(string6, 0);
                    string4 = jMethod2.getReturnType().getName();
                    jMethod2 = null;
                    string6 = null;
                    string5 = null;
                    jSourceCode.add(string2);
                    jSourceCode.append(" = RandomHelper.getRandom(");
                    jSourceCode.append(string2);
                    jSourceCode.append(", ");
                    jSourceCode.append(string4);
                    jSourceCode.append(".class);");
                } else if (((JType)object).isPrimitive()) {
                    jSourceCode.add(string3);
                    jSourceCode.append("(RandomHelper.getRandom(");
                    jSourceCode.append(string2);
                    jSourceCode.append("));");
                } else {
                    jSourceCode.add(string3);
                    jSourceCode.append("((");
                    jSourceCode.append(((JType)object).getName());
                    jSourceCode.append(")RandomHelper.getRandom(");
                    jSourceCode.append(string2);
                    jSourceCode.append(", ");
                    jSourceCode.append(((JType)object).getName());
                    jSourceCode.append(".class));");
                }
                jSourceCode.add("");
            }
            ++n;
        }
        jMethod = new JMethod(SGTypes.String, "dumpFields");
        jMethod.setComment("implementation of org.exolab.castor.tests.framework.CastorTestable");
        jClass.addMethod(jMethod);
        jSourceCode = jMethod.getSourceCode();
        jSourceCode.add("String result = \"DumpFields() for element: ");
        jSourceCode.append(jClass.getName());
        jSourceCode.append("\\n\";");
        int n3 = 0;
        while (n3 < jFieldArray.length) {
            object = jFieldArray[n3];
            string = ((JField)object).getName();
            if (((JField)object).getType().isPrimitive() || ((JField)object).getType().getName().equals("java.lang.String")) {
                jSourceCode.add("result += \"Field ");
                jSourceCode.append(string);
                jSourceCode.append(":\" +");
                jSourceCode.append(string);
                jSourceCode.append("+\"\\n\";");
            } else {
                jSourceCode.add("if ( (");
                jSourceCode.add(string);
                jSourceCode.add(" != null) && (");
                jSourceCode.add(string);
                jSourceCode.add(".getClass().isAssignableFrom(CastorTestable.class)))");
                jSourceCode.indent();
                jSourceCode.add("result += ((CastorTestable)");
                jSourceCode.append(string);
                jSourceCode.append(").dumpFields();");
                jSourceCode.unindent();
                jSourceCode.append("else result += \"Field ");
                jSourceCode.append(string);
                jSourceCode.append(":\" +");
                jSourceCode.append(string);
                jSourceCode.append("+\"\\n\";");
            }
            jSourceCode.add("");
            ++n3;
        }
        jSourceCode.add("");
        jSourceCode.add("return result;");
    }

    private void createUnmarshalMethods(JClass jClass) {
        String string = "unmarshal";
        if (SourceGenerator.mappingSchemaType2Java()) {
            string = String.valueOf(string) + jClass.getName(true);
        }
        JMethod jMethod = new JMethod(jClass, string);
        jMethod.getModifiers().setStatic(true);
        jMethod.addException(SGTypes.MarshalException);
        jMethod.addException(SGTypes.ValidationException);
        jMethod.addParameter(new JParameter(SGTypes.Reader, "reader"));
        jClass.addMethod(jMethod);
        JSourceCode jSourceCode = jMethod.getSourceCode();
        jSourceCode.add("return (");
        jSourceCode.append(jClass.getName());
        jSourceCode.append(") Unmarshaller.unmarshal(");
        jSourceCode.append(jClass.getName());
        jSourceCode.append(".class, reader);");
    }

    private void createValidateMethods(JClass jClass) {
        JMethod jMethod = null;
        JSourceCode jSourceCode = null;
        jMethod = new JMethod(null, "validate");
        jMethod.addException(SGTypes.ValidationException);
        jClass.addMethod(jMethod);
        jSourceCode = jMethod.getSourceCode();
        jSourceCode.add("org.exolab.castor.xml.Validator validator = new ");
        jSourceCode.append("org.exolab.castor.xml.Validator();");
        jSourceCode.add("validator.validate(this);");
        jMethod = new JMethod(JType.Boolean, "isValid");
        jSourceCode = jMethod.getSourceCode();
        jSourceCode.add("try {");
        jSourceCode.indent();
        jSourceCode.add("validate();");
        jSourceCode.unindent();
        jSourceCode.add("}");
        jSourceCode.add("catch (org.exolab.castor.xml.ValidationException vex) {");
        jSourceCode.indent();
        jSourceCode.add("return false;");
        jSourceCode.unindent();
        jSourceCode.add("}");
        jSourceCode.add("return true;");
        jClass.addMethod(jMethod);
    }

    private static String escapeValue(String string) {
        if (string == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            char c = cArray[n];
            switch (c) {
                case '\"': 
                case '\'': 
                case '\\': {
                    stringBuffer.append('\\');
                    break;
                }
            }
            stringBuffer.append(c);
            ++n;
        }
        return stringBuffer.toString();
    }

    private void handleField(FieldInfo fieldInfo, FactoryState factoryState) {
        if (fieldInfo == null) {
            return;
        }
        JSourceCode jSourceCode = factoryState.jClass.getConstructor(0).getSourceCode();
        factoryState.classInfo.addFieldInfo(fieldInfo);
        fieldInfo.createJavaField(factoryState.jClass);
        if (!fieldInfo.isTransient()) {
            fieldInfo.createAccessMethods(factoryState.jClass);
            if (fieldInfo.isBound()) {
                factoryState.setBoundProperties(true);
            }
        }
        fieldInfo.generateInitializerCode(jSourceCode);
    }

    private void initialize(JClass jClass) {
        jClass.addInterface("java.io.Serializable");
        JConstructor jConstructor = jClass.createConstructor();
        jClass.addConstructor(jConstructor);
        jConstructor.getSourceCode().add("super();");
        if (this._createMarshalMethods) {
            jClass.addImport("org.exolab.castor.xml.*");
        }
        jClass.addImport("java.io.Serializable");
    }

    private String processAnnotations(Annotated annotated) {
        Enumeration enumeration = annotated.getAnnotations();
        if (enumeration.hasMoreElements()) {
            StringBuffer stringBuffer = new StringBuffer();
            while (enumeration.hasMoreElements()) {
                Annotation annotation = (Annotation)enumeration.nextElement();
                Enumeration enumeration2 = annotation.getDocumentation();
                while (enumeration2.hasMoreElements()) {
                    Documentation documentation = (Documentation)enumeration2.nextElement();
                    String string = documentation.getContent();
                    if (string == null) continue;
                    stringBuffer.append(string);
                }
            }
            return stringBuffer.toString();
        }
        return null;
    }

    private void processComplexType(ComplexType complexType, FactoryState factoryState) {
        JClass[] jClassArray;
        Object object;
        Object object2;
        Object object3;
        String string = complexType.getName();
        ClassInfo classInfo = factoryState.classInfo;
        classInfo.setSchemaType(new XSClass(factoryState.jClass, string));
        Schema schema = complexType.getSchema();
        classInfo.setNamespaceURI(schema.getTargetNamespace());
        XMLType xMLType = complexType.getBaseType();
        if (xMLType != null && xMLType.isComplexType()) {
            object3 = null;
            if (xMLType.getSchema() == schema) {
                object2 = factoryState.resolve(xMLType);
                if (object2 == null) {
                    object = factoryState.jClass.getPackageName();
                    jClassArray = this.createSourceCode((ComplexType)xMLType, factoryState.getSGStateInfo());
                    object2 = factoryState.resolve(xMLType);
                    object3 = jClassArray[0].getName();
                } else {
                    object3 = ((ClassInfo)object2).getJClass().getName();
                }
            } else {
                object3 = SourceGenerator.getQualifiedClassName(xMLType.getSchema().getTargetNamespace(), JavaNaming.toJavaClassName(xMLType.getName()));
            }
            factoryState.jClass.setSuperClass((String)object3);
        }
        if (xMLType != null && xMLType.isSimpleType()) {
            object3 = this.memberFactory.createFieldInfoForContent(TypeConversion.convertType((SimpleType)xMLType));
            this.handleField((FieldInfo)object3, factoryState);
        }
        object3 = complexType.getAttributeDecls();
        while (object3.hasMoreElements()) {
            object2 = (AttributeDecl)object3.nextElement();
            object = ((AttributeDecl)object2).getSimpleType();
            if (object != null && !SimpleTypesFactory.isBuiltInType(((SimpleType)object).getTypeCode())) {
                this.createSourceCode((SimpleType)object, factoryState.getSGStateInfo());
            }
            jClassArray = this.memberFactory.createFieldInfo((AttributeDecl)object2, (ClassInfoResolver)factoryState);
            this.handleField((FieldInfo)jClassArray, factoryState);
        }
        object2 = complexType.getContentType();
        if (object2 == ContentType.mixed || object2 == ContentType.any) {
            object = this.memberFactory.createFieldInfoForContent(new XSString());
            this.handleField((FieldInfo)object, factoryState);
        }
        this.processContentModel(complexType, factoryState);
    }

    private void processContentModel(ContentModelGroup contentModelGroup, FactoryState factoryState) {
        Enumeration enumeration = contentModelGroup.enumerate();
        FieldInfo fieldInfo = null;
        while (enumeration.hasMoreElements()) {
            Structure structure = (Structure)enumeration.nextElement();
            switch (structure.getStructureType()) {
                case 7: {
                    Particle particle3 = (ElementDecl)structure;
                    boolean bl = false;
                    if (SourceGenerator.mappingSchemaElement2Java()) {
                        bl = true;
                    } else if (SourceGenerator.mappingSchemaType2Java() && (((ElementDecl)particle3).getType().getName() == null || ((ElementDecl)particle3).getType().isSimpleType())) {
                        bl = true;
                    }
                    if (bl) {
                        Particle particle2 = particle3;
                        while (((ElementDecl)particle2).isReference()) {
                            if ((particle2 = ((ElementDecl)particle2).getReference()) != null) continue;
                            String string = "Unable to find element referenced :\" ";
                            string = String.valueOf(string) + ((ElementDecl)particle3).getName();
                            string = String.valueOf(string) + "\"";
                            throw new IllegalStateException(string);
                        }
                        boolean bl2 = factoryState.processed((ElementDecl)particle2);
                        if (factoryState.resolve(structure) == null && !bl2) {
                            this.createSourceCode((ElementDecl)structure, factoryState.getSGStateInfo());
                        }
                    }
                    fieldInfo = this.memberFactory.createFieldInfo((ElementDecl)structure, (ClassInfoResolver)factoryState);
                    this.handleField(fieldInfo, factoryState);
                    break;
                }
                case 9: {
                    Object object;
                    Particle particle;
                    Particle particle3 = (Group)structure;
                    boolean bl = false;
                    int n = particle3.getMaxOccurs();
                    if (n < 0 || n > 1) {
                        GroupInfo groupInfo = factoryState.classInfo.getGroupInfo();
                        groupInfo.setMaxOccurs(n);
                        groupInfo.setMinOccurs(particle3.getMinOccurs());
                    }
                    Enumeration enumeration2 = ((Group)particle3).getWildcard();
                    while (enumeration2.hasMoreElements()) {
                        particle = (Wildcard)enumeration2.nextElement();
                        object = this.memberFactory.createFieldInfoForAny();
                        this.handleField((FieldInfo)object, factoryState);
                    }
                    if (!(contentModelGroup instanceof ComplexType) && !(contentModelGroup instanceof ModelGroup)) {
                        fieldInfo = this.memberFactory.createFieldInfo((Group)particle3, factoryState.getSGStateInfo());
                        this.handleField(fieldInfo, factoryState);
                        break;
                    }
                    this.processContentModel((ContentModelGroup)((Object)particle3), factoryState);
                    break;
                }
                case 10: {
                    Particle particle = (ModelGroup)structure;
                    Object object = particle.getReference();
                    if (object == null) {
                        String string = "Unable to find group referenced :\" ";
                        string = String.valueOf(string) + particle.getName();
                        string = String.valueOf(string) + "\"";
                        throw new IllegalStateException(string);
                    }
                    if (((Group)object).getContentModelGroup() != null) {
                        if (((Group)object).getName() != null) {
                            fieldInfo = this.memberFactory.createFieldInfo((Group)object, factoryState.getSGStateInfo());
                            this.handleField(fieldInfo, factoryState);
                            break;
                        }
                        this.processContentModel(((Group)object).getContentModelGroup(), factoryState);
                        break;
                    }
                    String string = "<group> should contains :\" ";
                    string = String.valueOf(string) + " 'all' or 'sequence' or 'choice'";
                    string = String.valueOf(string) + "\"";
                    throw new IllegalStateException(string);
                }
            }
        }
    }

    private void processEnumeration(SimpleType simpleType, FactoryState factoryState) {
        switch (this.enumerationType) {
            case 0: {
                this.processEnumerationAsBaseType(simpleType, factoryState);
                break;
            }
            default: {
                this.processEnumerationAsNewObject(simpleType, factoryState);
            }
        }
    }

    private void processEnumerationAsBaseType(SimpleType simpleType, FactoryState factoryState) {
        Object object;
        SimpleType simpleType2 = (SimpleType)simpleType.getBaseType();
        XSType xSType = null;
        xSType = simpleType2 == null ? new XSString() : TypeConversion.convertType(simpleType2);
        Enumeration enumeration = simpleType.getFacets("enumeration");
        JClass jClass = factoryState.jClass;
        String string = jClass.getLocalName();
        JField jField = null;
        JDocComment jDocComment = null;
        JSourceCode jSourceCode = null;
        JConstructor jConstructor = jClass.getConstructor(0);
        jConstructor.getModifiers().makePrivate();
        jField = new JField(xSType.getJType().createArray(), "values");
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer("{\n");
        while (enumeration.hasMoreElements()) {
            object = (Facet)enumeration.nextElement();
            String string2 = ((Facet)object).getValue();
            if (n > 0) {
                stringBuffer.append(",\n");
            }
            stringBuffer.append("    ");
            if (xSType.getType() == 1) {
                stringBuffer.append('\"');
                stringBuffer.append(SourceFactory.escapeValue(string2));
                stringBuffer.append('\"');
            } else {
                stringBuffer.append(string2);
            }
            ++n;
        }
        stringBuffer.append("\n}");
        jField.setInitString(stringBuffer.toString());
        jClass.addField(jField);
        object = new JMethod(jClass, "valueOf");
        ((JMethod)object).addParameter(new JParameter(SGTypes.String, "string"));
        ((JMethod)object).getModifiers().setStatic(true);
        jClass.addMethod((JMethod)object);
        jDocComment = ((JMethod)object).getJDocComment();
        jDocComment.appendComment("Returns the " + xSType.getJType());
        jDocComment.appendComment(" based on the given String value.");
        jSourceCode = ((JMethod)object).getSourceCode();
        jSourceCode.add("for (int i = 0; i < values.length; i++) {");
        jSourceCode.add("}");
        jSourceCode.add("throw new IllegalArgumentException(\"");
        jSourceCode.append("Invalid value for ");
        jSourceCode.append(string);
        jSourceCode.append(": \" + string + \".\");");
    }

    private void processEnumerationAsNewObject(SimpleType simpleType, FactoryState factoryState) {
        Object object;
        String string;
        Object object2;
        Enumeration enumeration = simpleType.getFacets("enumeration");
        boolean bl = true;
        while (enumeration.hasMoreElements()) {
            object2 = (Facet)enumeration.nextElement();
            string = ((Facet)object2).getValue().toUpperCase();
            if (JavaNaming.isValidJavaIdentifier(string)) continue;
            bl = false;
            break;
        }
        enumeration = simpleType.getFacets("enumeration");
        object2 = factoryState.jClass;
        string = ((JType)object2).getLocalName();
        JField jField = null;
        JField jField2 = new JField(SGTypes.Hashtable, "_memberTable");
        jField2.setInitString("init()");
        jField2.getModifiers().setStatic(true);
        JDocComment jDocComment = null;
        JSourceCode jSourceCode = null;
        JConstructor jConstructor = ((JClass)object2).getConstructor(0);
        jConstructor.getModifiers().makePrivate();
        jConstructor.addParameter(new JParameter(JType.Int, "type"));
        jConstructor.addParameter(new JParameter(SGTypes.String, "value"));
        jSourceCode = jConstructor.getSourceCode();
        jSourceCode.add("this.type = type;");
        jSourceCode.add("this.stringValue = value;");
        JMethod jMethod = new JMethod((JType)object2, "valueOf");
        jMethod.addParameter(new JParameter(SGTypes.String, "string"));
        jMethod.getModifiers().setStatic(true);
        ((JClass)object2).addMethod(jMethod);
        jDocComment = jMethod.getJDocComment();
        jDocComment.appendComment("Returns a new " + string);
        jDocComment.appendComment(" based on the given String value.");
        jSourceCode = jMethod.getSourceCode();
        jSourceCode.add("Object obj = null;");
        jSourceCode.add("if (string != null) ");
        jSourceCode.append("obj = _memberTable.get(string);");
        jSourceCode.add("if (obj == null) {");
        jSourceCode.indent();
        jSourceCode.add("String err = \"'\" + string + \"' is not a valid ");
        jSourceCode.append(string);
        jSourceCode.append("\";");
        jSourceCode.add("throw new IllegalArgumentException(err);");
        jSourceCode.unindent();
        jSourceCode.add("}");
        jSourceCode.add("return (");
        jSourceCode.append(string);
        jSourceCode.append(") obj;");
        JMethod jMethod2 = new JMethod(SGTypes.Enumeration, "enumerate");
        jMethod2.getModifiers().setStatic(true);
        ((JClass)object2).addMethod(jMethod2);
        jDocComment = jMethod2.getJDocComment();
        jDocComment.appendComment("Returns an enumeration of all possible instances of ");
        jDocComment.appendComment(string);
        jMethod2.getSourceCode().add("return _memberTable.elements();");
        JMethod jMethod3 = new JMethod(SGTypes.String, "toString");
        ((JClass)object2).addMethod(jMethod3);
        jDocComment = jMethod3.getJDocComment();
        jDocComment.appendComment("Returns the String representation of this ");
        jDocComment.appendComment(string);
        jMethod3.getSourceCode().add("return this.stringValue;");
        JMethod jMethod4 = new JMethod(SGTypes.Hashtable, "init");
        ((JClass)object2).addMethod(jMethod4);
        jMethod4.getModifiers().makePrivate();
        jMethod4.getModifiers().setStatic(true);
        jMethod4.getSourceCode().add("Hashtable members = new Hashtable();");
        int n = 0;
        while (enumeration.hasMoreElements()) {
            object = (Facet)enumeration.nextElement();
            String string2 = ((Facet)object).getValue();
            String string3 = null;
            String string4 = null;
            string4 = bl ? string2.toUpperCase() : "VALUE_" + n;
            string3 = String.valueOf(string4) + "_TYPE";
            boolean bl2 = true;
            if (((JClass)object2).getField(string4) != null) {
                ((JClass)object2).removeField(string4);
                ((JClass)object2).removeField(string3);
                bl2 = false;
            }
            jField = new JField(JType.Int, string3);
            jField.setComment("The " + string2 + " type");
            JModifiers jModifiers = jField.getModifiers();
            jModifiers.setFinal(true);
            jModifiers.setStatic(true);
            jModifiers.makePublic();
            jField.setInitString(Integer.toString(n));
            ((JClass)object2).addField(jField);
            jField = new JField((JType)object2, string4);
            jField.setComment("The instance of the " + string2 + " type");
            jModifiers = jField.getModifiers();
            jModifiers.setFinal(true);
            jModifiers.setStatic(true);
            jModifiers.makePublic();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("new ");
            stringBuffer.append(string);
            stringBuffer.append("(");
            stringBuffer.append(string3);
            stringBuffer.append(", \"");
            stringBuffer.append(string2);
            stringBuffer.append("\")");
            jField.setInitString(stringBuffer.toString());
            ((JClass)object2).addField(jField);
            if (bl2) {
                jSourceCode = jMethod4.getSourceCode();
                jSourceCode.add("members.put(\"");
                jSourceCode.append(SourceFactory.escapeValue(string2));
                jSourceCode.append("\", ");
                jSourceCode.append(string4);
                jSourceCode.append(");");
            }
            ++n;
        }
        jMethod4.getSourceCode().add("return members;");
        ((JClass)object2).addField(jField2);
        jField = new JField(JType.Int, "type");
        jField.setInitString("-1");
        ((JClass)object2).addField(jField);
        jField = new JField(SGTypes.String, "stringValue");
        jField.setInitString("null");
        ((JClass)object2).addField(jField);
        object = new JMethod(JType.Int, "getType");
        ((JMethod)object).getSourceCode().add("return this.type;");
        jDocComment = ((JMethod)object).getJDocComment();
        jDocComment.appendComment("Returns the type of this " + string);
        ((JClass)object2).addMethod((JMethod)object);
    }

    private String resolveClassName(String string, String string2) {
        if (string2 != null && string2.length() > 0) {
            return String.valueOf(string2) + "." + string;
        }
        return string;
    }

    public void setCreateMarshalMethods(boolean bl) {
        this._createMarshalMethods = bl;
    }

    public void setTestable(boolean bl) {
        this._testable = bl;
    }
}

