/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.drivers;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Properties;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.spi.KeyGenerator;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.persist.spi.QueryExpression;
import org.exolab.castor.util.Messages;

public class HighLowKeyGenerator
implements KeyGenerator {
    private static final BigDecimal ONE = new BigDecimal(1.0);
    private static final String SEQ_TABLE = "table";
    private static final String SEQ_KEY = "key-column";
    private static final String SEQ_VALUE = "value-column";
    private static final String GRAB_SIZE = "grab-size";
    private static final String SAME_CONNECTION = "same-connection";
    private static final String GLOBAL = "global";
    private final PersistenceFactory _factory;
    private final int _sqlType;
    private final String _seqTable;
    private final String _seqKey;
    private final String _seqValue;
    private int _grabSizeI;
    private boolean _sameConnection;
    private BigDecimal _grabSizeD;
    private Hashtable _lastValues = new Hashtable();
    private Hashtable _maxValues = new Hashtable();
    private boolean _global;

    public HighLowKeyGenerator(PersistenceFactory persistenceFactory, Properties properties, int n) throws MappingException {
        this._factory = persistenceFactory;
        this._sqlType = n;
        if (n != 4 && n != 2 && n != 3 && n != -5) {
            throw new MappingException(Messages.format("mapping.keyGenSQLType", this.getClass().getName(), new Integer(n)));
        }
        this._seqTable = properties.getProperty(SEQ_TABLE);
        if (this._seqTable == null) {
            throw new MappingException(Messages.format("mapping.KeyGenParamNotSet", SEQ_TABLE, this.getClass().getName()));
        }
        this._seqKey = properties.getProperty(SEQ_KEY);
        if (this._seqKey == null) {
            throw new MappingException(Messages.format("mapping.KeyGenParamNotSet", SEQ_KEY, this.getClass().getName()));
        }
        this._seqValue = properties.getProperty(SEQ_VALUE);
        if (this._seqValue == null) {
            throw new MappingException(Messages.format("mapping.KeyGenParamNotSet", SEQ_VALUE, this.getClass().getName()));
        }
        String string = properties.getProperty(GRAB_SIZE, "10");
        try {
            this._grabSizeI = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this._grabSizeI = 0;
        }
        if (this._grabSizeI <= 0) {
            throw new MappingException(Messages.format("mapping.wrongKeyGenParam", string, GRAB_SIZE, this.getClass().getName()));
        }
        this._grabSizeD = new BigDecimal((double)this._grabSizeI);
        this._sameConnection = "true".equals(properties.getProperty(SAME_CONNECTION));
        this._global = "true".equals(properties.getProperty(GLOBAL));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Object generateKey(Connection connection, String string, String string2, Properties properties) throws PersistenceException {
        boolean bl;
        Object object;
        Object object2;
        block44: {
            Statement statement;
            block41: {
                block43: {
                    if (this._global) {
                        string = "<GLOBAL>";
                    }
                    object2 = this._lastValues.get(string);
                    object = this._maxValues.get(string);
                    if (object2 == null) break block43;
                    object2 = this._sqlType == 4 ? (Number)new Integer((Integer)object2 + 1) : (Number)(this._sqlType == -5 ? new Long((Long)object2 + 1L) : ((BigDecimal)object2).add(ONE));
                    break block44;
                }
                Statement statement2 = null;
                statement = null;
                try {
                    try {
                        boolean bl2;
                        block40: {
                            if (!this._sameConnection) {
                                connection.rollback();
                            }
                            QueryExpression queryExpression = this._factory.getQueryExpression();
                            queryExpression.addColumn(this._seqTable, this._seqValue);
                            queryExpression.addCondition(this._seqTable, this._seqKey, "=", "?");
                            String string3 = queryExpression.getStatement(true);
                            String string4 = "UPDATE " + this._seqTable + " SET " + this._seqValue + "=" + "?" + " WHERE " + this._seqKey + "=" + "?" + " AND " + this._seqValue + "=" + "?";
                            statement2 = connection.prepareStatement(string3);
                            statement2.setString(1, string);
                            statement = connection.prepareStatement(string4);
                            statement.setString(2, string);
                            bl2 = false;
                            int n = 0;
                            while (true) {
                                int n2;
                                if (bl2 || n >= 7) {
                                    if (!this._sameConnection) {
                                        if (!bl2) break;
                                        connection.commit();
                                    }
                                    break block40;
                                }
                                ResultSet resultSet = statement2.executeQuery();
                                if (resultSet.next()) {
                                    if (this._sqlType == 4) {
                                        n2 = resultSet.getInt(1);
                                        statement.setInt(3, n2);
                                        object2 = new Integer(n2 + 1);
                                        int n3 = n2 + this._grabSizeI;
                                        object = new Integer(n3);
                                        statement.setInt(1, n3);
                                    } else if (this._sqlType == -5) {
                                        long l = resultSet.getLong(1);
                                        statement.setLong(3, l);
                                        object2 = new Long(l + 1L);
                                        long l2 = l + (long)this._grabSizeI;
                                        object = new Long(l2);
                                        statement.setLong(1, l2);
                                    } else {
                                        BigDecimal bigDecimal = resultSet.getBigDecimal(1);
                                        statement.setBigDecimal(3, bigDecimal);
                                        object2 = bigDecimal.add(ONE);
                                        BigDecimal bigDecimal2 = bigDecimal.add(this._grabSizeD);
                                        object = bigDecimal2;
                                        statement.setBigDecimal(1, bigDecimal2);
                                    }
                                    bl2 = statement.executeUpdate() == 1;
                                } else {
                                    statement2.close();
                                    if (!this._global) {
                                        statement2 = connection.prepareStatement("SELECT MAX(" + string2 + ") FROM " + string);
                                        resultSet = statement2.executeQuery();
                                    }
                                    if (this._sqlType == 4) {
                                        n2 = 0;
                                        if (!this._global && resultSet.next()) {
                                            n2 = resultSet.getInt(1);
                                        }
                                        object2 = new Integer(n2 + 1);
                                        object = new Integer(n2 + this._grabSizeI);
                                    } else if (this._sqlType == -5) {
                                        long l = 0L;
                                        if (!this._global && resultSet.next()) {
                                            l = resultSet.getLong(1);
                                        }
                                        object2 = new Long(l + 1L);
                                        object = new Long(l + (long)this._grabSizeI);
                                    } else {
                                        BigDecimal bigDecimal = null;
                                        if (!this._global && resultSet.next()) {
                                            bigDecimal = resultSet.getBigDecimal(1);
                                        }
                                        if (bigDecimal == null) {
                                            bigDecimal = new BigDecimal(0.0);
                                        }
                                        object2 = bigDecimal.add(ONE);
                                        object = bigDecimal.add(this._grabSizeD);
                                    }
                                    statement.close();
                                    statement = connection.prepareStatement("INSERT INTO " + this._seqTable + " (" + this._seqKey + "," + this._seqValue + ") VALUES (?, ?)");
                                    statement.setString(1, string);
                                    statement.setObject(2, object);
                                    statement.executeUpdate();
                                    bl2 = true;
                                }
                                ++n;
                            }
                            connection.rollback();
                        }
                        if (!bl2) {
                            throw new PersistenceException(Messages.message("persist.keyGenFailed"));
                        }
                    }
                    catch (SQLException sQLException) {
                        if (this._sameConnection) throw new PersistenceException(Messages.format("persist.keyGenSQL", sQLException.toString()), sQLException);
                        try {
                            connection.rollback();
                            throw new PersistenceException(Messages.format("persist.keyGenSQL", sQLException.toString()), sQLException);
                        }
                        catch (SQLException sQLException2) {}
                        throw new PersistenceException(Messages.format("persist.keyGenSQL", sQLException.toString()), sQLException);
                    }
                    Object var17_24 = null;
                    if (statement2 == null) break block41;
                }
                catch (Throwable throwable) {
                    Object var17_25 = null;
                    if (statement2 != null) {
                        try {
                            statement2.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    if (statement == null) throw throwable;
                    try {
                        statement.close();
                        throw throwable;
                    }
                    catch (SQLException sQLException) {}
                    throw throwable;
                }
                try {}
                catch (SQLException sQLException) {}
                statement2.close();
            }
            if (statement != null) {
                try {}
                catch (SQLException sQLException) {}
                statement.close();
            }
        }
        if (this._sqlType == 4) {
            bl = (Integer)object2 < (Integer)object;
        } else if (this._sqlType == -5) {
            bl = (Long)object2 < (Long)object;
        } else {
            boolean bl2 = bl = ((BigDecimal)object2).compareTo((BigDecimal)object) < 0;
        }
        if (bl) {
            this._lastValues.put(string, object2);
            this._maxValues.put(string, object);
            return object2;
        }
        this._lastValues.remove(string);
        this._maxValues.remove(string);
        return object2;
    }

    public final byte getStyle() {
        return -1;
    }

    public final boolean isInSameConnection() {
        return this._sameConnection;
    }

    public final String patchSQL(String string, String string2) throws MappingException {
        return string;
    }
}

