/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;
import org.exolab.castor.jdo.DuplicateIdentityException;
import org.exolab.castor.jdo.ObjectDeletedException;
import org.exolab.castor.jdo.ObjectModifiedException;
import org.exolab.castor.jdo.ObjectNotFoundException;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.QueryException;
import org.exolab.castor.jdo.engine.BaseFactory;
import org.exolab.castor.jdo.engine.DatabaseRegistry;
import org.exolab.castor.jdo.engine.JDOClassDescriptor;
import org.exolab.castor.jdo.engine.JDOFieldDescriptor;
import org.exolab.castor.jdo.engine.KeyGeneratorDescriptor;
import org.exolab.castor.jdo.engine.SQLTypes;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.FieldDescriptor;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.TypeConvertor;
import org.exolab.castor.mapping.loader.FieldHandlerImpl;
import org.exolab.castor.persist.ClassMolder;
import org.exolab.castor.persist.spi.Complex;
import org.exolab.castor.persist.spi.KeyGenerator;
import org.exolab.castor.persist.spi.LogInterceptor;
import org.exolab.castor.persist.spi.Persistence;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.persist.spi.PersistenceQuery;
import org.exolab.castor.persist.spi.QueryExpression;
import org.exolab.castor.util.Messages;

public final class SQLEngine
implements Persistence {
    private static final boolean ID_TYPE = true;
    private static final boolean FIELD_TYPE = false;
    private static Hashtable _separateConnections = new Hashtable();
    private String _pkLookup;
    private String _sqlCreate;
    private String _sqlRemove;
    private String _sqlStore;
    private String _sqlStoreDirty;
    private String _sqlLoad;
    private String _sqlLoadLock;
    private FieldInfo[] _fields;
    private ColumnInfo[] _ids;
    private SQLEngine _extends;
    private QueryExpression _sqlFinder;
    private PersistenceFactory _factory;
    private String _stampField;
    private String _type;
    private String _mapTo;
    private String _extTable;
    private LogInterceptor _logInterceptor;
    private JDOClassDescriptor _clsDesc;
    private KeyGenerator _keyGen;
    private ClassMolder _mold;

    SQLEngine(JDOClassDescriptor jDOClassDescriptor, LogInterceptor logInterceptor, PersistenceFactory persistenceFactory, String string) throws MappingException {
        Object[] objectArray;
        Object object;
        Object object2;
        this._clsDesc = jDOClassDescriptor;
        this._stampField = string;
        this._factory = persistenceFactory;
        this._logInterceptor = logInterceptor;
        this._keyGen = null;
        this._type = jDOClassDescriptor.getJavaClass().getName();
        this._mapTo = jDOClassDescriptor.getTableName();
        if (this._clsDesc.getExtends() == null && (object2 = jDOClassDescriptor.getKeyGeneratorDescriptor()) != null) {
            object = ((JDOFieldDescriptor)this._clsDesc.getIdentity()).getSQLType();
            this._keyGen = ((KeyGeneratorDescriptor)object2).getKeyGeneratorRegistry().getKeyGenerator(this._factory, (KeyGeneratorDescriptor)object2, (int)(object == null ? false : object[0]), this._logInterceptor);
        }
        object2 = new Vector();
        object = new Vector();
        JDOClassDescriptor jDOClassDescriptor2 = jDOClassDescriptor;
        jDOClassDescriptor2 = jDOClassDescriptor;
        Stack<JDOClassDescriptor> stack = new Stack<JDOClassDescriptor>();
        stack.push(jDOClassDescriptor2);
        while (jDOClassDescriptor2.getExtends() != null) {
            jDOClassDescriptor2 = (JDOClassDescriptor)jDOClassDescriptor2.getExtends();
            stack.push(jDOClassDescriptor2);
        }
        if (jDOClassDescriptor2 != jDOClassDescriptor) {
            this._extTable = jDOClassDescriptor2.getTableName();
        }
        JDOClassDescriptor jDOClassDescriptor3 = jDOClassDescriptor2;
        FieldDescriptor[] fieldDescriptorArray = jDOClassDescriptor2.getIdentities();
        FieldDescriptor[] fieldDescriptorArray2 = jDOClassDescriptor.getIdentities();
        int n = 0;
        while (n < fieldDescriptorArray.length) {
            FieldHandlerImpl fieldHandlerImpl;
            int[] nArray;
            if (fieldDescriptorArray[n] instanceof JDOFieldDescriptor) {
                String string2 = fieldDescriptorArray[n].getFieldName();
                objectArray = ((JDOFieldDescriptor)fieldDescriptorArray[n]).getSQLName();
                nArray = ((JDOFieldDescriptor)fieldDescriptorArray[n]).getSQLType();
                fieldHandlerImpl = (FieldHandlerImpl)fieldDescriptorArray[n].getHandler();
                int n2 = 0;
                while (n2 < fieldDescriptorArray2.length) {
                    if (string2.equals(fieldDescriptorArray2[n2].getFieldName()) && fieldDescriptorArray2[n2] instanceof JDOFieldDescriptor) {
                        objectArray = ((JDOFieldDescriptor)fieldDescriptorArray2[n2]).getSQLName();
                        break;
                    }
                    ++n2;
                }
            } else {
                throw new MappingException("Except JDOFieldDescriptor");
            }
            ((Vector)object2).add(new ColumnInfo((String)objectArray[0], nArray[0], fieldHandlerImpl.getConvertTo(), fieldHandlerImpl.getConvertFrom(), fieldHandlerImpl.getConvertParam()));
            ++n;
        }
        boolean bl = true;
        while (!stack.empty()) {
            jDOClassDescriptor2 = (JDOClassDescriptor)stack.pop();
            objectArray = jDOClassDescriptor2.getFields();
            int n3 = 0;
            while (n3 < objectArray.length) {
                if (stack.empty()) {
                    ((Vector)object).add(new FieldInfo(jDOClassDescriptor, (FieldDescriptor)objectArray[n3], jDOClassDescriptor.getTableName(), bl ^ true));
                } else {
                    ((Vector)object).add(new FieldInfo(jDOClassDescriptor, (FieldDescriptor)objectArray[n3], jDOClassDescriptor2.getTableName(), bl));
                }
                ++n3;
            }
        }
        this._ids = new ColumnInfo[((Vector)object2).size()];
        ((Vector)object2).copyInto(this._ids);
        this._fields = new FieldInfo[((Vector)object).size()];
        ((Vector)object).copyInto(this._fields);
        try {
            this.buildSql();
            this.buildFinder(jDOClassDescriptor);
        }
        catch (QueryException queryException) {
            queryException.printStackTrace();
            throw new MappingException(queryException);
        }
    }

    private void addLoadSql(QueryExpression queryExpression, Vector vector, boolean bl, boolean bl2, boolean bl3) throws MappingException {
    }

    private void buildFinder(JDOClassDescriptor jDOClassDescriptor) throws MappingException, QueryException {
        int n;
        Vector vector = new Vector();
        QueryExpression queryExpression = this._factory.getQueryExpression();
        QueryExpression queryExpression2 = this._factory.getQueryExpression();
        String[] stringArray = new String[this._ids.length];
        int n2 = 0;
        while (n2 < this._ids.length) {
            stringArray[n2] = this._ids[n2].name;
            queryExpression.addParameter(this._mapTo, this._ids[n2].name, "=");
            ++n2;
        }
        JDOClassDescriptor jDOClassDescriptor2 = jDOClassDescriptor;
        String[] stringArray2 = stringArray;
        while (jDOClassDescriptor2.getExtends() != null) {
            JDOClassDescriptor jDOClassDescriptor3 = (JDOClassDescriptor)jDOClassDescriptor2.getExtends();
            String[] stringArray3 = new String[this._ids.length];
            n = 0;
            while (n < this._ids.length) {
                stringArray3[n] = ((JDOFieldDescriptor)jDOClassDescriptor3.getIdentities()[n]).getSQLName()[0];
                ++n;
            }
            queryExpression.addInnerJoin(jDOClassDescriptor2.getTableName(), stringArray2, jDOClassDescriptor3.getTableName(), stringArray3);
            queryExpression2.addInnerJoin(jDOClassDescriptor2.getTableName(), stringArray2, jDOClassDescriptor3.getTableName(), stringArray3);
            jDOClassDescriptor2 = jDOClassDescriptor3;
            stringArray2 = stringArray3;
        }
        n = 0;
        while (n < this._ids.length) {
            queryExpression2.addColumn(this._mapTo, stringArray[n]);
            ++n;
        }
        Vector<String> vector2 = new Vector<String>();
        int n3 = 0;
        while (n3 < this._fields.length) {
            if (this._fields[n3].load) {
                int n4;
                if (this._fields[n3].joined) {
                    n4 = 0;
                    String[] stringArray4 = this._fields[n3].joinFields;
                    String[] stringArray5 = new String[this._ids.length - n4];
                    int n5 = 0;
                    while (n5 < stringArray5.length) {
                        stringArray5[n5] = this._ids[n5 + n4].name;
                        ++n5;
                    }
                    queryExpression.addOuterJoin(this._mapTo, stringArray5, this._fields[n3].tableName, stringArray4);
                    queryExpression2.addOuterJoin(this._mapTo, stringArray5, this._fields[n3].tableName, stringArray4);
                    vector2.add(this._fields[n3].tableName);
                }
                n4 = 0;
                while (n4 < this._fields[n3].columns.length) {
                    queryExpression.addColumn(this._fields[n3].tableName, this._fields[n3].columns[n4].name);
                    queryExpression2.addColumn(this._fields[n3].tableName, this._fields[n3].columns[n4].name);
                    ++n4;
                }
            }
            ++n3;
        }
        this._sqlLoad = queryExpression.getStatement(false);
        this._sqlLoadLock = queryExpression.getStatement(true);
        this._sqlFinder = queryExpression2;
        if (this._logInterceptor != null) {
            this._logInterceptor.storeStatement("SQL for loading " + this._type + ":  " + this._sqlLoad);
        }
    }

    private void buildSql() throws QueryException {
        int n;
        int n2;
        boolean bl = false;
        String string = this._mapTo;
        QueryExpression queryExpression = this._factory.getQueryExpression();
        int n3 = 0;
        while (n3 < this._ids.length) {
            queryExpression.addParameter(string, this._ids[n3].name, "=");
            ++n3;
        }
        this._pkLookup = queryExpression.getStatement(true);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" WHERE ");
        int n4 = 0;
        while (n4 < this._ids.length) {
            if (n4 > 0) {
                stringBuffer.append(" AND ");
            }
            stringBuffer.append(this._factory.quoteName(this._ids[n4].name));
            stringBuffer.append("=");
            stringBuffer.append("?");
            ++n4;
        }
        String string2 = stringBuffer.toString();
        StringBuffer stringBuffer2 = new StringBuffer("INSERT INTO ");
        stringBuffer2.append(this._factory.quoteName(string)).append(" (");
        int n5 = 0;
        int n6 = 0;
        while (n6 < this._ids.length) {
            if (this._keyGen == null || this._keyGen.getStyle() == -1) {
                if (n5 > 0) {
                    stringBuffer2.append(',');
                }
                bl = true;
                stringBuffer2.append(this._factory.quoteName(this._ids[n6].name));
                ++n5;
            }
            ++n6;
        }
        int n7 = 0;
        while (n7 < this._fields.length) {
            if (this._fields[n7].store) {
                n2 = 0;
                while (n2 < this._fields[n7].columns.length) {
                    if (n5 > 0) {
                        stringBuffer2.append(',');
                    }
                    stringBuffer2.append(this._factory.quoteName(this._fields[n7].columns[n2].name));
                    ++n5;
                    ++n2;
                }
            }
            ++n7;
        }
        if (n5 == 0) {
            stringBuffer2.setLength(stringBuffer2.length() - 2);
        } else {
            stringBuffer2.append(")");
        }
        stringBuffer2.append(" VALUES (");
        n2 = 0;
        while (n2 < n5) {
            if (n2 > 0) {
                stringBuffer2.append(',');
            }
            stringBuffer2.append('?');
            ++n2;
        }
        stringBuffer2.append(')');
        this._sqlCreate = stringBuffer2.toString();
        if (!bl) {
            try {
                this._sqlCreate = this._keyGen.patchSQL(this._sqlCreate, this._ids[0].name);
            }
            catch (MappingException mappingException) {
                this._logInterceptor.exception(mappingException);
                this._keyGen = null;
                this.buildSql();
                return;
            }
            if (this._keyGen.getStyle() == 0) {
                this._sqlCreate = "{call " + this._sqlCreate + "}";
            }
        }
        if (this._logInterceptor != null) {
            this._logInterceptor.storeStatement("SQL for creating " + this._type + ": " + this._sqlCreate);
        }
        stringBuffer2 = new StringBuffer("DELETE FROM ").append(this._factory.quoteName(string));
        stringBuffer2.append(string2);
        this._sqlRemove = stringBuffer2.toString();
        if (this._logInterceptor != null) {
            this._logInterceptor.storeStatement("SQL for deleting " + this._type + ": " + this._sqlRemove);
        }
        stringBuffer2 = new StringBuffer("UPDATE ");
        stringBuffer2.append(this._factory.quoteName(this._mapTo));
        stringBuffer2.append(" SET ");
        n5 = 0;
        int n8 = 0;
        while (n8 < this._fields.length) {
            if (this._fields[n8].store) {
                n = 0;
                while (n < this._fields[n8].columns.length) {
                    if (n5 > 0) {
                        stringBuffer2.append(',');
                    }
                    stringBuffer2.append(this._factory.quoteName(this._fields[n8].columns[n].name));
                    stringBuffer2.append("=?");
                    ++n5;
                    ++n;
                }
            }
            ++n8;
        }
        stringBuffer2.append(string2);
        this._sqlStore = stringBuffer2.toString();
        n = 0;
        while (n < this._fields.length) {
            if (this._fields[n].store && this._fields[n].dirtyCheck) {
                int n9 = 0;
                while (n9 < this._fields[n].columns.length) {
                    stringBuffer2.append(" AND ");
                    stringBuffer2.append(this._factory.quoteName(this._fields[n].columns[n9].name));
                    stringBuffer2.append("=?");
                    ++n9;
                }
            }
            ++n;
        }
        this._sqlStoreDirty = stringBuffer2.toString();
        if (this._logInterceptor != null) {
            this._logInterceptor.storeStatement("SQL for updating " + this._type + ": " + this._sqlStoreDirty);
        }
    }

    public Object create(Object object, Object[] objectArray, Object object2) throws DuplicateIdentityException, PersistenceException {
        PreparedStatement preparedStatement = null;
        if (this._extends == null && this._keyGen == null && object2 == null) {
            throw new PersistenceException(Messages.format("persist.noIdentity", this._clsDesc.getJavaClass().getName()));
        }
        try {
            int n;
            if (this._extends != null) {
                if (!this._extends._mapTo.equals(this._mapTo)) {
                    object2 = this._extends.create(object, objectArray, object2);
                }
            } else if (this._keyGen != null && this._keyGen.getStyle() == -1) {
                object2 = this.generateKey(object, null);
            }
            preparedStatement = this._keyGen != null && this._keyGen.getStyle() == 0 ? ((Connection)object).prepareCall(this._sqlCreate) : ((Connection)object).prepareStatement(this._sqlCreate);
            int n2 = 1;
            if (this._keyGen == null || this._keyGen.getStyle() == -1) {
                if (this._ids.length > 1 && !(object2 instanceof Complex)) {
                    throw new PersistenceException("Multiple identities expected!");
                }
                if (object2 instanceof Complex) {
                    Complex complex = (Complex)object2;
                    if (complex.size() != this._ids.length || this._ids.length <= 1) {
                        throw new PersistenceException("Size of complex field mismatched!");
                    }
                    int n3 = 0;
                    while (n3 < this._ids.length) {
                        preparedStatement.setObject(n2++, this.idToSQL(n3, complex.get(n3)));
                        ++n3;
                    }
                } else {
                    if (this._ids.length != 1) {
                        throw new PersistenceException("Complex field expected!");
                    }
                    preparedStatement.setObject(n2++, this.idToSQL(0, object2));
                }
            }
            int n4 = 0;
            while (n4 < this._fields.length) {
                if (this._fields[n4].store) {
                    if (objectArray[n4] == null) {
                        int n5 = 0;
                        while (n5 < this._fields[n4].columns.length) {
                            preparedStatement.setNull(n2++, this._fields[n4].columns[n5].sqlType);
                            ++n5;
                        }
                    } else if (objectArray[n4] instanceof Complex) {
                        Complex complex = (Complex)objectArray[n4];
                        if (complex.size() != this._fields[n4].columns.length) {
                            throw new PersistenceException("Size of complex field mismatch!");
                        }
                        n = 0;
                        while (n < this._fields[n4].columns.length) {
                            Object object3 = complex == null ? null : complex.get(n);
                            SQLTypes.setObject(preparedStatement, n2++, this.toSQL(n4, n, object3), this._fields[n4].columns[n].sqlType);
                            ++n;
                        }
                    } else {
                        if (this._fields[n4].columns.length != 1) {
                            throw new PersistenceException("Complex field expected! ");
                        }
                        SQLTypes.setObject(preparedStatement, n2++, this.toSQL(n4, 0, objectArray[n4]), this._fields[n4].columns[0].sqlType);
                    }
                }
                ++n4;
            }
            if (this._keyGen != null && this._keyGen.getStyle() == 0) {
                CallableStatement callableStatement = (CallableStatement)preparedStatement;
                n = this._ids[0].sqlType;
                callableStatement.registerOutParameter(n2, n);
                callableStatement.execute();
                while (callableStatement.getMoreResults() || callableStatement.getUpdateCount() != -1) {
                }
                object2 = n == 4 ? new Integer(callableStatement.getInt(n2)) : callableStatement.getObject(n2);
                object2 = this.idToJava(0, object2);
            } else {
                preparedStatement.executeUpdate();
            }
            preparedStatement.close();
            if (this._keyGen != null && this._keyGen.getStyle() == 1) {
                object2 = this.generateKey(object, preparedStatement);
            }
            return object2;
        }
        catch (SQLException sQLException) {
            Boolean bl = this._factory.isDuplicateKeyException(sQLException);
            if (Boolean.TRUE.equals(bl)) {
                throw new DuplicateIdentityException(Messages.format("persist.duplicateIdentity", this._clsDesc.getJavaClass().getName(), object2));
            }
            if (Boolean.FALSE.equals(bl)) {
                throw new PersistenceException(Messages.format("persist.nested", sQLException), sQLException);
            }
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                preparedStatement = ((Connection)object).prepareStatement(this._pkLookup);
                int n = 1;
                if (object2 instanceof Complex) {
                    Complex complex = (Complex)object2;
                    if (complex.size() != this._ids.length || this._ids.length <= 1) {
                        throw new PersistenceException("Size of complex field mismatched!");
                    }
                    int n6 = 0;
                    while (n6 < this._ids.length) {
                        preparedStatement.setObject(n++, this.idToSQL(n6, complex.get(n6)));
                        ++n6;
                    }
                } else {
                    if (this._ids.length != 1) {
                        throw new PersistenceException("Complex field expected!");
                    }
                    preparedStatement.setObject(n++, this.idToSQL(0, object2));
                }
                if (preparedStatement.executeQuery().next()) {
                    preparedStatement.close();
                    throw new DuplicateIdentityException(Messages.format("persist.duplicateIdentity", this._clsDesc.getJavaClass().getName(), object2));
                }
            }
            catch (SQLException sQLException2) {}
        }
        try {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        catch (SQLException sQLException) {}
        throw new PersistenceException(Messages.format("persist.nested", sQLException), sQLException);
    }

    public PersistenceQuery createCall(String string, Class[] classArray) {
        if (this._logInterceptor != null) {
            this._logInterceptor.queryStatement(string);
        }
        FieldDescriptor[] fieldDescriptorArray = this._clsDesc.getFields();
        String[] stringArray = new String[fieldDescriptorArray.length + 1];
        int[] nArray = new int[fieldDescriptorArray.length + 1];
        int n = 1;
        stringArray[0] = this._clsDesc.getIdentity().getFieldName();
        nArray[0] = ((JDOFieldDescriptor)this._clsDesc.getIdentity()).getSQLType()[0];
        int n2 = 0;
        while (n2 < fieldDescriptorArray.length) {
            if (fieldDescriptorArray[n2] instanceof JDOFieldDescriptor) {
                stringArray[n] = ((JDOFieldDescriptor)fieldDescriptorArray[n2]).getSQLName()[0];
                nArray[n] = ((JDOFieldDescriptor)fieldDescriptorArray[n2]).getSQLType()[0];
                ++n;
            }
            ++n2;
        }
        String[] stringArray2 = new String[n];
        int[] nArray2 = new int[n];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        System.arraycopy(nArray, 0, nArray2, 0, n);
        if (string.startsWith("SQL")) {
            String string2 = string.substring(4);
            return new SQLQuery(this, string2, classArray);
        }
        return ((BaseFactory)this._factory).getCallQuery(string, classArray, this._clsDesc.getJavaClass(), stringArray2, nArray2);
    }

    public PersistenceQuery createQuery(QueryExpression queryExpression, Class[] classArray, AccessMode accessMode) throws QueryException {
        if (accessMode == null) {
            accessMode = this._clsDesc.getAccessMode();
        }
        String string = queryExpression.getStatement(accessMode == AccessMode.DbLocked);
        if (this._logInterceptor != null) {
            this._logInterceptor.queryStatement(string);
        }
        return new SQLQuery(this, string, classArray);
    }

    public void delete(Object object, Object object2) throws PersistenceException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = ((Connection)object).prepareStatement(this._sqlRemove);
            int n = 1;
            if (object2 instanceof Complex) {
                Complex complex = (Complex)object2;
                if (complex.size() != this._ids.length || this._ids.length <= 1) {
                    throw new PersistenceException("Size of complex field mismatched!");
                }
                int n2 = 0;
                while (n2 < this._ids.length) {
                    preparedStatement.setObject(n++, this.idToSQL(n2, complex.get(n2)));
                    ++n2;
                }
            } else {
                if (this._ids.length != 1) {
                    throw new PersistenceException("Complex field expected!");
                }
                preparedStatement.setObject(n++, this.idToSQL(0, object2));
            }
            int n3 = preparedStatement.executeUpdate();
            if (n3 < 1) {
                throw new PersistenceException("Object to be deleted does not exist! " + object2);
            }
            preparedStatement.close();
            if (this._extends != null) {
                this._extends.delete(object, object2);
            }
        }
        catch (SQLException sQLException) {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException sQLException2) {}
            throw new PersistenceException(Messages.format("persist.nested", sQLException), sQLException);
        }
    }

    private Object generateKey(Object object, PreparedStatement preparedStatement) throws PersistenceException {
        Object object2;
        Properties properties = null;
        Connection connection = this._keyGen.isInSameConnection() ? (Connection)object : this.getSeparateConnection();
        if (preparedStatement != null) {
            properties = new Properties();
            ((Hashtable)properties).put("insertStatement", preparedStatement);
        }
        Connection connection2 = connection;
        synchronized (connection2) {
            object2 = this._keyGen.generateKey(connection, this._clsDesc.getTableName(), this._ids[0].name, properties);
        }
        if (object2 == null) {
            throw new PersistenceException(Messages.format("persist.noIdentity", this._clsDesc.getJavaClass().getName()));
        }
        return this.idToJava(0, object2);
    }

    public JDOClassDescriptor getDescriptor() {
        return this._clsDesc;
    }

    public QueryExpression getFinder() {
        return (QueryExpression)this._sqlFinder.clone();
    }

    public Persistence.FieldInfo[] getInfo() {
        return this._fields;
    }

    public QueryExpression getQueryExpression() {
        return this._factory.getQueryExpression();
    }

    private synchronized Connection getSeparateConnection() throws PersistenceException {
        DatabaseRegistry databaseRegistry = DatabaseRegistry.getDatabaseRegistry(this._clsDesc.getJavaClass());
        Connection connection = (Connection)_separateConnections.get(databaseRegistry);
        if (connection == null) {
            try {
                connection = databaseRegistry.createConnection();
                connection.setAutoCommit(false);
                _separateConnections.put(databaseRegistry, connection);
            }
            catch (SQLException sQLException) {
                throw new PersistenceException(Messages.message("persist.cannotCreateSeparateConn"), sQLException);
            }
        }
        return connection;
    }

    private String getStoreStatement(Object[] objectArray) throws PersistenceException {
        StringBuffer stringBuffer = null;
        int n = 0;
        if (objectArray == null) {
            return this._sqlStore;
        }
        if (((BaseFactory)this._factory).supportsSetNullInWhere()) {
            return this._sqlStoreDirty;
        }
        n = this._sqlStoreDirty.length() - 1;
        stringBuffer = new StringBuffer(n * 4);
        stringBuffer.append(this._sqlStoreDirty);
        int n2 = this._fields.length - 1;
        while (n2 >= 0) {
            if (this._fields[n2].store && this._fields[n2].dirtyCheck) {
                if (objectArray[n2] == null) {
                    int n3 = this._fields[n2].columns.length - 1;
                    while (n3 >= 0) {
                        n = this.nextParameter(true, stringBuffer, n);
                        --n3;
                    }
                } else if (objectArray[n2] instanceof Complex) {
                    Complex complex = (Complex)objectArray[n2];
                    if (complex.size() != this._fields[n2].columns.length) {
                        throw new PersistenceException("Size of complex field mismatch!");
                    }
                    int n4 = this._fields[n2].columns.length - 1;
                    while (n4 >= 0) {
                        n = this.nextParameter(complex.get(n4) == null, stringBuffer, n);
                        --n4;
                    }
                } else {
                    if (this._fields[n2].columns.length != 1) {
                        throw new PersistenceException("Complex field expected! ");
                    }
                    n = this.nextParameter(false, stringBuffer, n);
                }
            }
            --n2;
        }
        return stringBuffer.toString();
    }

    private Object idToJava(int n, Object object) throws PersistenceException {
        if (object == null || this._ids[n].convertTo == null) {
            return object;
        }
        return this._ids[n].convertTo.convert(object, this._ids[n].convertParam);
    }

    private Object idToSQL(int n, Object object) throws PersistenceException {
        if (object == null || this._ids[n].convertFrom == null) {
            return object;
        }
        return this._ids[n].convertFrom.convert(object, this._ids[n].convertParam);
    }

    public Object load(Object object, Object[] objectArray, Object object2, AccessMode accessMode) throws ObjectNotFoundException, PersistenceException {
        Object var7_5 = null;
        try {
            boolean bl;
            int n;
            Object[] objectArray2;
            PreparedStatement preparedStatement = ((Connection)object).prepareStatement(accessMode == AccessMode.DbLocked ? this._sqlLoadLock : this._sqlLoad);
            int n2 = 1;
            if (object2 instanceof Complex) {
                objectArray2 = (Object[])object2;
                if (objectArray2.size() != this._ids.length || this._ids.length <= 1) {
                    throw new PersistenceException("Size of complex field mismatched! expected: " + this._ids.length + " found: " + objectArray2.size());
                }
                n = 0;
                while (n < this._ids.length) {
                    preparedStatement.setObject(n2++, this.idToSQL(n, objectArray2.get(n)));
                    ++n;
                }
            } else {
                if (this._ids.length != 1) {
                    throw new PersistenceException("Complex field expected!");
                }
                preparedStatement.setObject(n2++, this.idToSQL(0, object2));
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                throw new ObjectNotFoundException(Messages.format("persist.objectNotFound", this._clsDesc.getJavaClass().getName(), object2));
            }
            n2 = 1;
            objectArray2 = new Object[10];
            n = 0;
            while (n < this._fields.length) {
                if (this._fields[n].load) {
                    if (!this._fields[n].multi) {
                        bl = false;
                        if (this._fields[n].columns.length == 1) {
                            objectArray[n] = this.toJava(n, 0, SQLTypes.getObject(resultSet, n2++, this._fields[n].columns[0].sqlType));
                        } else {
                            int n3 = 0;
                            while (n3 < this._fields[n].columns.length) {
                                objectArray2[n3] = this.toJava(n, n3, SQLTypes.getObject(resultSet, n2++, this._fields[n].columns[n3].sqlType));
                                if (objectArray2[n3] != null) {
                                    bl = true;
                                }
                                ++n3;
                            }
                            objectArray[n] = bl ? new Complex(this._fields[n].columns.length, objectArray2) : null;
                        }
                    } else {
                        ArrayList<Object> arrayList = new ArrayList<Object>();
                        bl = false;
                        int n4 = 0;
                        while (n4 < this._fields[n].columns.length) {
                            objectArray2[n4] = this.toJava(n, n4, SQLTypes.getObject(resultSet, n2, this._fields[n].columns[n4].sqlType));
                            if (objectArray2[n4] != null) {
                                bl = true;
                            }
                            ++n2;
                            ++n4;
                        }
                        if (bl) {
                            if (this._fields[n].columns.length == 1) {
                                arrayList.add(objectArray2[0]);
                            } else {
                                arrayList.add(new Complex(this._fields[n].columns.length, objectArray2));
                            }
                        }
                        objectArray[n] = arrayList;
                    }
                }
                ++n;
            }
            while (resultSet.next()) {
                n2 = 1;
                int n5 = 0;
                while (n5 < this._fields.length) {
                    if (this._fields[n5].load) {
                        if (this._fields[n5].multi) {
                            ArrayList arrayList = (ArrayList)objectArray[n5];
                            bl = false;
                            int n6 = 0;
                            while (n6 < this._fields[n5].columns.length) {
                                objectArray2[n6] = this.toJava(n5, n6, SQLTypes.getObject(resultSet, n2, this._fields[n5].columns[n6].sqlType));
                                if (objectArray2[n6] != null) {
                                    bl = true;
                                }
                                ++n2;
                                ++n6;
                            }
                            if (bl) {
                                if (this._fields[n5].columns.length == 1) {
                                    if (!arrayList.contains(objectArray2[0])) {
                                        arrayList.add(objectArray2[0]);
                                    }
                                } else {
                                    Complex complex = new Complex(this._fields[n5].columns.length, objectArray2);
                                    if (!arrayList.contains(complex)) {
                                        arrayList.add(new Complex(this._fields[n5].columns.length, objectArray2));
                                    }
                                }
                            }
                        } else {
                            n2 += this._fields[n5].columns.length;
                        }
                    }
                    ++n5;
                }
            }
            resultSet.close();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new PersistenceException(Messages.format("persist.nested", sQLException), sQLException);
        }
        return var7_5;
    }

    private int nextParameter(boolean bl, StringBuffer stringBuffer, int n) {
        while (n > 0) {
            if (stringBuffer.charAt(n - 1) == '=' && stringBuffer.charAt(n) == '?') break;
            --n;
        }
        if (n > 0) {
            --n;
            if (bl) {
                stringBuffer.delete(n, n + 2);
                stringBuffer.insert(n, " IS NULL");
            }
        }
        return n;
    }

    public String quoteName(String string) {
        return this._factory.quoteName(string);
    }

    public void setExtends(SQLEngine sQLEngine) {
        this._extends = sQLEngine;
    }

    public Object store(Object object, Object[] objectArray, Object object2, Object[] objectArray2, Object object3) throws ObjectModifiedException, ObjectDeletedException, PersistenceException {
        Statement statement = null;
        try {
            int n;
            if (this._extends != null && !this._extends._mapTo.equals(this._mapTo)) {
                this._extends.store(object, objectArray, object2, objectArray2, object3);
            }
            statement = ((Connection)object).prepareStatement(this.getStoreStatement(objectArray2));
            int n2 = 1;
            int n3 = 0;
            while (n3 < this._fields.length) {
                if (this._fields[n3].store) {
                    if (objectArray[n3] == null) {
                        int n4 = 0;
                        while (n4 < this._fields[n3].columns.length) {
                            statement.setNull(n2++, this._fields[n3].columns[n4].sqlType);
                            ++n4;
                        }
                    } else if (objectArray[n3] instanceof Complex) {
                        Complex complex = (Complex)objectArray[n3];
                        if (complex.size() != this._fields[n3].columns.length) {
                            throw new PersistenceException("Size of complex field mismatch!");
                        }
                        n = 0;
                        while (n < this._fields[n3].columns.length) {
                            SQLTypes.setObject((PreparedStatement)statement, n2++, this.toSQL(n3, n, complex.get(n)), this._fields[n3].columns[n].sqlType);
                            ++n;
                        }
                    } else {
                        if (this._fields[n3].columns.length != 1) {
                            throw new PersistenceException("Complex field expected! ");
                        }
                        SQLTypes.setObject((PreparedStatement)statement, n2++, this.toSQL(n3, 0, objectArray[n3]), this._fields[n3].columns[0].sqlType);
                    }
                }
                ++n3;
            }
            if (object2 instanceof Complex) {
                Complex complex = (Complex)object2;
                if (complex.size() != this._ids.length || this._ids.length <= 1) {
                    throw new PersistenceException("Size of complex field mismatched!");
                }
                n = 0;
                while (n < this._ids.length) {
                    statement.setObject(n2++, this.idToSQL(n, complex.get(n)));
                    ++n;
                }
            } else {
                if (this._ids.length != 1) {
                    throw new PersistenceException("Complex field expected!");
                }
                statement.setObject(n2++, this.idToSQL(0, object2));
            }
            if (objectArray2 != null) {
                boolean bl = ((BaseFactory)this._factory).supportsSetNullInWhere();
                n = 0;
                while (n < this._fields.length) {
                    if (this._fields[n].store && this._fields[n].dirtyCheck) {
                        if (objectArray2[n] == null) {
                            if (bl) {
                                int n5 = 0;
                                while (n5 < this._fields[n].columns.length) {
                                    statement.setNull(n2++, this._fields[n].columns[n5].sqlType);
                                    ++n5;
                                }
                            }
                        } else if (objectArray2[n] instanceof Complex) {
                            Complex complex = (Complex)objectArray2[n];
                            if (complex.size() != this._fields[n].columns.length) {
                                throw new PersistenceException("Size of complex field mismatch!");
                            }
                            int n6 = 0;
                            while (n6 < this._fields[n].columns.length) {
                                SQLTypes.setObject((PreparedStatement)statement, n2++, this.toSQL(n, n6, complex.get(n6)), this._fields[n].columns[n6].sqlType);
                                ++n6;
                            }
                        } else {
                            if (this._fields[n].columns.length != 1) {
                                throw new PersistenceException("Complex field expected! ");
                            }
                            SQLTypes.setObject((PreparedStatement)statement, n2++, this.toSQL(n, 0, objectArray2[n]), this._fields[n].columns[0].sqlType);
                        }
                    }
                    ++n;
                }
            }
            if (statement.executeUpdate() <= 0) {
                statement.close();
                if (objectArray2 != null) {
                    statement = ((Connection)object).prepareStatement(this._sqlLoad);
                    n2 = 1;
                    if (object2 instanceof Complex) {
                        Complex complex = (Complex)object2;
                        n = 0;
                        while (n < this._ids.length) {
                            statement.setObject(n2++, this.idToSQL(n, complex.get(n)));
                            ++n;
                        }
                    } else {
                        statement.setObject(n2++, this.idToSQL(0, object2));
                    }
                    ResultSet resultSet = statement.executeQuery();
                    n = resultSet.getMetaData().getColumnCount();
                    if (resultSet.next()) {
                        statement.close();
                        throw new ObjectModifiedException(Messages.format("persist.objectModified", this._clsDesc.getJavaClass().getName(), object2));
                    }
                    statement.close();
                }
                throw new ObjectDeletedException(Messages.format("persist.objectDeleted", this._clsDesc.getJavaClass().getName(), object2));
            }
            statement.close();
            return null;
        }
        catch (SQLException sQLException) {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException2) {}
            throw new PersistenceException(Messages.format("persist.nested", sQLException), sQLException);
        }
    }

    private Object toJava(int n, int n2, Object object) throws PersistenceException {
        ColumnInfo columnInfo = this._fields[n].columns[n2];
        if (object == null || columnInfo.convertTo == null) {
            return object;
        }
        return columnInfo.convertTo.convert(object, columnInfo.convertParam);
    }

    private Object toSQL(int n, int n2, Object object) throws PersistenceException {
        ColumnInfo columnInfo = this._fields[n].columns[n2];
        if (object == null || columnInfo.convertFrom == null) {
            return object;
        }
        return columnInfo.convertFrom.convert(object, columnInfo.convertParam);
    }

    public String toString() {
        return this._clsDesc.toString();
    }

    public void writeLock(Object object, Object object2) throws ObjectDeletedException, PersistenceException {
        Statement statement = null;
        try {
            if (this._extends != null) {
                this._extends.writeLock(object, object2);
            }
            statement = ((Connection)object).prepareStatement(this._pkLookup);
            int n = 1;
            if (object2 instanceof Complex) {
                Complex complex = (Complex)object2;
                if (complex.size() != this._ids.length || this._ids.length <= 1) {
                    throw new PersistenceException("Size of complex field mismatched!");
                }
                int n2 = 0;
                while (n2 < this._ids.length) {
                    statement.setObject(n++, this.idToSQL(n2, complex.get(n2)));
                    ++n2;
                }
            } else {
                if (this._ids.length != 1) {
                    throw new PersistenceException("Complex field expected!");
                }
                statement.setObject(n++, this.idToSQL(0, object2));
            }
            if (!statement.executeQuery().next()) {
                throw new ObjectDeletedException(Messages.format("persist.objectDeleted", this._clsDesc.getJavaClass().getName(), object2));
            }
            statement.close();
        }
        catch (SQLException sQLException) {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException2) {}
            throw new PersistenceException(Messages.format("persist.nested", sQLException), sQLException);
        }
    }

    static final class FieldInfo
    implements Persistence.FieldInfo {
        final String tableName;
        final String jdoName;
        final boolean load;
        final boolean store;
        final boolean multi;
        final boolean joined;
        final boolean dirtyCheck;
        final String[] joinFields;
        ColumnInfo[] columns;

        FieldInfo(JDOClassDescriptor jDOClassDescriptor, FieldDescriptor fieldDescriptor, String string, boolean bl) throws MappingException {
            boolean bl2 = false;
            boolean bl3 = true;
            int n = 2;
            FieldDescriptor[] fieldDescriptorArray = jDOClassDescriptor.getIdentities();
            ClassDescriptor classDescriptor = fieldDescriptor.getClassDescriptor();
            if (classDescriptor != null && !(classDescriptor instanceof JDOClassDescriptor)) {
                throw new MappingException("Related class is not JDOClassDescriptor");
            }
            if (fieldDescriptor.getClassDescriptor() != null) {
                int n2 = !(fieldDescriptor instanceof JDOFieldDescriptor) ? 1 : (((JDOFieldDescriptor)fieldDescriptor).getManyTable() != null ? 2 : (((JDOFieldDescriptor)fieldDescriptor).getSQLName() != null ? 0 : 1));
                FieldDescriptor[] fieldDescriptorArray2 = ((JDOClassDescriptor)classDescriptor).getIdentities();
                String[] stringArray = null;
                if (fieldDescriptor instanceof JDOFieldDescriptor) {
                    stringArray = ((JDOFieldDescriptor)fieldDescriptor).getSQLName();
                }
                String[] stringArray2 = new String[fieldDescriptorArray2.length];
                int n3 = 0;
                while (n3 < fieldDescriptorArray2.length) {
                    stringArray2[n3] = ((JDOFieldDescriptor)fieldDescriptorArray2[n3]).getSQLName()[0];
                    if (stringArray2[n3] == null) {
                        throw new MappingException("Related class identities field does not contains sql information!");
                    }
                    ++n3;
                }
                String[] stringArray3 = null;
                if (fieldDescriptor instanceof JDOFieldDescriptor) {
                    stringArray3 = ((JDOFieldDescriptor)fieldDescriptor).getManyKey();
                }
                String[] stringArray4 = new String[fieldDescriptorArray.length];
                int n4 = 0;
                while (n4 < fieldDescriptorArray.length) {
                    stringArray4[n4] = ((JDOFieldDescriptor)fieldDescriptorArray[n4]).getSQLName()[0];
                    if (stringArray4[n4] == null) {
                        throw new MappingException("Related class identities field does not contains sql information!");
                    }
                    ++n4;
                }
                if (stringArray != null && stringArray.length != fieldDescriptorArray2.length) {
                    throw new MappingException("The number of column of foreign keys doesn't not match with what specified in manyKey");
                }
                if (stringArray3 != null && stringArray3.length != fieldDescriptorArray.length) {
                    throw new MappingException("The number of column of foreign keys doesn't not match with what specified in manyKey");
                }
                switch (n2) {
                    case 0: {
                        this.tableName = string;
                        this.jdoName = fieldDescriptor.getFieldName();
                        this.load = true;
                        this.store = bl ^ true;
                        this.multi = false;
                        this.joined = false;
                        this.dirtyCheck = ((JDOFieldDescriptor)fieldDescriptor).isDirtyCheck();
                        stringArray = stringArray != null ? stringArray : stringArray2;
                        this.joinFields = stringArray4;
                        break;
                    }
                    case 1: {
                        this.tableName = ((JDOClassDescriptor)classDescriptor).getTableName();
                        this.jdoName = fieldDescriptor.getFieldName();
                        this.load = true;
                        this.store = false;
                        this.multi = fieldDescriptor.isMultivalued();
                        this.joined = true;
                        this.dirtyCheck = fieldDescriptor instanceof JDOFieldDescriptor ? ((JDOFieldDescriptor)fieldDescriptor).isDirtyCheck() : true;
                        stringArray = stringArray != null ? stringArray : stringArray2;
                        this.joinFields = stringArray3 != null ? stringArray3 : stringArray4;
                        break;
                    }
                    case 2: {
                        this.tableName = ((JDOFieldDescriptor)fieldDescriptor).getManyTable();
                        this.jdoName = fieldDescriptor.getFieldName();
                        this.load = true;
                        this.store = false;
                        this.multi = fieldDescriptor.isMultivalued();
                        this.joined = true;
                        this.dirtyCheck = ((JDOFieldDescriptor)fieldDescriptor).isDirtyCheck();
                        stringArray = stringArray != null ? stringArray : stringArray2;
                        this.joinFields = stringArray3 != null ? stringArray3 : stringArray4;
                        break;
                    }
                    default: {
                        throw new MappingException("Never happen! But, it won't compile without the exception");
                    }
                }
                this.columns = new ColumnInfo[fieldDescriptorArray2.length];
                int n5 = 0;
                while (n5 < fieldDescriptorArray2.length) {
                    if (!(fieldDescriptorArray2[n5] instanceof JDOFieldDescriptor)) {
                        throw new MappingException("Related class identities field does not contains sql information!");
                    }
                    JDOFieldDescriptor jDOFieldDescriptor = (JDOFieldDescriptor)fieldDescriptorArray2[n5];
                    FieldHandlerImpl fieldHandlerImpl = (FieldHandlerImpl)jDOFieldDescriptor.getHandler();
                    this.columns[n5] = new ColumnInfo(stringArray[n5], jDOFieldDescriptor.getSQLType()[0], fieldHandlerImpl.getConvertTo(), fieldHandlerImpl.getConvertFrom(), fieldHandlerImpl.getConvertParam());
                    ++n5;
                }
            } else {
                this.tableName = string;
                this.jdoName = fieldDescriptor.getFieldName();
                this.load = true;
                this.store = bl ^ true;
                this.multi = false;
                this.joined = false;
                this.joinFields = null;
                this.dirtyCheck = ((JDOFieldDescriptor)fieldDescriptor).isDirtyCheck();
                FieldHandlerImpl fieldHandlerImpl = (FieldHandlerImpl)fieldDescriptor.getHandler();
                this.columns = new ColumnInfo[1];
                String[] stringArray = ((JDOFieldDescriptor)fieldDescriptor).getSQLName();
                String string2 = stringArray == null ? fieldDescriptor.getFieldName() : stringArray[0];
                this.columns[0] = new ColumnInfo(string2, ((JDOFieldDescriptor)fieldDescriptor).getSQLType()[0], fieldHandlerImpl.getConvertTo(), fieldHandlerImpl.getConvertFrom(), fieldHandlerImpl.getConvertParam());
            }
        }

        public String getFieldName() {
            return this.jdoName;
        }

        public boolean isComplex() {
            return true;
        }

        public boolean isPersisted() {
            return this.store;
        }

        public String toString() {
            return String.valueOf(this.tableName) + "." + this.jdoName;
        }
    }

    static final class ColumnInfo {
        final String name;
        final int sqlType;
        final TypeConvertor convertTo;
        final TypeConvertor convertFrom;
        final String convertParam;

        ColumnInfo(String string, int n, TypeConvertor typeConvertor, TypeConvertor typeConvertor2, String string2) {
            this.name = string;
            this.sqlType = n;
            this.convertTo = typeConvertor;
            this.convertFrom = typeConvertor2;
            this.convertParam = string2;
        }
    }

    static final class SQLQuery
    implements PersistenceQuery {
        private PreparedStatement _stmt;
        private ResultSet _rs;
        private final SQLEngine _engine;
        private final Class[] _types;
        private final Object[] _values;
        private final String _sql;
        private Object[] _lastIdentity;
        private int[] _identSqlType;
        private boolean _resultSetDone;
        private Object[] _fields;

        SQLQuery(SQLEngine sQLEngine, String string, Class[] classArray) {
            this._engine = sQLEngine;
            this._types = classArray;
            this._values = new Object[this._types.length];
            this._sql = string;
            this._identSqlType = new int[this._engine._clsDesc.getIdentities().length];
            int n = 0;
            while (n < this._identSqlType.length) {
                this._identSqlType[n] = ((JDOFieldDescriptor)this._engine._clsDesc.getIdentities()[n]).getSQLType()[0];
                ++n;
            }
        }

        public void close() {
            if (this._rs != null) {
                try {
                    this._rs.close();
                }
                catch (SQLException sQLException) {}
                this._rs = null;
            }
            if (this._stmt != null) {
                try {
                    this._stmt.close();
                }
                catch (SQLException sQLException) {}
                this._stmt = null;
            }
        }

        public void execute(Object object, AccessMode accessMode) throws QueryException, PersistenceException {
            this._lastIdentity = null;
            try {
                this._stmt = ((Connection)object).prepareStatement(this._sql);
                int n = 0;
                while (n < this._values.length) {
                    this._stmt.setObject(n + 1, this._values[n]);
                    this._values[n] = null;
                    ++n;
                }
                this._rs = this._stmt.executeQuery();
                this._resultSetDone = false;
            }
            catch (SQLException sQLException) {
                if (this._stmt != null) {
                    try {
                        this._stmt.close();
                    }
                    catch (SQLException sQLException2) {}
                }
                this._resultSetDone = true;
                throw new PersistenceException(String.valueOf(Messages.format("persist.nested", sQLException)) + " while executing " + this._sql, sQLException);
            }
        }

        public Object fetch(Object[] objectArray, Object object) throws ObjectNotFoundException, PersistenceException {
            int n = 0;
            while (n < this._fields.length) {
                objectArray[n] = this._fields[n];
                ++n;
            }
            return null;
        }

        private Object fetchRaw(Object object) throws ObjectNotFoundException, PersistenceException {
            if (this._fields == null) {
                this._fields = new Object[this._engine._fields.length];
            }
            if (this._resultSetDone) {
                return null;
            }
            Object var2_2 = null;
            try {
                Object[] objectArray = object != null ? this.identityToSQL(object) : this.loadSQLIdentity();
                this.loadRow(this._fields, true);
                while (this._rs.next()) {
                    Object[] objectArray2 = this.loadSQLIdentity();
                    if (this.identitiesEqual(objectArray, objectArray2)) {
                        this.loadRow(this._fields, false);
                        continue;
                    }
                    this._lastIdentity = objectArray2;
                    return var2_2;
                }
                this._resultSetDone = true;
                this._lastIdentity = null;
            }
            catch (SQLException sQLException) {
                throw new PersistenceException(Messages.format("persist.nested", sQLException), sQLException);
            }
            return null;
        }

        public int getParameterCount() {
            return this._types.length;
        }

        public Class getParameterType(int n) throws ArrayIndexOutOfBoundsException {
            return this._types[n];
        }

        public Class getResultType() {
            return this._engine._clsDesc.getJavaClass();
        }

        private boolean identitiesEqual(Object[] objectArray, Object[] objectArray2) {
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] == null || objectArray2[n] == null ? objectArray[n] != objectArray2[n] : !objectArray[n].toString().equals(objectArray2[n].toString())) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        private Object[] identityToSQL(Object object) {
            Object[] objectArray = new Object[this._engine._ids.length];
            if (object != null) {
                if (this._engine._ids.length > 1) {
                    Complex complex = (Complex)object;
                    int n = 0;
                    while (n < this._engine._ids.length) {
                        objectArray[n] = complex.get(n);
                        ++n;
                    }
                } else {
                    objectArray[0] = object;
                }
            }
            return objectArray;
        }

        private Object loadIdentity() throws SQLException, PersistenceException {
            if (this._resultSetDone) {
                return null;
            }
            boolean bl = false;
            Object[] objectArray = new Object[this._engine._ids.length];
            bl = true;
            int n = 0;
            while (n < this._engine._ids.length) {
                Object object = SQLTypes.getObject(this._rs, 1 + n, this._identSqlType[n]);
                objectArray[n] = this._engine.idToJava(n, object);
                if (object != null) {
                    bl = false;
                }
                ++n;
            }
            if (!bl) {
                switch (this._engine._ids.length) {
                    case 1: {
                        return objectArray[0];
                    }
                    case 2: {
                        return new Complex(objectArray[0], objectArray[1]);
                    }
                }
                return new Complex(objectArray);
            }
            return null;
        }

        private Object loadMultiField(int n, int n2, Object object) throws SQLException, PersistenceException {
            Object[] objectArray = new Object[10];
            boolean bl = false;
            ArrayList<Object> arrayList = object == null ? new ArrayList<Object>() : (ArrayList<Object>)object;
            int n3 = 0;
            while (n3 < ((SQLEngine)this._engine)._fields[n].columns.length) {
                objectArray[n3] = this._engine.toJava(n, n3, SQLTypes.getObject(this._rs, n2, ((SQLEngine)this._engine)._fields[n].columns[n3].sqlType));
                if (objectArray[n3] != null) {
                    bl = true;
                }
                ++n2;
                ++n3;
            }
            if (bl) {
                if (((SQLEngine)this._engine)._fields[n].columns.length == 1) {
                    if (!arrayList.contains(objectArray[0])) {
                        arrayList.add(objectArray[0]);
                    }
                } else {
                    Complex complex = new Complex(((SQLEngine)this._engine)._fields[n].columns.length, objectArray);
                    if (!arrayList.contains(complex)) {
                        arrayList.add(complex);
                    }
                }
            }
            return arrayList;
        }

        private int loadRow(Object[] objectArray, boolean bl) throws SQLException, PersistenceException {
            int n = this._engine._ids.length + 1;
            int n2 = 0;
            while (n2 < this._engine._fields.length) {
                if (((SQLEngine)this._engine)._fields[n2].load) {
                    if (((SQLEngine)this._engine)._fields[n2].multi) {
                        objectArray[n2] = this.loadMultiField(n2, n, objectArray[n2]);
                    } else if (bl) {
                        objectArray[n2] = this.loadSingleField(n2, n);
                    }
                    n += ((SQLEngine)this._engine)._fields[n2].columns.length;
                }
                ++n2;
            }
            return n;
        }

        private Object[] loadSQLIdentity() throws SQLException, PersistenceException {
            Object[] objectArray = new Object[this._engine._ids.length];
            int n = 0;
            while (n < this._engine._ids.length) {
                objectArray[n] = SQLTypes.getObject(this._rs, 1 + n, this._identSqlType[n]);
                ++n;
            }
            return objectArray;
        }

        private Object loadSingleField(int n, int n2) throws SQLException, PersistenceException {
            Object object;
            Object[] objectArray = new Object[10];
            boolean bl = false;
            if (((SQLEngine)this._engine)._fields[n].columns.length == 1) {
                object = this._engine.toJava(n, 0, SQLTypes.getObject(this._rs, n2++, ((SQLEngine)this._engine)._fields[n].columns[0].sqlType));
            } else {
                int n3 = 0;
                while (n3 < ((SQLEngine)this._engine)._fields[n].columns.length) {
                    objectArray[n3] = this._engine.toJava(n, n3, SQLTypes.getObject(this._rs, n2++, ((SQLEngine)this._engine)._fields[n].columns[n3].sqlType));
                    if (objectArray[n3] != null) {
                        bl = true;
                    }
                    ++n3;
                }
                object = bl ? new Complex(((SQLEngine)this._engine)._fields[n].columns.length, objectArray) : null;
            }
            return object;
        }

        public Object nextIdentity(Object object) throws PersistenceException {
            try {
                if (this._lastIdentity == null && !this._rs.next()) {
                    this._resultSetDone = true;
                    return null;
                }
                this._lastIdentity = this.identityToSQL(object);
                object = this.loadIdentity();
                if (this.identitiesEqual(this._lastIdentity, this.identityToSQL(object))) {
                    this.fetchRaw(null);
                }
                object = this.loadIdentity();
                this.fetchRaw(null);
            }
            catch (SQLException sQLException) {
                this._lastIdentity = null;
                throw new PersistenceException(Messages.format("persist.nested", sQLException), sQLException);
            }
            return object;
        }

        public void setParameter(int n, Object object) throws ArrayIndexOutOfBoundsException, IllegalArgumentException {
            this._values[n] = object;
        }
    }
}

