/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.util;

import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.ValidationException;

public final class ComponentValidator {
    private static final String ASSERT_NONE_MESSAGE = "Component [{0}] is not applicable";
    private static final String ASSERT_ONE_OR_LESS_MESSAGE = "Component [{0}] must only be specified once";

    private ComponentValidator() {
    }

    public static void assertNone(String componentName, ComponentList components) throws ValidationException {
        if (components.getComponent(componentName) != null) {
            throw new ValidationException(ASSERT_NONE_MESSAGE, new Object[]{componentName});
        }
    }

    public static void assertOneOrLess(String componentName, ComponentList components) throws ValidationException {
        if (components.getComponents(componentName).size() > 1) {
            throw new ValidationException(ASSERT_ONE_OR_LESS_MESSAGE, new Object[]{componentName});
        }
    }
}

