/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.todo;

import com.aimluck.eip.cayenne.om.portlet.EipTTodo;
import com.aimluck.eip.common.ALAbstractCheckList;
import com.aimluck.eip.common.ALPermissionException;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ToDoMultiDelete
extends ALAbstractCheckList {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ToDoMultiDelete.class.getName());
    private String aclPortletFeature;

    protected boolean doCheckAclPermission(RunData rundata, Context context, int defineAclType) throws ALPermissionException {
        ArrayList<String> values = new ArrayList<String>();
        Object[] objs = rundata.getParameters().getKeys();
        int length = objs.length;
        for (int i = 0; i < length; ++i) {
            if (!objs[i].toString().startsWith("check")) continue;
            String str = rundata.getParameters().getString(objs[i].toString());
            values.add(str);
        }
        Expression exp1 = ExpressionFactory.noMatchDbExp((String)"USER_ID", (Object)ALEipUtils.getUserId((RunData)rundata));
        Expression exp2 = ExpressionFactory.inDbExp((String)"TODO_ID", values);
        this.aclPortletFeature = Database.query(EipTTodo.class).andQualifier(exp1).andQualifier(exp2).getCount() > 0 ? "todo_todo_other" : "todo_todo_self";
        return super.doCheckAclPermission(rundata, context, defineAclType);
    }

    protected boolean action(RunData rundata, Context context, List<String> values, List<String> msgList) {
        try {
            Expression exp1 = ExpressionFactory.inDbExp((String)"TODO_ID", values);
            List todoList = Database.query(EipTTodo.class, (Expression)exp1).fetchList();
            if (todoList == null || todoList.size() == 0) {
                return false;
            }
            for (EipTTodo todo : todoList) {
                Integer entityId = todo.getTodoId();
                String todoName = todo.getTodoName();
                Database.delete((Persistent)todo);
                Database.commit();
                ALEventlogFactoryService.getInstance().getEventlogHandler().log(entityId.intValue(), 130, todoName);
            }
        }
        catch (Throwable t) {
            Database.rollback();
            logger.error((Object)"[ToDoMultiDelete]", t);
            return false;
        }
        return true;
    }

    protected int getDefineAclType() {
        return 16;
    }

    public String getAclPortletFeature() {
        return this.aclPortletFeature;
    }
}

