/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.cache.disk;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.jetspeed.cache.disk.DiskCacheEntry;
import org.apache.jetspeed.cache.disk.DiskCacheUtils;
import org.apache.jetspeed.cache.disk.JetspeedDiskCache;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.urlmanager.URLFetcher;
import org.apache.jetspeed.util.URIEncoder;

public class JetspeedDiskCacheEntry
implements DiskCacheEntry {
    private static long defaultExpirationInterval = 1000 * JetspeedResources.getInt("cache.default.expiration", 900);
    static String encoding = JetspeedResources.getString("content.defaultencoding", "iso-8859-1");
    private File file = null;
    private String url = null;
    private String sourceURL = null;
    private long lastModified = 0L;
    private long expires = 0L;
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(JetspeedDiskCacheEntry.class.getName());

    protected JetspeedDiskCacheEntry(File file) {
        this.setFile(file);
        this.setURL(this.getSourceURL());
    }

    public JetspeedDiskCacheEntry(String url) {
        this.setURL(url);
        this.init();
    }

    public void init() {
        URL url = null;
        try {
            url = new URL(this.getURL());
        }
        catch (MalformedURLException e) {
            logger.error("Error in URL", e);
            return;
        }
        if ((this.file == null || !this.file.exists()) && "file".equals(url.getProtocol())) {
            try {
                File newfile = new File(url.getFile());
                this.setFile(newfile);
                if (!newfile.exists()) {
                    JetspeedDiskCache.getInstance().add(this.getURL(), true);
                }
            }
            catch (IOException e) {
                logger.error("Error building from file", e);
                return;
            }
        }
    }

    public String getURL() {
        return this.url;
    }

    public String getSourceURL() {
        if (this.getFile() == null) {
            return this.getURL();
        }
        return URIEncoder.decode(this.getFile().getName());
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        if (!file.exists()) {
            String message = "The following file does not exist: " + file.getAbsolutePath();
            logger.error(message);
            try {
                JetspeedDiskCache.getInstance().add(this.url, true);
            }
            catch (Throwable e) {
                logger.error("Error setting file", e);
            }
        }
        this.file = file;
        this.lastModified = file.lastModified();
        this.expires = System.currentTimeMillis() + defaultExpirationInterval;
    }

    public String getData() throws IOException {
        Reader is = this.getReader();
        StringWriter bos = new StringWriter();
        char[] chars = new char[200];
        int readCount = 0;
        while ((readCount = is.read(chars)) > 0) {
            bos.write(chars, 0, readCount);
        }
        is.close();
        return bos.toString();
    }

    public InputStream getInputStream() throws IOException {
        logger.info("CacheEntry getInputStream() called: " + this.getURL());
        if (this.getFile() != null) {
            return new FileInputStream(this.getFile());
        }
        if (DiskCacheUtils.isLocal(this.getURL())) {
            return new URL(this.getURL()).openConnection().getInputStream();
        }
        this.lastModified = 0L;
        this.expires = 0L;
        URLFetcher.refresh(this.getURL());
        if (this.getFile() != null) {
            return new FileInputStream(this.getFile());
        }
        throw new IOException(this.getURL() + ": is not in cache after forcing");
    }

    public Reader getReader() throws IOException {
        if (DiskCacheUtils.isLocal(this.getURL())) {
            URLConnection conn = new URL(this.getURL()).openConnection();
            String encoding = conn.getContentEncoding();
            if (encoding == null) {
                encoding = JetspeedResources.getString("content.defaultencoding", "iso-8859-1");
            }
            return new InputStreamReader(conn.getInputStream(), encoding);
        }
        if (this.getFile() != null) {
            InputStreamReader reader = null;
            try {
                reader = new InputStreamReader((InputStream)new FileInputStream(this.getFile()), "UTF8");
            }
            catch (UnsupportedEncodingException e) {
                logger.error("Encoding error", e);
                reader = new FileReader(this.getFile());
            }
            return reader;
        }
        this.lastModified = 0L;
        this.expires = 0L;
        URLFetcher.refresh(this.getURL());
        if (this.getFile() != null) {
            return this.getReader();
        }
        throw new IOException(this.getURL() + ": is not in cache after forcing");
    }

    public Writer getWriter() throws IOException {
        if (DiskCacheUtils.isRemote(this.getURL())) {
            throw new IOException("Cannot write to remote URLs!");
        }
        if (DiskCacheUtils.isLocal(this.getURL())) {
            URL url = new URL(this.getURL());
            if (url.getProtocol().equalsIgnoreCase("http")) {
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setDoOutput(true);
                conn.setRequestMethod("PUT");
                return new HttpURLWriter(conn);
            }
            File file = new File(url.getFile());
            file.getParentFile().mkdirs();
            return new FileURLWriter(file);
        }
        throw new IOException(this.getURL() + ": is not local or remote");
    }

    public long getLastModified() {
        if (this.isLocal()) {
            try {
                String localfile = this.getURL().substring(5);
                this.lastModified = new File(localfile).lastModified();
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Error getLastModified ", e);
                }
                e.printStackTrace();
            }
        }
        return this.lastModified;
    }

    public void setLastModified(long time) {
        this.lastModified = time;
    }

    public void setURL(String url) {
        if (DiskCacheUtils.isVirtual(url)) {
            url = DiskCacheUtils.getLocalURL(url);
        }
        this.url = url;
    }

    public long getExpirationTime() {
        return this.expires;
    }

    public void setExpirationTime(long time) {
        this.expires = time;
        if (this.expires < System.currentTimeMillis()) {
            this.expires = System.currentTimeMillis() + defaultExpirationInterval;
        }
    }

    public boolean hasExpired() {
        return this.expires <= 0L || this.expires < System.currentTimeMillis();
    }

    public boolean isLocal() {
        return DiskCacheUtils.isLocal(this.getSourceURL());
    }

    class FileURLWriter
    extends FileWriter {
        private String filename;

        public FileURLWriter(File file) throws UnsupportedEncodingException, IOException {
            super(file);
            this.filename = file.getPath();
            logger.info("FileURLWriter opening file -> " + this.filename);
        }

        public void close() throws IOException {
            super.close();
            logger.info("FileURLWriter closing file -> " + this.filename);
        }
    }

    class HttpURLWriter
    extends OutputStreamWriter {
        private HttpURLConnection conn;

        public HttpURLWriter(HttpURLConnection conn) throws UnsupportedEncodingException, IOException {
            super(conn.getOutputStream(), encoding);
            this.conn = conn;
            logger.info("HttpURLWriter encoding -> " + encoding + " method -> " + this.conn.getRequestMethod());
        }

        public void close() throws IOException {
            super.close();
            this.conn.getResponseCode();
            logger.info("HttpURLWriter close encoding -> " + encoding + " method -> " + this.conn.getRequestMethod() + " Status -> " + this.conn.getResponseCode());
        }
    }
}

