/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.daemon;

import org.apache.jetspeed.daemon.Daemon;
import org.apache.jetspeed.daemon.DaemonEntry;
import org.apache.jetspeed.daemon.DaemonException;
import org.apache.jetspeed.services.daemonfactory.DaemonFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;

public class DaemonThread
extends Thread {
    private Daemon daemon = null;
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(DaemonThread.class.getName());

    public DaemonThread(DaemonEntry entry) {
        super("DaemonThread:" + entry.getName());
        try {
            this.setDaemon(true);
            this.daemon = DaemonFactory.getDaemon(entry);
            this.setPriority(1);
        }
        catch (DaemonException e) {
            logger.error("Error instantiating DaemonThread", e);
        }
    }

    public DaemonThread() {
        this.setDaemon(true);
    }

    public Daemon getDaemon() {
        return this.daemon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        DaemonEntry de = this.getDaemon().getDaemonEntry();
        logger.info("DaemonThread: started processing daemon " + de.getName());
        if (de.onStartup()) {
            this.runDaemon(this.getDaemon());
        }
        while (true) {
            try {
                de = this.getDaemon().getDaemonEntry();
                DaemonThread daemonThread = this;
                synchronized (daemonThread) {
                    this.wait(de.getInterval() * 1000L);
                }
            }
            catch (InterruptedException e) {
                break;
            }
            if (this.isInterrupted()) break;
            this.runDaemon(this.getDaemon());
        }
    }

    private void runDaemon(Daemon daemon) {
        daemon.setStatus(3);
        logger.info("DaemonThread -> PROCESSING daemon -> " + daemon.getDaemonEntry().getName());
        try {
            daemon.run();
        }
        catch (Throwable t) {
            logger.error("Could not process Daemon: " + daemon.getDaemonEntry().getName(), t);
        }
        logger.info("DaemonThread -> *DONE* PROCESSING daemon -> " + daemon.getDaemonEntry().getName());
        daemon.setStatus(2);
    }
}

