/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.actions.portlets;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.jetspeed.modules.actions.portlets.VelocityPortletAction;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.forward.ForwardService;
import org.apache.jetspeed.services.forward.configuration.Forward;
import org.apache.jetspeed.services.forward.configuration.PortletForward;
import org.apache.jetspeed.util.HtmlItem;
import org.apache.jetspeed.util.PortletConfigState;
import org.apache.jetspeed.util.PortletSessionState;
import org.apache.jetspeed.util.ServiceUtil;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ForwardDemoAction
extends VelocityPortletAction {
    private static final String PARAM_NEXT = "fda_next";
    private static final String PARAM_TARGET = "fda_target";
    private static final String VAR_FORWARDS = "fda_forwards";
    private static final String VAR_TARGETS = "fda_targets";
    private static final String PORTLET_NAME = "ForwardDemo";

    protected void buildNormalContext(VelocityPortlet portlet, Context context, RunData rundata) {
        List portletForwards;
        List forwards;
        String target;
        String next = (String)PortletSessionState.getAttribute(rundata, PARAM_NEXT);
        if (null == next) {
            next = PortletConfigState.getParameter(portlet, rundata, PARAM_NEXT, "NOT_SET");
            PortletSessionState.setAttribute(rundata, PARAM_NEXT, next);
        }
        if (null == (target = (String)PortletSessionState.getAttribute(rundata, PARAM_TARGET))) {
            target = PortletConfigState.getParameter(portlet, rundata, PARAM_TARGET, "NOT_SET");
            PortletSessionState.setAttribute(rundata, PARAM_TARGET, target);
        }
        if (null == (forwards = (List)PortletSessionState.getAttribute(rundata, VAR_FORWARDS))) {
            forwards = this.getAllForwards(next);
            PortletSessionState.setAttribute(rundata, VAR_FORWARDS, forwards);
        }
        if (null == (portletForwards = (List)PortletSessionState.getAttribute(rundata, VAR_TARGETS))) {
            portletForwards = this.getPortletForwards(target);
            PortletSessionState.setAttribute(rundata, VAR_TARGETS, portletForwards);
        }
        context.put(VAR_FORWARDS, (Object)forwards);
        context.put(PARAM_NEXT, (Object)next);
        context.put(VAR_TARGETS, (Object)portletForwards);
        context.put(PARAM_TARGET, (Object)target);
    }

    public void doUpdate(RunData rundata, Context context) {
        String next = rundata.getParameters().getString(PARAM_NEXT);
        if (next != null) {
            PortletSessionState.setAttribute(rundata, PARAM_NEXT, next);
            List forwards = (List)PortletSessionState.getAttribute(rundata, VAR_FORWARDS);
            if (forwards != null) {
                for (HtmlItem item : forwards) {
                    if (item.getName().equals(next)) {
                        item.setSelected(true);
                        continue;
                    }
                    item.setSelected(false);
                }
            }
            ForwardService forward = (ForwardService)ServiceUtil.getServiceByName("ForwardService");
            forward.forward(rundata, next);
        }
    }

    private List getAllForwards(String next) {
        ForwardService fs = (ForwardService)ServiceUtil.getServiceByName("ForwardService");
        LinkedList<HtmlItem> vList = new LinkedList<HtmlItem>();
        Iterator it = fs.getForwards().iterator();
        int index = 1;
        while (it.hasNext()) {
            Forward forward = (Forward)it.next();
            boolean selected = forward.getName().equals(next);
            vList.add(new HtmlItem(index, forward.getName(), selected));
            ++index;
        }
        return vList;
    }

    public void doTarget(RunData rundata, Context context) {
        String target = rundata.getParameters().getString(PARAM_TARGET);
        if (target != null) {
            PortletSessionState.setAttribute(rundata, PARAM_TARGET, target);
            List forwards = (List)PortletSessionState.getAttribute(rundata, VAR_TARGETS);
            if (forwards != null) {
                for (HtmlItem item : forwards) {
                    if (item.getName().equals(target)) {
                        item.setSelected(true);
                        continue;
                    }
                    item.setSelected(false);
                }
            }
            ForwardService fs = (ForwardService)ServiceUtil.getServiceByName("ForwardService");
            fs.forward(rundata, PORTLET_NAME, target);
        }
    }

    private List getPortletForwards(String target) {
        ForwardService fs = (ForwardService)ServiceUtil.getServiceByName("ForwardService");
        LinkedList<HtmlItem> vList = new LinkedList<HtmlItem>();
        Iterator it = fs.getPortletForwards().iterator();
        int index = 1;
        while (it.hasNext()) {
            PortletForward forward = (PortletForward)it.next();
            boolean selected = forward.getTarget().equals(target);
            vList.add(new HtmlItem(index, forward.getTarget(), selected));
            ++index;
        }
        return vList;
    }

    public void doDynamic(RunData rundata, Context context) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("dynamic", "33");
        ForwardService fs = (ForwardService)ServiceUtil.getServiceByName("ForwardService");
        fs.forwardDynamic(rundata, "ApacheGroupNews", map);
    }

    public void doDynamic2(RunData rundata, Context context) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("dynamic", "44");
        map.put("msgok", "no");
        map.put("msg", "3");
        ForwardService fs = (ForwardService)ServiceUtil.getServiceByName("ForwardService");
        fs.forwardDynamic(rundata, PORTLET_NAME, "Success", map);
    }
}

