/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.actions.portlets;

import org.apache.jetspeed.modules.actions.portlets.PortletAction;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletInstance;
import org.apache.jetspeed.portal.portlets.GenericMVCContext;
import org.apache.jetspeed.portal.portlets.GenericMVCPortlet;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.persistence.PersistenceManager;
import org.apache.jetspeed.services.persistence.PortalPersistenceException;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.util.PortletSessionState;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class GenericMVCAction
extends PortletAction {
    protected static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(GenericMVCAction.class.getName());

    protected void perform(RunData rundata) throws Exception {
        Context context = this.getContext(rundata);
        if (context != null && rundata.getParameters().getString("action") != null) {
            logger.debug("Action detected with action + context");
            this.doPerform(rundata, context);
        } else {
            if (context == null) {
                logger.debug("Action: building action context");
                context = new GenericMVCContext();
                rundata.getTemplateInfo().setTemplateContext("VelocityActionContext", (Object)context);
            }
            try {
                logger.debug("Action: try executing events");
                GenericMVCPortlet portlet = (GenericMVCPortlet)context.get("portlet");
                if (portlet != null) {
                    if (rundata.getParameters().getString("js_peid") == null || PortletSessionState.isMyRequest(rundata, portlet)) {
                        this.executeEvents(rundata, context);
                    } else {
                        logger.debug("Action: calling doPerform");
                        this.doPerform(rundata, context);
                    }
                } else {
                    this.executeEvents(rundata, context);
                }
            }
            catch (NoSuchMethodException e) {
                logger.debug("Action: calling doPerform");
            }
            this.doPerform(rundata, context);
        }
    }

    public void doPerform(RunData rundata, Context context) throws Exception {
        GenericMVCPortlet portlet = null;
        JetspeedRunData jdata = (JetspeedRunData)rundata;
        logger.debug("GenericMVCAction: retrieved context: " + context);
        if (context != null) {
            portlet = (GenericMVCPortlet)context.get("portlet");
        }
        logger.debug("GenericMVCAction: retrieved portlet: " + portlet);
        if (portlet != null) {
            if (jdata.getMode() == 1 && portlet.getName().equals(jdata.getCustomized().getName())) {
                logger.debug("GenericMVCAction: building customize");
                this.buildConfigureContext(portlet, context, rundata);
                return;
            }
            if (jdata.getMode() == 2) {
                logger.debug("GenericMVCAction: building maximize");
                this.buildMaximizedContext(portlet, context, rundata);
                return;
            }
            logger.debug("GenericMVCAction: building normal");
            this.buildNormalContext(portlet, context, rundata);
        }
    }

    protected void buildMaximizedContext(Portlet portlet, Context context, RunData rundata) throws Exception {
        this.buildNormalContext(portlet, context, rundata);
    }

    protected void buildConfigureContext(Portlet portlet, Context context, RunData rundata) throws Exception {
    }

    protected void buildNormalContext(Portlet portlet, Context context, RunData rundata) throws Exception {
    }

    public PortletInstance getPortletInstance(Context context) {
        return this.getPortlet(context).getInstance((RunData)context.get("data"));
    }

    public String getAttribute(String attrName, Context context) {
        return this.getPortletInstance(context).getAttribute(attrName);
    }

    public String getAttribute(String attrName, String defaultValue, Context context) {
        return this.getPortletInstance(context).getAttribute(attrName, defaultValue);
    }

    public void setAttribute(String attrName, String value, Context context) throws PortalPersistenceException {
        PortletInstance instance = this.getPortletInstance(context);
        instance.setAttribute(attrName, value);
        PersistenceManager.store(instance);
    }

    public void checkAdministrativeAction(RunData data) throws SecurityException {
        if (!JetspeedSecurity.hasAdminRole(data.getUser())) {
            if (logger.isWarnEnabled()) {
                logger.warn("User [" + data.getUser().getUserName() + "] attempted to perform administrative action");
            }
            throw new SecurityException("User [" + data.getUser().getUserName() + "] must be an administrator to perform this action");
        }
    }
}

