/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.parameters;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.ecs.Element;
import org.apache.ecs.ElementContainer;
import org.apache.ecs.html.A;
import org.apache.ecs.html.IMG;
import org.apache.ecs.html.Input;
import org.apache.ecs.html.Script;
import org.apache.jetspeed.modules.parameters.ParameterPresentationStyle;
import org.apache.turbine.util.RunData;

public class PopupCalendar
extends ParameterPresentationStyle {
    public static final String PARM_FORM_NAME = "formName";
    public static final String PARM_FORMAT = "format";

    public String getContent(RunData data, String name, String value, Map parms) {
        ElementContainer container = new ElementContainer();
        if (value.equals("$today")) {
            Date dt = new Date(System.currentTimeMillis());
            value = new SimpleDateFormat("M/d/yyyy").format(dt);
        }
        container.addElement((Element)new Script().setLanguage("JavaScript").setSrc("javascript/PopupCalendar.js"));
        container.addElement((Element)new Input("TEXT", name, value));
        IMG img = new IMG("images/cal.gif").setAlt("Click here for popup calendar").setBorder(0);
        A a = new A(this.getJavaScript(name), (Element)img);
        container.addElement((Element)a);
        return container.toString();
    }

    private String getJavaScript(String fieldName) {
        String formName = (String)this.getParm(PARM_FORM_NAME, "DefaultCustomizer");
        String format = (String)this.getParm(PARM_FORMAT, "mm/dd/yyyy");
        Object[] args = new Object[]{formName, fieldName, format};
        String template = "javascript: show_calendar(''{0}.{1}'',{0}.{1}.value,''{2}'');";
        return new MessageFormat(template).format(args);
    }

    public static void main(String[] args) {
        PopupCalendar pc = new PopupCalendar();
        System.out.println(pc.getContent(null, "test", "08/01/2001", null));
        System.out.println(pc.getContent(null, "test", "$today", null));
    }
}

