/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.registry.base;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.apache.jetspeed.om.registry.CachedParameter;
import org.apache.jetspeed.om.registry.Category;
import org.apache.jetspeed.om.registry.ContentURL;
import org.apache.jetspeed.om.registry.MetaInfo;
import org.apache.jetspeed.om.registry.Parameter;
import org.apache.jetspeed.om.registry.PortletEntry;
import org.apache.jetspeed.om.registry.base.BaseCategory;
import org.apache.jetspeed.om.registry.base.BaseContentURL;
import org.apache.jetspeed.om.registry.base.BasePortletInfoEntry;
import org.apache.jetspeed.om.registry.base.PortletIterator;
import org.apache.jetspeed.services.Registry;

public class BasePortletEntry
extends BasePortletInfoEntry
implements PortletEntry,
Serializable {
    private String parent;
    private ContentURL url = new BaseContentURL();
    protected Vector categories = new Vector();
    private boolean application;
    private String type = "abstract";
    private boolean isRef = true;

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        BasePortletEntry obj = (BasePortletEntry)object;
        if (this.application != obj.isApplication()) {
            return false;
        }
        if (this.parent != null ? !this.parent.equals(obj.getParent()) : obj.getParent() != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(obj.getType()) : obj.getType() != null) {
            return false;
        }
        if (this.url != null ? !this.url.equals(obj.getContentURL()) : obj.getContentURL() != null) {
            return false;
        }
        Iterator i = this.categories.iterator();
        Iterator i2 = obj.getCategories().iterator();
        while (i.hasNext()) {
            BaseCategory c1 = (BaseCategory)i.next();
            BaseCategory c2 = null;
            if (!i2.hasNext()) {
                return false;
            }
            c2 = (BaseCategory)i2.next();
            if (c1.equals(c2)) continue;
            return false;
        }
        if (i2.hasNext()) {
            return false;
        }
        return super.equals(object);
    }

    public String getURL() {
        return this.url.getURL();
    }

    public void setURL(String url) {
        this.url.setURL(url);
    }

    public boolean isCachedOnURL() {
        return this.url.isCacheKey();
    }

    public void setCachedOnURL(boolean cache) {
        this.url.setCachedOnURL(cache);
    }

    public ContentURL getURLEntry() {
        return this.url;
    }

    public String getParent() {
        return this.parent;
    }

    public String getClassname() {
        if (this.isRef && this.classname == null) {
            return this.getParentEntry().getClassname();
        }
        return this.classname;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public boolean isAdmin() {
        if (this.getSecurity() != null) {
            return "admin".equals(this.getSecurity().getRole());
        }
        return false;
    }

    public boolean isApplication() {
        return this.application;
    }

    public void setApplication(boolean application) {
        this.application = application;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.isRef = "ref".equals(type);
        this.type = type;
    }

    public boolean getApplication() {
        return this.application;
    }

    public String getTitle() {
        String title = super.getTitle();
        if (title != null) {
            return title;
        }
        if (this.isRef) {
            return this.getParentEntry().getTitle();
        }
        return null;
    }

    public String getDescription() {
        String desc = super.getDescription();
        if (desc != null) {
            return desc;
        }
        if (this.isRef) {
            return this.getParentEntry().getDescription();
        }
        return null;
    }

    public PortletEntry getParentEntry() {
        PortletEntry parent = null;
        parent = (PortletEntry)Registry.getEntry(Registry.PORTLET, this.getParent());
        if (parent == null) {
            parent = new BasePortletEntry();
            parent.setName(this.getParent());
            parent.setType("abstract");
        }
        return parent;
    }

    public MetaInfo getMetaInfo() {
        MetaInfo meta = super.getMetaInfo();
        if (meta == null) {
            return this.getParentEntry().getMetaInfo();
        }
        return meta;
    }

    public Iterator getParameterNames() {
        if (this.isRef) {
            Hashtable hash = new Hashtable();
            Iterator i = super.getParameterNames();
            while (i.hasNext()) {
                hash.put(i.next(), "1");
            }
            i = this.getParentEntry().getParameterNames();
            while (i.hasNext()) {
                hash.put(i.next(), "1");
            }
            return hash.keySet().iterator();
        }
        return super.getParameterNames();
    }

    public Parameter getParameter(String name) {
        Parameter p = super.getParameter(name);
        if (this.isRef && p == null) {
            return this.getParentEntry().getParameter(name);
        }
        return p;
    }

    public CachedParameter getCachedParameter(String name) {
        Parameter p = this.getParameter(name);
        return (CachedParameter)p;
    }

    public Map getParameterMap() {
        Hashtable params = (Hashtable)super.getParameterMap();
        if (this.isRef) {
            Map map = this.getParentEntry().getParameterMap();
            map.putAll(params);
            return map;
        }
        return params;
    }

    public Iterator listMediaTypes() {
        if (this.isRef) {
            HashMap types = new HashMap();
            Iterator i = super.listMediaTypes();
            while (i.hasNext()) {
                types.put(i.next(), "1");
            }
            i = this.getParentEntry().listMediaTypes();
            while (i.hasNext()) {
                types.put(i.next(), "1");
            }
            return types.keySet().iterator();
        }
        return super.listMediaTypes();
    }

    public boolean hasMediaType(String name) {
        if (this.isRef) {
            return super.hasMediaType(name) || this.getParentEntry().hasMediaType(name);
        }
        return super.hasMediaType(name);
    }

    public BaseContentURL getContentURL() {
        return (BaseContentURL)this.url;
    }

    public void setContentURL(BaseContentURL url) {
        this.url = url;
    }

    public Vector getCategories() {
        return this.categories;
    }

    public void setCategories(Vector v) {
        this.categories = v;
    }

    public Iterator listCategories() {
        return new PortletIterator(this, "getCategories");
    }

    public boolean hasCategory(String name) {
        return this.hasCategory(name, "Jetspeed");
    }

    public boolean hasCategory(String name, String group) {
        Iterator it = this.listCategories();
        while (it.hasNext()) {
            Category cat = (Category)it.next();
            if (!cat.getName().equals(name) || !cat.getGroup().equals(group)) continue;
            return true;
        }
        return false;
    }

    public void addCategory(String name) {
        this.addCategory(name, "Jetspeed");
    }

    public void addCategory(String name, String group) {
        if (!this.hasCategory(name, group)) {
            BaseCategory cat = new BaseCategory();
            cat.setName(name);
            cat.setGroup(group);
            this.categories.add(cat);
        }
    }

    public void removeCategory(String name) {
        this.removeCategory(name, "Jetspeed");
    }

    public void removeCategory(String name, String group) {
        for (int ix = 0; ix < this.categories.size(); ++ix) {
            Category cat = (Category)this.categories.elementAt(ix);
            if (!cat.getName().equals(name) || !cat.getGroup().equals(group)) continue;
            this.categories.remove(ix);
            return;
        }
    }
}

