/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.registry.base;

import java.io.Serializable;
import org.apache.jetspeed.om.SecurityReference;
import org.apache.jetspeed.om.registry.MetaInfo;
import org.apache.jetspeed.om.registry.RegistryEntry;
import org.apache.jetspeed.om.registry.Security;
import org.apache.jetspeed.om.registry.base.BaseMetaInfo;
import org.apache.jetspeed.om.registry.base.BaseSecurity;

public class BaseRegistryEntry
implements RegistryEntry,
Serializable {
    protected long id = 0L;
    protected String name;
    protected MetaInfo metaInfo = null;
    protected Security security = null;
    protected boolean hidden;
    protected int _hidden;
    protected SecurityReference securityRef = null;
    String title;
    String description;
    String image;
    String role;

    public BaseRegistryEntry() {
    }

    public BaseRegistryEntry(long id, String name, int _hidden, String title, String description, String image, String role) {
        this.id = id;
        this.name = name;
        this._hidden = _hidden;
        this.hidden = _hidden == 1;
        BaseMetaInfo meta = new BaseMetaInfo(title, description, image);
        this.setMetaInfo(meta);
        BaseSecurity security = new BaseSecurity(role);
        this.setSecurity(security);
    }

    public boolean equals(Object entry) {
        if (entry == null) {
            return false;
        }
        BaseRegistryEntry e = (BaseRegistryEntry)entry;
        if (e.getId() != this.getId()) {
            return false;
        }
        if (e.isHidden() != this.isHidden()) {
            return false;
        }
        if (this.name != null ? !e.name.equals(this.name) : e.name != null) {
            return false;
        }
        if (this.metaInfo != null ? !this.metaInfo.equals(e.metaInfo) : e.metaInfo != null) {
            return false;
        }
        return !(this.security != null ? !this.security.equals(e.security) : e.security != null);
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        String title;
        if (this.metaInfo != null && null != (title = this.metaInfo.getTitle())) {
            return title;
        }
        return null;
    }

    public void setTitle(String title) {
        if (this.metaInfo == null) {
            this.metaInfo = new BaseMetaInfo();
        }
        this.metaInfo.setTitle(title);
    }

    public String getDescription() {
        String desc;
        if (this.metaInfo != null && null != (desc = this.metaInfo.getDescription())) {
            return desc;
        }
        return null;
    }

    public void setDescription(String description) {
        if (this.metaInfo == null) {
            this.metaInfo = new BaseMetaInfo();
        }
        this.metaInfo.setDescription(description);
        this.description = description;
    }

    public Security getSecurity() {
        return this.security;
    }

    public void setSecurity(Security security) {
        this.security = security;
        this.role = this.security.getRole();
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
        this._hidden = hidden ? 1 : 0;
    }

    public boolean getHidden() {
        return this.hidden;
    }

    public BaseSecurity getBaseSecurity() {
        return (BaseSecurity)this.security;
    }

    public void setBaseSecurity(BaseSecurity security) {
        this.security = security;
        this.role = this.security.getRole();
    }

    public MetaInfo getMetaInfo() {
        return this.metaInfo;
    }

    public void setMetaInfo(MetaInfo metaInfo) {
        this.metaInfo = metaInfo;
        this.title = metaInfo.getTitle();
        this.description = metaInfo.getDescription();
        this.image = metaInfo.getImage();
    }

    public BaseMetaInfo getBaseMetaInfo() {
        return (BaseMetaInfo)this.metaInfo;
    }

    public void setBaseMetaInfo(BaseMetaInfo metaInfo) {
        this.metaInfo = metaInfo;
        this.title = metaInfo.getTitle();
        this.description = metaInfo.getDescription();
        this.image = metaInfo.getImage();
    }

    public SecurityReference getSecurityRef() {
        return this.securityRef;
    }

    public void setSecurityRef(SecurityReference securityRef) {
        this.securityRef = securityRef;
    }
}

