/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.registry.base;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.apache.jetspeed.om.registry.base.BasePortletEntry;
import org.apache.jetspeed.services.Registry;

public class PortletIterator
implements Iterator {
    protected BasePortletEntry entry;
    protected String method;
    protected Vector vector;
    protected int index = 0;

    public PortletIterator(BasePortletEntry entry, String method) {
        this.entry = entry;
        this.method = method;
        this.vector = this.getVector();
    }

    public boolean hasNext() {
        int size = this.vector.size();
        if (size == 0) {
            return false;
        }
        if (this.index >= size) {
            this.entry = this.getParentEntry(this.entry);
            if (this.entry == null) {
                return false;
            }
            this.vector = this.getVector();
            if (this.vector == null) {
                return false;
            }
            this.index = 0;
            if (this.vector.size() == 0) {
                return false;
            }
        }
        return true;
    }

    public void remove() throws IllegalStateException, UnsupportedOperationException {
        throw new UnsupportedOperationException("The remove() method is not supported");
    }

    protected BasePortletEntry getParentEntry(BasePortletEntry entry) {
        String parentName = entry.getParent();
        if (parentName == null || parentName.equals("")) {
            return null;
        }
        BasePortletEntry parent = null;
        parent = (BasePortletEntry)Registry.getEntry(Registry.PORTLET, entry.getParent());
        return parent;
    }

    public Object next() throws NoSuchElementException {
        Object o = this.vector.elementAt(this.index);
        ++this.index;
        return o;
    }

    protected Vector getVector() {
        try {
            this.vector = (Vector)this.entry.getClass().getMethod(this.method, null).invoke((Object)this.entry, null);
        }
        catch (Exception e) {
            this.vector = null;
        }
        return this.vector;
    }
}

