/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portal.portlets;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import org.apache.ecs.ConcreteElement;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.portal.PortletException;
import org.apache.jetspeed.portal.portlets.AbstractInstancePortlet;
import org.apache.jetspeed.portal.portlets.GenericMVCContext;
import org.apache.jetspeed.portal.portlets.viewprocessor.ViewProcessor;
import org.apache.jetspeed.portal.portlets.viewprocessor.ViewProcessorFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.util.PortletSessionState;
import org.apache.jetspeed.util.template.JetspeedLink;
import org.apache.jetspeed.util.template.JetspeedTemplateLink;
import org.apache.jetspeed.util.template.JspTemplate;
import org.apache.turbine.modules.ActionLoader;
import org.apache.turbine.services.pull.TurbinePull;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class GenericMVCPortlet
extends AbstractInstancePortlet {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(GenericMVCPortlet.class.getName());
    public static final String PORTLET = "portlet";
    public static final String TEMPLATE = "template";
    public static final String RUNDATA = "data";
    public static final String PORTLET_CONFIG = "conf";
    public static final String SKIN = "skin";
    public static final String VIEW_TYPE = "viewType";
    public static final String IS_CACHEABLE = "_IsCacheable";
    private String viewType = "ERROR: not set in config";
    private String actionName = "ERROR: not set in config";
    private String template = "ERROR: not set in config";
    private String configureTemplate;
    private String maximizedTemplate;
    private ViewProcessor processor = null;
    private boolean providesCustomization;
    public static final String RENDERING_DELAYED = "renderingDelayed";
    public static final String SIMULATE_DELAY = "simulateDelay";
    public static final String PORTLET_ID = "__portletId";
    public static final String DOC_URL = "__docUrl";

    public void init() throws PortletException {
        String provConf = this.getPortletConfig().getInitParameter("provides.customization", "false");
        this.providesCustomization = new Boolean(provConf);
        this.actionName = this.getPortletConfig().getInitParameter("action");
        if (this.getPortletConfig().getInitParameter("viewtype") != null) {
            this.viewType = this.getPortletConfig().getInitParameter("viewtype");
        }
        this.template = this.getPortletConfig().getInitParameter(TEMPLATE);
        logger.info("GenericMVCPortlet - creating view processor for viewtype = " + this.viewType + ", template = " + this.template);
        this.processor = ViewProcessorFactory.getViewProcessor(this.viewType);
        this.processor.init(this);
    }

    public boolean isCacheable() {
        return this.getPortletConfig().getInitParameter(IS_CACHEABLE, "true").equalsIgnoreCase("true");
    }

    public boolean providesCustomization() {
        return this.providesCustomization;
    }

    public ConcreteElement getContent(RunData rundata) {
        if (this.useDelayedRendering(rundata)) {
            Profile profile = ((JetspeedRunData)rundata).getProfile();
            String path = profile.getPath();
            String portletId = this.getID();
            String docUrl = "portal/" + path + "/js_peid/" + portletId + "?action=controls.Print";
            docUrl = URLEncoder.encode(docUrl);
            HttpServletRequest request = rundata.getRequest();
            request.setAttribute(PORTLET_ID, (Object)portletId);
            request.setAttribute(DOC_URL, (Object)docUrl);
            return this.renderJspTemplate(rundata, "delayedContent.jsp");
        }
        this.simulateDelay();
        if (!this.isCacheable() || null == this.getExpirationMillis()) {
            return this.buildContent(rundata);
        }
        if (this.getExpirationMillis() <= System.currentTimeMillis()) {
            return this.buildContent(rundata);
        }
        return this.getContent(rundata, null, true);
    }

    protected ConcreteElement buildContent(RunData rundata) {
        Object jslink;
        GenericMVCContext context = new GenericMVCContext(TurbinePull.getGlobalContext());
        context.put(RUNDATA, rundata);
        context.put(PORTLET, this);
        context.put(PORTLET_CONFIG, this.getPortletConfig());
        context.put(SKIN, this.getPortletConfig().getPortletSkin());
        context.put(TEMPLATE, this.getCurrentTemplate(rundata));
        context.put(VIEW_TYPE, this.viewType);
        this.populateRequest(rundata);
        TurbinePull.populateContext((Context)context, (RunData)rundata);
        Object jlink = context.get("jlink");
        if (jlink instanceof JetspeedTemplateLink) {
            ((JetspeedTemplateLink)((Object)jlink)).setPortlet(this);
        }
        if ((jslink = context.get("jslink")) instanceof JetspeedLink) {
            ((JetspeedLink)jslink).setPortlet(this);
        }
        if (this.actionName != null) {
            try {
                rundata.getTemplateInfo().setTemplateContext("VelocityPortletContext", (Object)context);
                if (logger.isDebugEnabled()) {
                    logger.debug("GenericMVCPortlet: Executing action [" + this.actionName + "] for portlet [" + this.getName() + "]");
                }
                ActionLoader.getInstance().exec(rundata, this.actionName);
            }
            catch (Exception e) {
                logger.error("GenericMVCPortlet - error executing action", e);
            }
        }
        logger.info("GenericMVCPortlet - calling processView on processor");
        ConcreteElement result = (ConcreteElement)this.processor.processView(context);
        logger.info("GenericMVCPortlet - setting this portlet's content");
        this.clearContent();
        this.setContent(result);
        return result;
    }

    protected String getViewType() {
        return this.viewType;
    }

    protected void setViewType(String viewType) {
        this.viewType = viewType;
    }

    protected void populateRequest(RunData rundata) {
        HttpServletRequest request = rundata.getRequest();
        request.setAttribute(RUNDATA, (Object)rundata);
        request.setAttribute(PORTLET, (Object)this);
        request.setAttribute(PORTLET_CONFIG, (Object)this.getPortletConfig());
        request.setAttribute(SKIN, (Object)this.getPortletConfig().getPortletSkin());
        request.setAttribute(TEMPLATE, (Object)this.getCurrentTemplate(rundata));
        request.setAttribute(VIEW_TYPE, (Object)this.viewType);
    }

    protected String getCurrentTemplate(RunData data) {
        String useTemplate = (String)PortletSessionState.getAttribute(this, data, TEMPLATE);
        if (useTemplate == null) {
            useTemplate = this.template;
        }
        return useTemplate;
    }

    protected boolean useDelayedRendering(RunData rundata) {
        String renderingDelayedString = this.getPortletConfig().getInitParameter(RENDERING_DELAYED);
        boolean renderingDelayed = false;
        if (renderingDelayedString != null) {
            renderingDelayed = Boolean.valueOf(renderingDelayedString) == Boolean.TRUE;
        }
        HttpServletRequest request = rundata.getRequest();
        String action = rundata.getAction();
        return renderingDelayed && (action == null || action.length() == 0 || "controls.Restore".equals(action));
    }

    protected ConcreteElement renderJspTemplate(RunData rundata, String templateName) {
        JspTemplate t = new JspTemplate(rundata, "/portlets/html/" + templateName);
        PrintWriter out = null;
        try {
            out = rundata.getOut();
            out.println(t.getContent());
        }
        catch (IOException ioe) {
            logger.error(ioe);
        }
        return null;
    }

    private void simulateDelay() {
        String simulateDelayString = this.getPortletConfig().getInitParameter(SIMULATE_DELAY);
        int simulateDelay = 0;
        if (simulateDelayString != null) {
            simulateDelay = Integer.parseInt(simulateDelayString);
        }
        if (simulateDelay > 0) {
            long delayInMilliseconds = simulateDelay * 1000;
            try {
                Thread.sleep(delayInMilliseconds);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }
}

