/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portal.portlets;

import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.ecs.ConcreteElement;
import org.apache.jetspeed.portal.PortletSet;
import org.apache.jetspeed.portal.portlets.AbstractInstancePortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.statemanager.SessionState;
import org.apache.jetspeed.util.JetspeedClearElement;
import org.apache.jetspeed.util.PortletConfigState;
import org.apache.jetspeed.util.StringUtils;
import org.apache.jetspeed.util.URIEncoder;
import org.apache.turbine.util.RunData;

public class RedirectPortlet
extends AbstractInstancePortlet {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(RedirectPortlet.class.getName());

    public ConcreteElement getContent(RunData rundata) {
        String menuLevel = this.getPortletConfig().getInitParameter("menuLevel");
        int menus = 1;
        try {
            if (menuLevel != null) {
                menus = Integer.parseInt(menuLevel);
            }
        }
        catch (Exception e) {
            logger.error("failed to parse menu level from Redirect Portlet");
        }
        PortletSet set = this.getPortletConfig().getPortletSet();
        for (int count = 0; set != null && count <= menus; ++count) {
            this.clearState(rundata, set);
            set = set.getPortletConfig().getPortletSet();
        }
        String url = this.getPortletConfig().getInitParameter("url");
        url = this.createDynamicUrl((JetspeedRunData)rundata, url);
        HttpServletRequest request = rundata.getRequest();
        HttpServletResponse response = rundata.getResponse();
        try {
            String script = "<script> setTimeout( \"location.href='" + url + "'\", 1) </script>";
            response.getWriter().write(script);
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = "Failed to redirect to " + url;
            logger.error(message, e);
            return new JetspeedClearElement(message);
        }
        return new JetspeedClearElement(url);
    }

    private void clearState(RunData rundata, PortletSet set) {
        SessionState state = ((JetspeedRunData)rundata).getPortletSessionState(set.getID());
        state.setAttribute("js_pane", null);
    }

    private String createDynamicUrl(JetspeedRunData rundata, String url) {
        String parameterNames = PortletConfigState.getParameter(this, (RunData)rundata, "parameterNames", null);
        String sessionAttributeNames = PortletConfigState.getParameter(this, (RunData)rundata, "sessionAttributeNames", null);
        if (parameterNames == null || sessionAttributeNames == null) {
            return url;
        }
        String[] names = StringUtils.stringToArray(parameterNames, ",");
        String[] attribNames = StringUtils.stringToArray(sessionAttributeNames, ",");
        if (names == null || attribNames == null) {
            return url;
        }
        if (names.length == 0 || attribNames.length == 0) {
            return url;
        }
        int count = names.length > attribNames.length ? names.length : attribNames.length;
        StringBuffer dynamic = new StringBuffer(url);
        int appended = 0;
        for (int ix = 0; ix < count; ++ix) {
            String attribute = this.lookup(rundata, attribNames[ix]);
            if (attribute == null) continue;
            if (appended == 0) {
                dynamic.append("?");
            } else {
                dynamic.append("&");
            }
            ++appended;
            dynamic.append(URIEncoder.encode(names[ix]));
            dynamic.append("=");
            dynamic.append(URIEncoder.encode(attribute));
        }
        return dynamic.toString();
    }

    private String lookup(JetspeedRunData rundata, String attributeName) {
        String value = null;
        Object o = this.lookupAttribute(rundata, attributeName);
        if (o == null) {
            String property;
            String name;
            int index = attributeName.lastIndexOf(".");
            if (index > 0 && (o = this.lookupAttribute(rundata, name = attributeName.substring(0, index), property = attributeName.substring(index + 1))) instanceof String) {
                value = (String)o;
            }
        } else if (o instanceof String) {
            value = (String)o;
        }
        return value;
    }

    private Object lookupAttribute(JetspeedRunData rundata, String name) {
        Object o = rundata.getRequest().getAttribute(name);
        if (o == null) {
            o = rundata.getSession().getAttribute(name);
        }
        return o;
    }

    private Object lookupAttribute(JetspeedRunData rundata, String name, String property) {
        Object o = this.lookupAttribute(rundata, name);
        Object returnObject = null;
        if (o != null) {
            String getterName = "get" + property.substring(0, 1).toUpperCase() + property.substring(1);
            try {
                Method getter = o.getClass().getMethod(getterName, null);
                returnObject = getter.invoke(o, null);
            }
            catch (Exception e) {
                o = null;
            }
        }
        return returnObject;
    }
}

