/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portal.portlets;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.StringElement;
import org.apache.jetspeed.portal.portlets.AbstractPortlet;
import org.apache.turbine.util.RunData;

public class ServletProxyPortlet
extends AbstractPortlet {
    private static final int BUFFER_SIZE = 2048;
    public static final String URL_PARAMETER_NAME = "URL";
    public static final String PROTOCOL_PARAMETER_NAME = "protocol";
    public static final String SESSION_TOKEN_PARAMETER_NAME = "session_token";
    public static final String DEFAULT_PROTOCOL = "http";
    public static final String DEFAULT_SESSION_TOKEN = "jsessionid";

    public ConcreteElement getContent(RunData rundata) {
        String servletURL = this.processURL(rundata);
        if (servletURL == null) {
            return new StringElement("ServletInvokerPortlet:  Must specify a URL using the URL parameter");
        }
        try {
            URL url = new URL(servletURL);
            URLConnection connection = url.openConnection();
            InputStream stream = connection.getInputStream();
            BufferedInputStream in = new BufferedInputStream(stream);
            int length = 0;
            byte[] buf = new byte[2048];
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while (in != null && (length = in.read(buf)) != -1) {
                out.write(buf, 0, length);
            }
            String content = out.toString();
            return new StringElement(content);
        }
        catch (Exception e) {
            String message = "ServletInvokerPortlet: Error invoking " + servletURL + ": " + e.getMessage();
            return new StringElement(message);
        }
    }

    protected String processURL(RunData rundata) {
        String token;
        String servletURL = this.getPortletConfig().getInitParameter(URL_PARAMETER_NAME);
        if (servletURL == null) {
            return null;
        }
        String protocol = this.getPortletConfig().getInitParameter(PROTOCOL_PARAMETER_NAME);
        if (protocol == null) {
            protocol = DEFAULT_PROTOCOL;
        }
        if ((token = this.getPortletConfig().getInitParameter(SESSION_TOKEN_PARAMETER_NAME)) == null) {
            token = DEFAULT_SESSION_TOKEN;
        }
        String queryString = new String();
        int queryIndex = servletURL.indexOf("?");
        if (queryIndex > 0) {
            queryString = servletURL.substring(queryIndex);
            servletURL = servletURL.substring(0, queryIndex);
        }
        servletURL = protocol + "://" + rundata.getServerName() + ":" + rundata.getServerPort() + rundata.getContextPath() + servletURL + ";" + token + "=" + rundata.getSession().getId() + queryString;
        return servletURL;
    }
}

