/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portal.portlets;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.Element;
import org.apache.ecs.ElementContainer;
import org.apache.ecs.html.Comment;
import org.apache.jetspeed.portal.PortletConfig;
import org.apache.jetspeed.portal.PortletException;
import org.apache.jetspeed.portal.portlets.AbstractPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.modules.ScreenLoader;
import org.apache.turbine.util.RunData;

public class TurbineScreenPortlet
extends AbstractPortlet {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(TurbineScreenPortlet.class.getName());
    private String screen = null;
    private String bgcolor = null;
    private String classes = null;
    private Hashtable paramSet = null;
    public static final String BGCOLOR = "bgcolor";
    public static final String CLASSES = "classes";
    public static final String SCREEN = "display.screen";

    public ConcreteElement getContent(RunData rundata) {
        ElementContainer content = new ElementContainer();
        try {
            rundata = this.setParams(rundata);
            content.addElement((Element)new Comment("BEGIN TurbineScreenPortlet"));
            content.addElement((Element)ScreenLoader.getInstance().eval(rundata, this.screen));
            content.addElement((Element)new Comment("END TurbineScreenPortlet"));
        }
        catch (Exception e) {
            String message = "TurbineScreenPortlet: " + e.getMessage();
            logger.error(message, e);
            content.addElement(message);
        }
        return content;
    }

    public void init() throws PortletException {
        PortletConfig pc = this.getPortletConfig();
        Object myContent = null;
        try {
            this.screen = pc.getInitParameter(SCREEN);
            if (this.screen == null) {
                throw new IllegalArgumentException("Missing screen parameter");
            }
            if (this.screen == null) {
                throw new PortletException("You need to specify a display.screen parameter for this portlet");
            }
            String param = null;
            String value = null;
            Map dict = pc.getInitParameters();
            Iterator en = dict.keySet().iterator();
            int index = -1;
            String tParam = this.screen + ".param";
            String newParam = null;
            this.paramSet = new Hashtable();
            while (en.hasNext()) {
                param = (String)en.next();
                index = param.indexOf(tParam);
                if (index == -1) continue;
                value = (String)dict.get(param);
                if (value == null) {
                    throw new PortletException("Could not retrieve value for " + param);
                }
                newParam = param.substring(index + tParam.length() + 1);
                this.paramSet.put(newParam, value);
            }
            this.bgcolor = this.getPortletConfig().getPortletSkin().getBackgroundColor();
            this.classes = "WEB-INF/classes";
        }
        catch (Exception e) {
            String message = "TurbineScreenPortlet: " + e.getMessage();
            logger.error(message, e);
        }
    }

    public boolean getAllowEdit(RunData rundata) {
        return false;
    }

    public boolean getAllowMaximize(RunData rundata) {
        return true;
    }

    private RunData setParams(RunData data) {
        data.getParameters().add(BGCOLOR, this.bgcolor);
        data.getParameters().add(CLASSES, this.classes);
        Enumeration en = this.paramSet.keys();
        String param = null;
        while (en.hasMoreElements()) {
            param = (String)en.nextElement();
            data.getParameters().add(param, (String)this.paramSet.get(param));
        }
        return data;
    }
}

