/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portal.portlets;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;
import org.apache.ecs.ConcreteElement;
import org.apache.jetspeed.portal.PortletConfig;
import org.apache.jetspeed.portal.PortletException;
import org.apache.jetspeed.portal.portlets.AbstractInstancePortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.util.Base64;
import org.apache.jetspeed.util.HTMLRewriter;
import org.apache.jetspeed.util.JetspeedClearElement;
import org.apache.turbine.util.RunData;

public class WebPagePortlet
extends AbstractInstancePortlet {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(WebPagePortlet.class.getName());
    protected HTMLRewriter rewriter = null;
    protected boolean initDone = false;
    protected boolean contentStale = true;
    protected boolean cacheContent = false;
    protected String username = null;
    protected String password = null;

    public void init() throws PortletException {
        if (this.initDone) {
            return;
        }
        PortletConfig config = this.getPortletConfig();
        try {
            this.rewriter = new HTMLRewriter(!config.getInitParameter("dont_remove_script", "no").equalsIgnoreCase("yes"), !config.getInitParameter("dont_remove_style", "no").equalsIgnoreCase("yes"), !config.getInitParameter("dont_remove_noscript", "no").equalsIgnoreCase("yes"), !config.getInitParameter("dont_remove_meta", "no").equalsIgnoreCase("yes"), !config.getInitParameter("dont_remove_applet", "no").equalsIgnoreCase("yes"), !config.getInitParameter("dont_remove_object", "no").equalsIgnoreCase("yes"), !config.getInitParameter("dont_remove_head", "no").equalsIgnoreCase("yes"), !config.getInitParameter("dont_remove_onsomething", "no").equalsIgnoreCase("yes"), config.getInitParameter("open_in_popup", "no").equalsIgnoreCase("yes"));
            this.username = config.getInitParameter("username");
            this.password = config.getInitParameter("password");
            this.contentStale = true;
            this.initDone = true;
        }
        catch (Exception e) {
            logger.info("Exception occurred:" + e.toString());
            e.printStackTrace();
            throw new PortletException(e.toString());
        }
    }

    protected Reader getReader(String url) throws IOException {
        URL pageUrl = new URL(url);
        URLConnection pageConn = pageUrl.openConnection();
        try {
            if (this.username != null && this.password != null) {
                pageConn.setRequestProperty("Authorization", "Basic " + Base64.encodeAsString(this.username + ":" + this.password));
            }
        }
        catch (Exception e) {
            logger.info("Exception occurred:" + e.toString(), e);
        }
        long pageExpiration = pageConn.getExpiration();
        String encoding = "iso-8859-1";
        String contentType = pageConn.getContentType();
        String tempString = null;
        String noCache = "no-cache";
        if (contentType != null) {
            StringTokenizer st = new StringTokenizer(contentType, "; =");
            while (st.hasMoreTokens()) {
                if (!st.nextToken().equalsIgnoreCase("charset")) continue;
                try {
                    encoding = st.nextToken();
                    break;
                }
                catch (Exception e) {
                    // empty catch block
                    break;
                }
            }
        }
        this.cacheContent = true;
        if (pageExpiration == 0L) {
            this.cacheContent = false;
        }
        if ((tempString = pageConn.getHeaderField("Cache-Control")) != null && tempString.toLowerCase().indexOf(noCache) >= 0) {
            this.cacheContent = false;
        }
        if ((tempString = pageConn.getHeaderField("Pragma")) != null && tempString.toLowerCase().indexOf(noCache) >= 0) {
            this.cacheContent = false;
        }
        InputStreamReader rdr = new InputStreamReader(pageConn.getInputStream(), encoding);
        if (pageExpiration > System.currentTimeMillis() && this.cacheContent) {
            this.contentStale = false;
            logger.debug("WebPagePortlet caching URL: " + url + " Expiration: " + pageExpiration + ", " + (pageExpiration - System.currentTimeMillis()) + " milliseconds into the future");
            this.setExpirationMillis(pageExpiration);
        } else {
            this.contentStale = true;
        }
        return rdr;
    }

    public ConcreteElement getContent(RunData data) {
        PortletConfig config = this.getPortletConfig();
        if (this.contentStale) {
            return this.getWebPageContent(data, config);
        }
        if (null == this.getExpirationMillis()) {
            return this.getContent(data, null, true);
        }
        if (this.getExpirationMillis() <= System.currentTimeMillis()) {
            return this.getWebPageContent(data, config);
        }
        return this.getContent(data, null, true);
    }

    private ConcreteElement getWebPageContent(RunData data, PortletConfig config) {
        String convertedString = null;
        JetspeedClearElement element = null;
        String url = this.selectUrl(data, config);
        try {
            Reader htmlReader = this.getReader(url);
            convertedString = this.rewriter.convertURLs(htmlReader, url);
            element = new JetspeedClearElement(convertedString);
            this.clearContent();
            this.setContent((ConcreteElement)element);
            htmlReader.close();
        }
        catch (Exception e) {
            logger.info("Exception occurred:" + e.toString(), e);
        }
        return element;
    }

    public void refresh() {
        if (this.cacheContent) {
            this.getWebPageContent(null, this.getPortletConfig());
        }
    }

    protected String selectUrl(RunData data, PortletConfig config) {
        String url = config.getURL();
        return url;
    }
}

