/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portal.portlets.admin;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.Element;
import org.apache.ecs.ElementContainer;
import org.apache.ecs.html.A;
import org.apache.ecs.html.B;
import org.apache.ecs.html.BR;
import org.apache.ecs.html.LI;
import org.apache.ecs.html.UL;
import org.apache.jetspeed.portal.portlets.AbstractPortlet;
import org.apache.jetspeed.services.urlmanager.URLFetcher;
import org.apache.jetspeed.services.urlmanager.URLInfo;
import org.apache.jetspeed.services.urlmanager.URLManager;
import org.apache.turbine.util.DynamicURI;
import org.apache.turbine.util.ParameterParser;
import org.apache.turbine.util.RunData;

public class BadURLManagerPortlet
extends AbstractPortlet {
    public static final String RETRY_URL = "retry";

    public ConcreteElement getContent(RunData rundata) {
        String url = rundata.getParameters().getString(RETRY_URL);
        if (url != null) {
            URLManager.unregister(url);
            rundata.getParameters().remove(RETRY_URL);
        }
        ElementContainer root = new ElementContainer();
        List urls = URLManager.list(14);
        root.addElement("The following " + urls.size() + " URL(s) are considered bad: ");
        root.addElement((Element)new BR());
        root.addElement("Click on a url to take it out of the list and retry it in when requested. ");
        root.addElement((Element)new BR());
        UL ul = new UL();
        DynamicURI uri = new DynamicURI(rundata);
        ParameterParser params = rundata.getParameters();
        uri.addQueryData(params);
        Iterator i = urls.iterator();
        while (i.hasNext()) {
            URLInfo info = URLManager.getInfo((String)i.next());
            if (info == null) continue;
            uri.removeQueryData(RETRY_URL);
            uri.addQueryData(RETRY_URL, info.getURL());
            ul.addElement((Element)new LI().addElement((Element)new A(uri.toString()).addElement(info.getURL())).addElement((Element)new B(info.getMessage())));
        }
        root.addElement((Element)ul);
        Hashtable rt = URLFetcher.getRealtimeURLs();
        root.addElement("The following " + rt.size() + " URL(s) are being loaded: ");
        root.addElement((Element)new BR());
        ul = new UL();
        Enumeration en = rt.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            LI li = new LI().addElement(key).addElement(" - by ");
            if (rt.get(key) != null) {
                li.addElement(String.valueOf(((Vector)rt.get(key)).size())).addElement(" threads.");
            }
            ul.addElement((Element)li);
        }
        root.addElement((Element)ul);
        return root;
    }

    public void init() {
        this.setTitle("BadURLManager");
        this.setDescription("Shows the admin what URLs are considered bad.");
    }

    public boolean getAllowEdit(RunData rundata) {
        return false;
    }

    public boolean getAllowMaximize(RunData rundata) {
        return false;
    }
}

