/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portal.portlets.admin;

import org.apache.ecs.ConcreteElement;
import org.apache.ecs.Element;
import org.apache.ecs.ElementContainer;
import org.apache.ecs.html.B;
import org.apache.ecs.html.BR;
import org.apache.ecs.html.HR;
import org.apache.jetspeed.portal.PortletException;
import org.apache.jetspeed.portal.portlets.AbstractPortlet;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.services.portletcache.GlobalCache;
import org.apache.jetspeed.services.threadpool.JetspeedThreadPoolService;
import org.apache.jetspeed.services.urlmanager.URLFetcher;
import org.apache.jetspeed.services.urlmanager.URLManager;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;

public class GlobalAdminPortlet
extends AbstractPortlet {
    public ConcreteElement getContent(RunData rundata) {
        ElementContainer ec = new ElementContainer();
        this.createCategory(ec, "Memory");
        ec.addElement((Element)this.getEntry("Free Memory (K)", Long.toString(Runtime.getRuntime().freeMemory() / 1024L)));
        ec.addElement((Element)this.getEntry("Total Memory (K)", Long.toString(Runtime.getRuntime().totalMemory() / 1024L)));
        JetspeedThreadPoolService service = (JetspeedThreadPoolService)TurbineServices.getInstance().getService("ThreadPool");
        this.createCategory(ec, "Thread Pool");
        ec.addElement((Element)this.getEntry("Available threads: ", service.getAvailableThreadCount()));
        ec.addElement((Element)this.getEntry("Total threads: ", service.getThreadCount()));
        ec.addElement((Element)this.getEntry("Runnable queue length: ", service.getQueueLength()));
        ec.addElement((Element)this.getEntry("Processed thread count: ", service.getThreadProcessedCount()));
        this.createCategory(ec, "PortletRegistry");
        ec.addElement((Element)this.getEntry("Number of entries: ", Registry.get(Registry.PORTLET).getEntryCount()));
        this.createCategory(ec, "Resource Manager");
        ec.addElement((Element)this.getEntry("Entries in Manager", URLManager.list(-1).size()));
        ec.addElement((Element)this.getEntry("Bad Entries", URLManager.list(14).size()));
        ec.addElement((Element)this.getEntry("URLs Loading/Refreshing", URLFetcher.getRealtimeURLs().size()));
        this.createCategory(ec, "Global Memory Cache");
        ec.addElement((Element)this.getEntry("Objects in Cache", GlobalCache.getNumberOfObjects()));
        return ec;
    }

    private void createCategory(ElementContainer ec, String title) {
        ec.addElement((Element)new HR());
        ec.addElement((Element)new B().addElement(title + ":"));
        ec.addElement((Element)new BR());
    }

    private ConcreteElement getEntry(String title, int value) {
        return this.getEntry(title, Integer.toString(value));
    }

    private ConcreteElement getEntry(String title, String value) {
        ElementContainer ec = new ElementContainer();
        ec.addElement(title);
        ec.addElement(" -> ");
        ec.addElement(value);
        ec.addElement((Element)new BR());
        return ec;
    }

    public void init() throws PortletException {
        this.setTitle("Global");
        this.setDescription("Global information...");
    }

    public boolean getAllowEdit(RunData rundata) {
        return false;
    }

    public boolean getAllowMaximize(RunData rundata) {
        return false;
    }
}

