/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portal.portlets.viewprocessor;

import org.apache.jetspeed.portal.portlets.viewprocessor.JSPViewProcessor;
import org.apache.jetspeed.portal.portlets.viewprocessor.RSSViewProcessor;
import org.apache.jetspeed.portal.portlets.viewprocessor.VelocityViewProcessor;
import org.apache.jetspeed.portal.portlets.viewprocessor.ViewProcessor;
import org.apache.jetspeed.portal.portlets.viewprocessor.XSLViewProcessor;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;

public class ViewProcessorFactory {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(ViewProcessorFactory.class.getName());

    public static ViewProcessor getViewProcessor(String viewType) {
        ViewProcessor viewProcessor;
        if (viewType.equals("Velocity")) {
            logger.info("ViewProcessorFactory - creating Velocity processor");
            viewProcessor = new VelocityViewProcessor();
        } else if (viewType.equals("JSP")) {
            logger.info("ViewProcessorFactory - creating JSP processor");
            viewProcessor = new JSPViewProcessor();
        } else if (viewType.equals("XSL")) {
            logger.info("ViewProcessorFactory - creating XSL processor");
            viewProcessor = new XSLViewProcessor();
        } else if (viewType.equals("RSS")) {
            logger.info("ViewProcessorFactory - creating RSS processor");
            viewProcessor = new RSSViewProcessor();
        } else {
            logger.error("ViewProcessorFactory - problem figuring out what view processor type you want - " + viewType);
            logger.error("ViewProcessorFactory - returing a JSP processor");
            viewProcessor = new JSPViewProcessor();
        }
        return viewProcessor;
    }
}

