/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services;

import java.security.Principal;
import java.util.Iterator;
import java.util.List;
import org.apache.jetspeed.om.SecurityReference;
import org.apache.jetspeed.om.profile.Entry;
import org.apache.jetspeed.om.registry.PortletEntry;
import org.apache.jetspeed.om.registry.RegistryEntry;
import org.apache.jetspeed.om.security.Group;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.om.security.Permission;
import org.apache.jetspeed.om.security.Role;
import org.apache.jetspeed.om.security.UserNamePrincipal;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.services.JetspeedAuthentication;
import org.apache.jetspeed.services.JetspeedPortalAccessController;
import org.apache.jetspeed.services.JetspeedUserManagement;
import org.apache.jetspeed.services.PortalToolkit;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.security.JetspeedGroupManagement;
import org.apache.jetspeed.services.security.JetspeedPermissionManagement;
import org.apache.jetspeed.services.security.JetspeedRoleManagement;
import org.apache.jetspeed.services.security.JetspeedSecurityException;
import org.apache.jetspeed.services.security.JetspeedSecurityService;
import org.apache.jetspeed.services.security.LoginException;
import org.apache.jetspeed.services.security.PortalResource;
import org.apache.turbine.om.security.User;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;

public abstract class JetspeedSecurity {
    public static final String PERMISSION_VIEW = "view";
    public static final String PERMISSION_CUSTOMIZE = "customize";
    public static final String PERMISSION_MAXIMIZE = "maximize";
    public static final String PERMISSION_MINIMIZE = "minimize";
    public static final String PERMISSION_PERSONALIZE = "personalize";
    public static final String PERMISSION_DETACH = "detach";
    public static final String PERMISSION_CLOSE = "close";
    public static final String PERMISSION_INFO = "info";
    public static final String PERMISSION_PRINT_FRIENDLY = "print_friendly";
    public static final String JETSPEED_GROUP = "Jetspeed";
    public static final String JETSPEED_GROUP_ID = "1";
    public static final String JETSPEED_ROLE_USER = "user";
    public static final String JETSPEED_ROLE_ADMIN = "admin";
    public static final char[] NUMBERS_AND_LETTERS_ALPHABET = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    public static final char[] LC_NUMBERS_AND_LETTERS_ALPHABET = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    public static JetspeedSecurityService getService() {
        return (JetspeedSecurityService)TurbineServices.getInstance().getService("JetspeedSecurity");
    }

    public static JetspeedUser login(String username, String password) throws LoginException {
        return JetspeedAuthentication.login(username, password);
    }

    public static JetspeedUser getAnonymousUser() throws LoginException {
        return JetspeedAuthentication.getAnonymousUser();
    }

    public static void logout() throws LoginException {
        JetspeedAuthentication.logout();
    }

    public static boolean checkPermission(JetspeedUser user, Entry entry, String action) {
        return JetspeedPortalAccessController.checkPermission(user, entry, action);
    }

    public static boolean checkPermission(JetspeedUser user, Portlet portlet, String action) {
        return JetspeedPortalAccessController.checkPermission(user, portlet, action);
    }

    public static boolean checkPermission(JetspeedUser user, PortalResource resource, String action) {
        return JetspeedPortalAccessController.checkPermission(user, resource, action);
    }

    public static JetspeedUser getUser(Principal principal) throws JetspeedSecurityException {
        return JetspeedUserManagement.getUser(principal);
    }

    public static Iterator getUsers() throws JetspeedSecurityException {
        return JetspeedUserManagement.getUsers();
    }

    public static void saveUser(JetspeedUser user) throws JetspeedSecurityException {
        JetspeedUserManagement.saveUser(user);
    }

    public static void addUser(JetspeedUser user) throws JetspeedSecurityException {
        JetspeedUserManagement.addUser(user);
    }

    public static Iterator getUsers(String filter) throws JetspeedSecurityException {
        return JetspeedUserManagement.getUsers(filter);
    }

    public static void removeUser(Principal principal) throws JetspeedSecurityException {
        JetspeedUserManagement.removeUser(principal);
    }

    public static JetspeedUser getUser(String username) throws JetspeedSecurityException {
        return JetspeedUserManagement.getUser(new UserNamePrincipal(username));
    }

    public static JetspeedUser getUser(RunData rundata, String username) throws JetspeedSecurityException {
        return JetspeedUserManagement.getUser(rundata, new UserNamePrincipal(username));
    }

    public static void removeUser(String username) throws JetspeedSecurityException {
        JetspeedUserManagement.removeUser(new UserNamePrincipal(username));
    }

    public static void changePassword(JetspeedUser user, String oldPassword, String newPassword) throws JetspeedSecurityException {
        JetspeedUserManagement.changePassword(user, oldPassword, newPassword);
    }

    public static void forcePassword(JetspeedUser user, String password) throws JetspeedSecurityException {
        JetspeedUserManagement.forcePassword(user, password);
    }

    public static String encryptPassword(String password) throws JetspeedSecurityException {
        return JetspeedUserManagement.encryptPassword(password);
    }

    public static Iterator getRoles(String username) throws JetspeedSecurityException {
        return JetspeedRoleManagement.getRoles(username);
    }

    public static Iterator getRoles() throws JetspeedSecurityException {
        return JetspeedRoleManagement.getRoles();
    }

    public static void addRole(Role role) throws JetspeedSecurityException {
        JetspeedRoleManagement.addRole(role);
    }

    public static void saveRole(Role role) throws JetspeedSecurityException {
        JetspeedRoleManagement.saveRole(role);
    }

    public static void removeRole(String rolename) throws JetspeedSecurityException {
        JetspeedRoleManagement.removeRole(rolename);
    }

    public static void grantRole(String username, String rolename) throws JetspeedSecurityException {
        JetspeedRoleManagement.grantRole(username, rolename);
    }

    public static void grantRole(String username, String rolename, String groupname) throws JetspeedSecurityException {
        JetspeedRoleManagement.grantRole(username, rolename, groupname);
    }

    public static void revokeRole(String username, String rolename) throws JetspeedSecurityException {
        JetspeedRoleManagement.revokeRole(username, rolename);
    }

    public static void revokeRole(String username, String rolename, String groupname) throws JetspeedSecurityException {
        JetspeedRoleManagement.revokeRole(username, rolename, groupname);
    }

    public static boolean hasRole(String username, String rolename) throws JetspeedSecurityException {
        return JetspeedRoleManagement.hasRole(username, rolename);
    }

    public static boolean hasRole(String username, String rolename, String groupname) throws JetspeedSecurityException {
        return JetspeedRoleManagement.hasRole(username, rolename, groupname);
    }

    public static Role getRole(String rolename) throws JetspeedSecurityException {
        return JetspeedRoleManagement.getRole(rolename);
    }

    public static Iterator getGroups(String username) throws JetspeedSecurityException {
        return JetspeedGroupManagement.getGroups(username);
    }

    public static Iterator getGroups() throws JetspeedSecurityException {
        return JetspeedGroupManagement.getGroups();
    }

    public static void addGroup(Group group) throws JetspeedSecurityException {
        JetspeedGroupManagement.addGroup(group);
    }

    public static void saveGroup(Group group) throws JetspeedSecurityException {
        JetspeedGroupManagement.saveGroup(group);
    }

    public static void removeGroup(String groupname) throws JetspeedSecurityException {
        JetspeedGroupManagement.removeGroup(groupname);
    }

    public static void joinGroup(String username, String groupname) throws JetspeedSecurityException {
        JetspeedGroupManagement.joinGroup(username, groupname);
    }

    public static void joinGroup(String username, String groupname, String rolename) throws JetspeedSecurityException {
        JetspeedGroupManagement.joinGroup(username, groupname, rolename);
    }

    public static void unjoinGroup(String username, String groupname) throws JetspeedSecurityException {
        JetspeedGroupManagement.unjoinGroup(username, groupname);
    }

    public static void unjoinGroup(String username, String groupname, String rolename) throws JetspeedSecurityException {
        JetspeedGroupManagement.unjoinGroup(username, groupname, rolename);
    }

    public static boolean inGroup(String username, String groupname) throws JetspeedSecurityException {
        return JetspeedGroupManagement.inGroup(username, groupname);
    }

    public static Group getGroup(String groupname) throws JetspeedSecurityException {
        return JetspeedGroupManagement.getGroup(groupname);
    }

    public static JetspeedUser getUserInstance() {
        return JetspeedSecurity.getService().getUserInstance();
    }

    public static String convertUserName(String username) {
        return JetspeedSecurity.getService().convertUserName(username);
    }

    public static String convertPassword(String password) {
        return JetspeedSecurity.getService().convertPassword(password);
    }

    public static boolean checkDisableAccount(String username) {
        return JetspeedSecurity.getService().checkDisableAccount(username);
    }

    public static boolean isDisableAccountCheckEnabled() {
        return JetspeedSecurity.getService().isDisableAccountCheckEnabled();
    }

    public static void resetDisableAccountCheck(String username) {
        JetspeedSecurity.getService().resetDisableAccountCheck(username);
    }

    public static boolean areActionsDisabledForAnon() {
        return JetspeedSecurity.getService().areActionsDisabledForAnon();
    }

    public static boolean areActionsDisabledForAllUsers() {
        return JetspeedSecurity.getService().areActionsDisabledForAllUsers();
    }

    public static String getAnonymousUserName() {
        return JetspeedSecurity.getService().getAnonymousUserName();
    }

    public static List getAdminRoles() {
        return JetspeedSecurity.getService().getAdminRoles();
    }

    public static boolean hasAdminRole(User user) {
        return JetspeedSecurity.getService().hasAdminRole(user);
    }

    public static boolean checkPermission(JetspeedRunData runData, String action, Portlet portlet) {
        return JetspeedSecurity.checkPermission(runData.getJetspeedUser(), portlet, action);
    }

    public static boolean checkPermission(JetspeedRunData runData, String action, RegistryEntry entry) {
        return JetspeedSecurity.checkPermission(runData.getJetspeedUser(), new PortalResource(entry), action);
    }

    public static Iterator getPermissions(String rolename) throws JetspeedSecurityException {
        return JetspeedPermissionManagement.getPermissions(rolename);
    }

    public static Iterator getPermissions() throws JetspeedSecurityException {
        return JetspeedPermissionManagement.getPermissions();
    }

    public static void addPermission(Permission permission) throws JetspeedSecurityException {
        JetspeedPermissionManagement.addPermission(permission);
    }

    public static void savePermission(Permission permission) throws JetspeedSecurityException {
        JetspeedPermissionManagement.savePermission(permission);
    }

    public static void removePermission(String permissionName) throws JetspeedSecurityException {
        JetspeedPermissionManagement.removePermission(permissionName);
    }

    public static void grantPermission(String roleName, String permissionName) throws JetspeedSecurityException {
        JetspeedPermissionManagement.grantPermission(roleName, permissionName);
    }

    public static void revokePermission(String roleName, String permissionName) throws JetspeedSecurityException {
        JetspeedPermissionManagement.revokePermission(roleName, permissionName);
    }

    public static boolean hasPermission(String roleName, String permissionName) throws JetspeedSecurityException {
        return JetspeedPermissionManagement.hasPermission(roleName, permissionName);
    }

    public static Permission getPermission(String permissionName) throws JetspeedSecurityException {
        return JetspeedPermissionManagement.getPermission(permissionName);
    }

    private static String generatePassword(int length, char[] characters) throws JetspeedSecurityException {
        String password = "";
        int randomNumber = 0;
        for (int ia = 0; ia < length; ++ia) {
            randomNumber = (int)(Math.random() * (double)NUMBERS_AND_LETTERS_ALPHABET.length);
            password = password + characters[randomNumber];
        }
        return password;
    }

    public static String generateMixedCasePassword(int length) throws JetspeedSecurityException {
        return JetspeedSecurity.generatePassword(length, NUMBERS_AND_LETTERS_ALPHABET);
    }

    public static String generateLowerCasePassword(int length) throws JetspeedSecurityException {
        return JetspeedSecurity.generatePassword(length, LC_NUMBERS_AND_LETTERS_ALPHABET).toLowerCase();
    }

    public static String generateUpperCasePassword(int length) throws JetspeedSecurityException {
        return JetspeedSecurity.generatePassword(length, LC_NUMBERS_AND_LETTERS_ALPHABET).toUpperCase();
    }

    public static SecurityReference getSecurityReference(Entry entry, JetspeedRunData rundata) {
        PortletEntry pEntry = null;
        if (entry != null) {
            pEntry = (PortletEntry)Registry.getEntry(Registry.PORTLET, entry.getParent());
        }
        SecurityReference securityRef = null;
        if (entry != null) {
            securityRef = entry.getSecurityRef();
        }
        if (securityRef == null && pEntry != null) {
            securityRef = pEntry.getSecurityRef();
        }
        if (securityRef == null && rundata != null) {
            securityRef = PortalToolkit.getDefaultSecurityRef(rundata.getProfile());
        }
        return securityRef;
    }

    public static int getSecuritySource(Entry entry, JetspeedRunData rundata) {
        PortletEntry pEntry = (PortletEntry)Registry.getEntry(Registry.PORTLET, entry.getParent());
        if (entry.getSecurityRef() != null) {
            return 0;
        }
        if (pEntry != null && pEntry.getSecurityRef() != null) {
            return 1;
        }
        return 2;
    }
}

